/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.StyledTextEvent;
import org.eclipse.swt.custom.StyledTextRenderer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;

class DisplayRenderer
extends StyledTextRenderer {
    private StyledText parent;
    private int topIndex = -1;
    private TextLayout[] layouts;

    DisplayRenderer(Device device, Font regularFont, StyledText parent, int tabLength) {
        super(device, regularFont);
        this.parent = parent;
        this.calculateLineHeight();
        this.setTabLength(tabLength);
    }

    void dispose() {
        super.dispose();
        if (this.layouts != null) {
            for (int i = 0; i < this.layouts.length; ++i) {
                TextLayout layout = this.layouts[i];
                if (layout == null) continue;
                super.disposeTextLayout(layout);
            }
            this.topIndex = -1;
            this.layouts = null;
        }
    }

    protected void disposeGC(GC gc) {
        gc.dispose();
    }

    protected void drawLineBreakSelection(String line, int lineOffset, int paintX, int paintY, GC gc) {
        Point selection = this.parent.internalGetSelection();
        int lineLength = line.length();
        int selectionStart = Math.max(0, selection.x - lineOffset);
        int selectionEnd = selection.y - lineOffset;
        int lineEndSpaceWidth = this.getLineEndSpaceWidth();
        int lineHeight = this.getLineHeight();
        if (selectionEnd == selectionStart || selectionEnd < 0 || selectionStart > lineLength || selectionEnd <= lineLength) {
            return;
        }
        gc.setBackground(this.parent.getSelectionBackground());
        gc.setForeground(this.parent.getSelectionForeground());
        if ((this.parent.getStyle() & 0x10000) != 0) {
            Rectangle rect = this.getClientArea();
            gc.fillRectangle(paintX, paintY, rect.width - paintX, lineHeight);
        } else {
            int lineEnd;
            StyledTextContent content;
            int lineIndex;
            boolean isWrappedLine = false;
            if (this.parent.internalGetWordWrap() && (lineIndex = (content = this.getContent()).getLineAtOffset(lineEnd = lineOffset + lineLength)) < content.getLineCount() - 1 && content.getOffsetAtLine(lineIndex + 1) == lineEnd) {
                isWrappedLine = true;
            }
            if (!isWrappedLine) {
                gc.fillRectangle(paintX, paintY, lineEndSpaceWidth, lineHeight);
            }
        }
    }

    protected int[] getBidiSegments(int lineOffset, String lineText) {
        if (!this.parent.isBidi()) {
            return null;
        }
        return this.parent.getBidiSegments(lineOffset, lineText);
    }

    protected Rectangle getClientArea() {
        return this.parent.getClientArea();
    }

    protected StyledTextContent getContent() {
        return this.parent.internalGetContent();
    }

    protected GC getGC() {
        return new GC(this.parent);
    }

    protected int getHorizontalPixel() {
        return this.parent.internalGetHorizontalPixel();
    }

    protected int getLeftMargin() {
        return this.parent.leftMargin;
    }

    protected StyledTextEvent getLineBackgroundData(int lineOffset, String line) {
        return this.parent.getLineBackgroundData(lineOffset, line);
    }

    protected StyledTextEvent getLineStyleData(int lineOffset, String line) {
        StyledTextEvent logicalLineEvent = this.parent.getLineStyleData(lineOffset, line);
        if (logicalLineEvent != null) {
            logicalLineEvent = this.getLineStyleData(logicalLineEvent, lineOffset, line);
        }
        return logicalLineEvent;
    }

    protected int getOrientation() {
        return this.parent.getOrientation();
    }

    protected int getRightMargin() {
        return this.parent.rightMargin;
    }

    protected Color getSelectionBackground() {
        return this.parent.getSelectionBackground();
    }

    protected Color getSelectionForeground() {
        return this.parent.getSelectionForeground();
    }

    protected Point getSelection() {
        return this.parent.internalGetSelection();
    }

    protected boolean getWordWrap() {
        return this.parent.getWordWrap();
    }

    protected boolean isFullLineSelection() {
        return (this.parent.getStyle() & 0x10000) != 0;
    }

    TextLayout createTextLayout(int lineOffset) {
        if (!this.parent.internalGetWordWrap()) {
            int layoutIndex;
            int lineIndex = this.getContent().getLineAtOffset(lineOffset);
            this.updateTopIndex();
            if (this.layouts != null && 0 <= (layoutIndex = lineIndex - this.topIndex) && layoutIndex < this.layouts.length) {
                TextLayout layout = this.layouts[layoutIndex];
                if (layout != null) {
                    return layout;
                }
                this.layouts[layoutIndex] = super.createTextLayout(lineIndex);
                return this.layouts[layoutIndex];
            }
        }
        return super.createTextLayout(lineOffset);
    }

    void disposeTextLayout(TextLayout layout) {
        if (this.layouts != null) {
            for (int i = 0; i < this.layouts.length; ++i) {
                if (this.layouts[i] != layout) continue;
                return;
            }
        }
        super.disposeTextLayout(layout);
    }

    void updateTopIndex() {
        int verticalIncrement = this.parent.getVerticalIncrement();
        int topIndex = verticalIncrement == 0 ? 0 : this.parent.verticalScrollOffset / verticalIncrement;
        int newLength = Math.max(1, this.parent.getPartialBottomIndex() - topIndex + 1);
        if (this.layouts == null || topIndex != this.topIndex || newLength != this.layouts.length) {
            TextLayout[] newLayouts = new TextLayout[newLength];
            if (this.layouts != null) {
                for (int i = 0; i < this.layouts.length; ++i) {
                    TextLayout layout = this.layouts[i];
                    if (layout == null) continue;
                    int layoutIndex = i + this.topIndex - topIndex;
                    if (0 <= layoutIndex && layoutIndex < newLayouts.length) {
                        newLayouts[layoutIndex] = layout;
                        continue;
                    }
                    super.disposeTextLayout(layout);
                }
            }
            this.topIndex = topIndex;
            this.layouts = newLayouts;
        }
    }
}

