/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Header;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.SelectableItem;
import org.eclipse.swt.widgets.SelectableItemWidget;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class Table
extends SelectableItemWidget {
    private static final int COLUMN_RESIZE_OFFSET = 7;
    static final String DOT_STRING = "...";
    private Header tableHeader;
    private Vector items;
    private Vector columns;
    private boolean drawGridLines = false;
    private boolean firstColumnImage = false;
    private int columnResizeX;
    private Cursor columnResizeCursor;
    private boolean isColumnResizeCursor = false;
    private TableColumn resizeColumn;
    private TableColumn fillColumn;
    private TableColumn defaultColumn;
    private int fontHeight;
    private boolean ignoreRedraw;

    public Table(Composite parent, int style) {
        super(parent, Table.checkStyle(style | 0x100000));
    }

    void addColumn(TableColumn column) {
        int columnCount;
        int index = column.getIndex();
        this.getColumnVector().insertElementAt(column, index);
        if (index < this.getColumnCount() - 1) {
            this.reindexColumns(index + 1);
        }
        if ((columnCount = this.getColumnCount()) > 1) {
            this.insertColumnData(column);
            Enumeration items = this.getItemVector().elements();
            while (items.hasMoreElements()) {
                Font[] cellFont;
                Color[] cellForeground;
                TableItem item = (TableItem)items.nextElement();
                Color[] cellBackground = item.cellBackground;
                if (cellBackground != null) {
                    Color[] temp = new Color[columnCount];
                    System.arraycopy(cellBackground, 0, temp, 0, index);
                    System.arraycopy(cellBackground, index, temp, index + 1, columnCount - index - 1);
                    item.cellBackground = temp;
                }
                if ((cellForeground = item.cellForeground) != null) {
                    Color[] temp = new Color[columnCount];
                    System.arraycopy(cellForeground, 0, temp, 0, index);
                    System.arraycopy(cellForeground, index, temp, index + 1, columnCount - index - 1);
                    item.cellForeground = temp;
                }
                if ((cellFont = item.cellFont) == null) continue;
                Font[] temp = new Font[columnCount];
                System.arraycopy(cellFont, 0, temp, 0, index);
                System.arraycopy(cellFont, index, temp, index + 1, columnCount - index - 1);
                item.cellFont = temp;
            }
        } else {
            this.setContentWidth(0);
            this.redraw();
            this.getHeader().redraw();
        }
        this.insertColumnVisual(column);
    }

    void addItem(TableItem item, int index) {
        Vector items = this.getItemVector();
        if (index < 0 || index > this.getItemCount()) {
            this.error(6);
        }
        this.addingItem(item, index);
        item.setIndex(index);
        if (index < items.size()) {
            for (int i = index; i < items.size(); ++i) {
                TableItem anItem = (TableItem)items.elementAt(i);
                anItem.setIndex(anItem.getIndex() + 1);
            }
            items.insertElementAt(item, index);
        } else {
            items.addElement(item);
        }
        this.addedItem(item, index);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Table.checkBits(style, 4, 2, 0, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clear(int index) {
        this.checkWidget();
        if (0 > index || index >= this.getItemCount()) {
            this.error(6);
        }
        TableItem item = (TableItem)this.getVisibleItem(index);
        item.clear();
        int y = this.getRedrawY(item);
        this.redraw(0, y, this.getClientArea().width, this.getItemHeight(), false);
    }

    public void clear(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        if (0 > start || start > end || end >= this.getItemCount()) {
            this.error(6);
        }
        if (start == 0 && end == this.getItemCount() - 1) {
            this.clearAll();
        } else {
            for (int i = start; i <= end; ++i) {
                this.clear(i);
            }
        }
    }

    public void clear(int[] indices) {
        int i;
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        for (i = 0; i < indices.length; ++i) {
            if (0 <= indices[i] && indices[i] < this.getItemCount()) continue;
            this.error(6);
        }
        for (i = 0; i < indices.length; ++i) {
            this.clear(indices[i]);
        }
    }

    public void clearAll() {
        this.checkWidget();
        for (int i = 0; i < this.getItemCount(); ++i) {
            TableItem item = (TableItem)this.getVisibleItem(i);
            item.clear();
        }
        this.redraw();
    }

    void columnChange(TableColumn column, Rectangle newBounds) {
        Rectangle columnBounds = column.getBounds();
        Rectangle clientArea = this.getClientArea();
        int oldXPosition = columnBounds.x + columnBounds.width;
        int newXPosition = newBounds.x + newBounds.width;
        int widthChange = newBounds.width - columnBounds.width;
        int headerHeight = this.getHeaderHeight();
        int columnIndex = column.getIndex();
        if (widthChange != 0) {
            this.getHeader().widthChange(columnIndex, widthChange);
            if (columnIndex != -1) {
                if (this.getLinesVisible()) {
                    oldXPosition -= this.getGridLineWidth();
                    newXPosition -= this.getGridLineWidth();
                }
                this.scroll(newXPosition, headerHeight, oldXPosition, headerHeight, clientArea.width, clientArea.height, true);
            }
            column.internalSetBounds(newBounds);
            if (columnIndex != -1) {
                this.resetTableItems(columnIndex);
                this.moveColumns(columnIndex + 1, widthChange);
                this.setContentWidth(this.getContentWidth() + widthChange);
                this.claimRightFreeSpace();
                this.resizeRedraw(column, columnBounds.width, newBounds.width);
            }
        }
    }

    void columnMouseDoubleClick(Event event) {
        int itemIndex;
        TableItem hitItem;
        boolean isFullSelection;
        if (!this.isFocusControl()) {
            this.forceFocus();
        }
        if (this.getIgnoreDoubleClick()) {
            return;
        }
        int itemHeight = this.getItemHeight();
        TableColumn hitColumn = this.getColumnAtX(event.x);
        boolean bl = isFullSelection = (this.getStyle() & 0x10000) != 0;
        if (hitColumn != null && (hitItem = (TableItem)this.getVisibleItem(itemIndex = (event.y - this.getHeaderHeight()) / itemHeight + this.getTopIndex())) != null && (hitColumn.getIndex() == 0 || isFullSelection) && hitItem.isSelectionHit(event.x)) {
            Event columnDblClickEvent = new Event();
            columnDblClickEvent.item = hitItem;
            this.postEvent(14, columnDblClickEvent);
        }
    }

    void columnMouseDown(Event event) {
        int itemIndex;
        TableItem hitItem;
        int itemHeight = this.getItemHeight();
        TableColumn hitColumn = this.getColumnAtX(event.x);
        if (!this.isFocusControl()) {
            this.forceFocus();
        }
        if (hitColumn != null && (hitItem = (TableItem)this.getVisibleItem(itemIndex = (event.y - this.getHeaderHeight()) / itemHeight + this.getTopIndex())) != null) {
            if (hitItem.isSelectionHit(event.x)) {
                this.doMouseSelect(hitItem, itemIndex, event.stateMask, event.button);
            } else if (hitItem.isCheckHit(new Point(event.x, event.y))) {
                if (event.button != 1) {
                    return;
                }
                this.doCheckItem(hitItem);
            }
        }
    }

    void columnMouseMove(Event event) {
        if (!this.isColumnResizeStarted()) {
            this.setColumnResizeCursor(false);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point size = super.computeSize(wHint, hHint, changed);
        int WidthCalculationCount = Math.min(this.getItemCount(), 50);
        int newItemWidth = 0;
        if (this.getHeaderVisible() && hHint == -1) {
            Point headerSize = this.getHeader().computeSize(-1, -1, false);
            size.y += headerSize.y;
        }
        if (this.getContentWidth() == 0 && WidthCalculationCount > 0) {
            TableItem item;
            GC gc = new GC(this);
            for (int i = 0; i < WidthCalculationCount && (item = this.getItem(i)) != null; ++i) {
                Image itemImage = item.getImage();
                String itemText = item.getText();
                int width = 0;
                if (itemImage != null) {
                    width += itemImage.getBounds().width;
                }
                if (itemText != null) {
                    gc.setFont(item.getFont());
                    width += gc.stringExtent((String)itemText).x;
                }
                newItemWidth = Math.max(newItemWidth, width);
            }
            if (newItemWidth > 0) {
                size.x = newItemWidth;
            }
            gc.dispose();
        }
        return size;
    }

    public void deselect(int[] indices) {
        this.checkWidget();
        SelectableItem item = null;
        if (indices == null) {
            this.error(4);
        }
        for (int i = 0; i < indices.length; ++i) {
            item = this.getVisibleItem(indices[i]);
            if (item == null) continue;
            this.deselect(item);
        }
        if (item != null) {
            this.setLastSelection(item, false);
        }
    }

    public void deselect(int index) {
        this.checkWidget();
        SelectableItem item = this.getVisibleItem(index);
        if (item != null) {
            this.deselect(item);
            this.setLastSelection(item, false);
        }
    }

    public void deselect(int start, int end) {
        this.checkWidget();
        SelectableItem item = null;
        for (int i = start; i <= end; ++i) {
            item = this.getVisibleItem(i);
            if (item == null) continue;
            this.deselect(item);
        }
        if (item != null) {
            this.setLastSelection(item, false);
        }
    }

    public void deselectAll() {
        this.checkWidget();
        this.deselectAllExcept((SelectableItem)null);
    }

    void doDispose() {
        Vector items = this.getItemVector();
        super.doDispose();
        for (int i = items.size() - 1; i >= 0; --i) {
            ((TableItem)items.elementAt(i)).dispose();
        }
        this.setItemVector(null);
        items = this.getColumnVector();
        while (items.size() > 0) {
            ((TableColumn)items.lastElement()).dispose();
        }
        this.resizeColumn = null;
        this.fillColumn = null;
        this.defaultColumn = null;
        if (this.columnResizeCursor != null) {
            this.columnResizeCursor.dispose();
        }
    }

    void drawColumnResizeLine(int xPosition) {
        GC gc = new GC(this);
        int lineHeight = this.getClientArea().height;
        int lineWidth = this.getGridLineWidth();
        this.redraw(this.getColumnResizeX() - lineWidth, 0, 1, lineHeight, false);
        this.setColumnResizeX(xPosition);
        gc.drawLine(xPosition - lineWidth, 0, xPosition - lineWidth, lineHeight);
        gc.dispose();
    }

    void drawGridLines(Event event, Enumeration drawColumns) {
        GC gc = event.gc;
        Color oldForeground = this.getForeground();
        int lineWidth = this.getGridLineWidth();
        int itemHeight = this.getItemHeight();
        int headerHeight = this.getHeaderHeight();
        int lineYStopPosition = event.y + event.height;
        gc.setForeground(this.display.getSystemColor(19));
        if (itemHeight > 0) {
            for (int lineYPosition = headerHeight + (event.y - headerHeight) / itemHeight * itemHeight; lineYPosition < lineYStopPosition; lineYPosition += itemHeight) {
                gc.drawLine(event.x, lineYPosition + itemHeight - lineWidth, event.x + event.width, lineYPosition + itemHeight - lineWidth);
            }
        }
        while (drawColumns.hasMoreElements()) {
            TableColumn column = (TableColumn)drawColumns.nextElement();
            if (column.getIndex() == -1) continue;
            Rectangle columnBounds = column.getBounds();
            int lineXPosition = columnBounds.x + columnBounds.width - lineWidth;
            gc.drawLine(lineXPosition, event.y, lineXPosition, event.y + event.height);
        }
        gc.setForeground(oldForeground);
    }

    void drawSelectionFocus(TableItem item, GC gc) {
        Point extent = item.getSelectionExtent();
        Point position = new Point(item.getImageStopX(0) + this.getHorizontalOffset(), this.getRedrawY(item));
        gc.drawFocus(position.x, position.y, extent.x, extent.y);
    }

    public Control[] getChildren() {
        this.checkWidget();
        Control[] controls = this._getChildren();
        if (this.tableHeader == null) {
            return controls;
        }
        Control[] result = new Control[controls.length - 1];
        int index = 0;
        for (int i = 0; i < controls.length; ++i) {
            if (controls[i] == this.tableHeader) continue;
            result[index++] = controls[i];
        }
        return result;
    }

    public TableColumn getColumn(int index) {
        this.checkWidget();
        Vector columns = this.getColumnVector();
        if (columns == null) {
            this.error(8);
        }
        if (index < 0 || index >= columns.size()) {
            this.error(6);
        }
        return (TableColumn)columns.elementAt(index);
    }

    TableColumn getColumnAtX(int xPosition) {
        Rectangle bounds;
        TableColumn column;
        Enumeration columns = this.internalGetColumnVector().elements();
        TableColumn hitColumn = null;
        while (columns.hasMoreElements() && hitColumn == null) {
            column = (TableColumn)columns.nextElement();
            bounds = column.getBounds();
            if (xPosition < bounds.x || xPosition > bounds.x + bounds.width) continue;
            hitColumn = column;
        }
        if (hitColumn == null) {
            column = this.getFillColumn();
            bounds = column.getBounds();
            if (xPosition >= bounds.x && xPosition <= bounds.x + bounds.width) {
                hitColumn = column;
            }
        }
        return hitColumn;
    }

    public int getColumnCount() {
        this.checkWidget();
        Vector columns = this.getColumnVector();
        int count = 0;
        if (columns != null) {
            count = columns.size();
        }
        return count;
    }

    Cursor getColumnResizeCursor() {
        if (this.columnResizeCursor == null) {
            this.columnResizeCursor = new Cursor(this.display, 9);
        }
        return this.columnResizeCursor;
    }

    int getColumnResizeX() {
        return this.columnResizeX;
    }

    public TableColumn[] getColumns() {
        this.checkWidget();
        Vector columns = this.getColumnVector();
        Object[] columnArray = new TableColumn[columns.size()];
        columns.copyInto(columnArray);
        return columnArray;
    }

    Vector getColumnVector() {
        return this.columns;
    }

    TableColumn getDefaultColumn() {
        return this.defaultColumn;
    }

    TableColumn getFillColumn() {
        return this.fillColumn;
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 1;
    }

    Header getHeader() {
        return this.tableHeader;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        Header header = this.getHeader();
        int height = 0;
        if (header.getVisible()) {
            height = header.getBounds().height;
        }
        return height;
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return this.getHeader().getVisible();
    }

    Point getImageExtent(SelectableItem item) {
        Image image = null;
        Point imageExtent = null;
        int columnCount = this.internalGetColumnCount();
        for (int i = 0; i < columnCount && image == null; ++i) {
            image = ((TableItem)item).getImage(i);
        }
        if (image != null) {
            Rectangle imageBounds = image.getBounds();
            imageExtent = new Point(imageBounds.width, imageBounds.height);
        }
        return imageExtent;
    }

    int getIndex(SelectableItem item) {
        int index = -1;
        if (item != null && item.getSelectableParent() == this) {
            index = ((TableItem)item).getIndex();
        }
        return index;
    }

    public TableItem getItem(int index) {
        this.checkWidget();
        if (0 > index || index >= this.getItemCount()) {
            this.error(6);
        }
        return (TableItem)this.getVisibleItem(index);
    }

    public TableItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        TableColumn column = this.getColumnAtX(point.x);
        if ((this.style & 0x10000) == 0 && column != null && column.getIndex() != 0) {
            return null;
        }
        TableItem item = null;
        int headerHeight = this.getHeaderHeight();
        if (column != null && column.getIndex() != -1 && point.y - headerHeight > 0) {
            int itemIndex = (point.y - headerHeight) / this.getItemHeight() + this.getTopIndex();
            item = (TableItem)this.getVisibleItem(itemIndex);
            if ((this.style & 0x10000) == 0 && item != null) {
                Point itemSize = item.getItemExtent(column);
                if (point.x - column.getBounds().x > itemSize.x) {
                    item = null;
                }
            }
        }
        return item;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.getItemVector().size();
    }

    int getItemCountWhole() {
        int clientAreaHeight = Math.max(0, this.getClientArea().height - this.getHeaderHeight());
        return clientAreaHeight / this.getItemHeight();
    }

    public int getItemHeight() {
        this.checkWidget();
        return super.getItemHeight();
    }

    int getItemPadding() {
        return this.getGridLineWidth() + this.display.textHighlightThickness + 1;
    }

    public TableItem[] getItems() {
        this.checkWidget();
        Vector items = this.getItemVector();
        Object[] itemArray = new TableItem[items.size()];
        items.copyInto(itemArray);
        return itemArray;
    }

    Vector getItemVector() {
        return this.items;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return this.drawGridLines;
    }

    Vector getPaintColumns(Rectangle paintArea) {
        Enumeration columns = this.internalGetColumnVector().elements();
        Vector<TableColumn> paintColumns = new Vector<TableColumn>();
        int paintAreaRightBorder = paintArea.x + paintArea.width;
        while (columns.hasMoreElements()) {
            TableColumn column = (TableColumn)columns.nextElement();
            Rectangle columnBounds = column.getBounds();
            if (columnBounds.x + columnBounds.width < paintArea.x || columnBounds.x > paintAreaRightBorder) continue;
            paintColumns.addElement(column);
        }
        return paintColumns;
    }

    int getPreferredColumnWidth(int columnIndex) {
        Enumeration tableItems = this.getItemVector().elements();
        int width = 0;
        if (columnIndex != -1) {
            int headerWidth;
            if ((this.parent.getStyle() & 0x10000000) == 0) {
                while (tableItems.hasMoreElements()) {
                    TableItem tableItem = (TableItem)tableItems.nextElement();
                    width = Math.max(width, tableItem.getPreferredWidth(columnIndex));
                }
            }
            if (width < (headerWidth = this.getHeader().getPreferredWidth(columnIndex))) {
                width = headerWidth;
            }
        }
        return width;
    }

    int getRedrawY(SelectableItem item) {
        int redrawY = super.getRedrawY(item);
        if (redrawY != -1) {
            redrawY += this.getHeaderHeight();
        }
        return redrawY;
    }

    TableColumn getResizeColumn() {
        return this.resizeColumn;
    }

    int[] getResizeRedrawX(int columnIndex, int columnWidth) {
        int topIndex = this.getTopIndex();
        int bottomIndex = this.getBottomIndex();
        bottomIndex = Math.min(bottomIndex, this.getItemCount());
        int[] resizeRedrawX = new int[bottomIndex - topIndex + 1];
        for (int i = topIndex; i < bottomIndex; ++i) {
            TableItem item = (TableItem)this.getVisibleItem(i);
            resizeRedrawX[i - topIndex] = item.getDotStartX(columnIndex, columnWidth);
        }
        return resizeRedrawX;
    }

    public TableItem[] getSelection() {
        this.checkWidget();
        Vector selectionVector = this.getSelectionVector();
        Object[] selectionArray = new TableItem[selectionVector.size()];
        selectionVector.copyInto(selectionArray);
        this.sort((SelectableItem[])selectionArray, 0, selectionArray.length);
        return selectionArray;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return super.getSelectionCount();
    }

    int getFontHeight() {
        return this.fontHeight;
    }

    Point getFullSelectionExtent(TableItem item) {
        TableColumn lastColumn = (TableColumn)this.internalGetColumnVector().lastElement();
        Point selectionExtent = null;
        int xPosition = item.getImageStopX(0);
        int gridLineWidth = this.getGridLineWidth();
        if (lastColumn != null) {
            Rectangle columnBounds = lastColumn.getBounds();
            selectionExtent = new Point(columnBounds.x - this.getHorizontalOffset() + columnBounds.width - xPosition - gridLineWidth, this.getItemHeight());
            if (this.getLinesVisible()) {
                selectionExtent.y -= gridLineWidth;
            }
        }
        return selectionExtent;
    }

    public int getSelectionIndex() {
        this.checkWidget();
        int index = -1;
        if (this.getSelectionCount() > 0) {
            index = this.getIndex(this.getSelection()[0]);
        }
        return index;
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        TableItem[] items = this.getSelection();
        int[] indices = new int[items.length];
        for (int i = 0; i < items.length; ++i) {
            indices[i] = this.getIndex(items[i]);
        }
        return indices;
    }

    public int getTopIndex() {
        this.checkWidget();
        return super.getTopIndex();
    }

    int getVisibleIndex(SelectableItem item) {
        return this.getIndex(item);
    }

    SelectableItem getVisibleItem(int itemIndex) {
        Vector items = this.getItemVector();
        TableItem item = null;
        if (items != null && itemIndex >= 0 && itemIndex < items.size()) {
            item = (TableItem)items.elementAt(itemIndex);
        }
        return item;
    }

    int getVisibleRedrawY(SelectableItem item) {
        int index;
        int redrawY = -1;
        int bottomIndex = this.getBottomIndex();
        if (item == null) {
            return redrawY;
        }
        for (index = this.getTopIndex(); index < bottomIndex && !item.equals(this.getVisibleItem(index)); ++index) {
        }
        if (index < bottomIndex) {
            redrawY = this.getRedrawY(item);
        }
        return redrawY;
    }

    void handleEvents(Event event) {
        switch (event.type) {
            case 5: {
                if (event.widget == this.tableHeader) {
                    this.headerMouseMove(event);
                    break;
                }
                this.columnMouseMove(event);
                break;
            }
            case 3: {
                if (event.widget == this.tableHeader) {
                    this.headerMouseDown(event);
                    break;
                }
                this.columnMouseDown(event);
                break;
            }
            case 8: {
                if (event.widget == this.tableHeader) {
                    this.headerMouseDoubleClick(event);
                    break;
                }
                this.columnMouseDoubleClick(event);
                break;
            }
            case 4: {
                this.mouseUp(event);
                break;
            }
            case 9: {
                this.paint(event);
                break;
            }
            default: {
                super.handleEvents(event);
            }
        }
    }

    boolean hasFirstColumnImage() {
        return this.firstColumnImage;
    }

    void headerMouseDown(Event event) {
        TableColumn column = this.getColumnAtX(event.x);
        if (event.button != 1) {
            return;
        }
        if (this.isColumnResize(event)) {
            this.startColumnResize(event);
        } else if (column != null) {
            column.notifyListeners(13, new Event());
        }
    }

    void headerMouseDoubleClick(Event event) {
        if (event.button != 1) {
            return;
        }
        TableColumn column = this.getColumnAtX(event.x);
        if (column != null) {
            column.notifyListeners(14, new Event());
        }
    }

    void headerMouseMove(Event event) {
        if (!this.isColumnResizeStarted()) {
            this.setColumnResizeCursor(this.isColumnResize(event));
        } else if (event.x >= this.getResizeColumn().getBounds().x) {
            this.drawColumnResizeLine(event.x);
            this.update();
        }
    }

    public int indexOf(TableColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        return this.internalGetColumnVector().indexOf(column);
    }

    public int indexOf(TableItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        return this.getIndex(item);
    }

    void initialize() {
        this.columns = new Vector();
        this.setItemVector(new Vector());
        GC gc = new GC(this);
        Point extent = gc.stringExtent("String");
        this.fontHeight = extent.y;
        gc.dispose();
        this.tableHeader = new Header(this);
        this.tableHeader.setVisible(false);
        this.fillColumn = TableColumn.createFillColumn(this);
        this.setColumnPosition(this.fillColumn);
        this.defaultColumn = TableColumn.createDefaultColumn(this);
        super.initialize();
    }

    void insertColumnData(TableColumn column) {
        Enumeration tableItems = this.getItemVector().elements();
        while (tableItems.hasMoreElements()) {
            TableItem tableItem = (TableItem)tableItems.nextElement();
            tableItem.insertColumn(column);
        }
    }

    void insertColumnVisual(TableColumn column) {
        Rectangle columnBounds = column.getBounds();
        int index = column.getIndex();
        if (index > 0) {
            Rectangle previousColumnBounds = this.getColumn(index - 1).getBounds();
            columnBounds.x = previousColumnBounds.x + previousColumnBounds.width;
        } else {
            columnBounds.x = 0;
        }
        column.setBounds(columnBounds);
        this.setColumnPosition(column);
    }

    void installListeners() {
        Header tableHeader = this.getHeader();
        Listener listener = this.getListener();
        super.installListeners();
        tableHeader.addListener(5, listener);
        tableHeader.addListener(3, listener);
        tableHeader.addListener(8, listener);
        tableHeader.addListener(4, listener);
        this.addListener(5, listener);
        this.addListener(3, listener);
        this.addListener(8, listener);
        this.addListener(4, listener);
        this.addListener(9, listener);
    }

    TableColumn internalGetColumn(int index) {
        Vector columns = this.internalGetColumnVector();
        if (columns == null) {
            this.error(8);
        }
        if (index < 0 || index >= columns.size()) {
            this.error(6);
        }
        return (TableColumn)columns.elementAt(index);
    }

    int internalGetColumnCount() {
        Vector columns = this.internalGetColumnVector();
        int count = 0;
        if (columns != null) {
            count = columns.size();
        }
        return count;
    }

    Vector internalGetColumnVector() {
        Vector<TableColumn> internalColumnVector;
        if (!this.columns.isEmpty()) {
            internalColumnVector = this.columns;
        } else {
            internalColumnVector = new Vector<TableColumn>(1);
            TableColumn defaultColumn = this.getDefaultColumn();
            if (defaultColumn != null) {
                internalColumnVector.addElement(defaultColumn);
            }
        }
        return internalColumnVector;
    }

    boolean isColumnResize(Event event) {
        TableColumn hotColumn = this.getColumnAtX(event.x);
        if (hotColumn == null) {
            return false;
        }
        Rectangle bounds = hotColumn.getBounds();
        int hotColumnIndex = hotColumn.getIndex();
        int columnX = event.x - bounds.x;
        boolean isColumnResize = false;
        if (columnX <= 7 && hotColumnIndex != 0) {
            hotColumn = hotColumnIndex == -1 ? (TableColumn)this.internalGetColumnVector().lastElement() : this.internalGetColumn(hotColumnIndex - 1);
            isColumnResize = hotColumn.getResizable();
        } else if (columnX >= bounds.width - 7 && hotColumn != this.getFillColumn()) {
            isColumnResize = hotColumn.getResizable();
        }
        return isColumnResize;
    }

    boolean isColumnResizeStarted() {
        return this.getResizeColumn() != null;
    }

    public boolean isSelected(int index) {
        this.checkWidget();
        TableItem item = this.getItem(index);
        return item != null && item.isSelected();
    }

    void itemChanged(SelectableItem changedItem, int repaintStartX, int repaintWidth) {
        super.itemChanged(changedItem, repaintStartX, repaintWidth);
        if (!this.firstColumnImage && changedItem.getImage() != null) {
            this.firstColumnImage = true;
            this.redraw();
        }
        this.setFirstColumnWidth((TableItem)changedItem);
    }

    void mouseUp(Event event) {
        TableColumn resizeColumn = this.getResizeColumn();
        if (this.isColumnResizeStarted()) {
            Rectangle oldColumnBounds = resizeColumn.getBounds();
            int resizeXPosition = this.getColumnResizeX();
            int widthChange = resizeXPosition - (oldColumnBounds.x + oldColumnBounds.width);
            if (widthChange >= 0) {
                this.redraw(resizeXPosition - this.getGridLineWidth(), 0, 1, this.getClientArea().height, false);
                this.update();
            }
            if (widthChange != 0) {
                resizeColumn.setWidth(oldColumnBounds.width + widthChange);
            }
            this.setResizeColumn(null);
        }
    }

    void moveColumns(int startIndex, int moveDistance) {
        Rectangle columnBounds;
        TableColumn moveColumn;
        Vector columns = this.internalGetColumnVector();
        if (startIndex == -1) {
            moveColumn = this.getFillColumn();
            columnBounds = moveColumn.getBounds();
            columnBounds.x += moveDistance;
            moveColumn.setBounds(columnBounds);
            startIndex = 0;
        }
        for (int i = startIndex; i < columns.size(); ++i) {
            moveColumn = (TableColumn)columns.elementAt(i);
            columnBounds = moveColumn.getBounds();
            columnBounds.x += moveDistance;
            moveColumn.setBounds(columnBounds);
        }
    }

    void moveColumnsVertical() {
        Enumeration columns = this.internalGetColumnVector().elements();
        this.setColumnPosition(this.getFillColumn());
        while (columns.hasMoreElements()) {
            TableColumn column = (TableColumn)columns.nextElement();
            this.setColumnPosition(column);
        }
    }

    void paint(Event event) {
        int headerHeight = this.getHeaderHeight();
        Vector paintColumns = this.getPaintColumns(event.getBounds());
        TableItem focusItem = null;
        if (paintColumns.size() > 0) {
            event.y -= headerHeight;
            int[] visibleRange = this.getIndexRange(event.getBounds());
            event.y += headerHeight;
            if (visibleRange[0] < 0) {
                visibleRange[0] = 0;
            }
            visibleRange[1] = Math.min(visibleRange[1], this.getItemCount() - 1 - this.getTopIndex());
            focusItem = this.paintItems(event, visibleRange[0], visibleRange[1], paintColumns);
        }
        if (this.getLinesVisible()) {
            this.drawGridLines(event, paintColumns.elements());
        }
        if (focusItem != null) {
            this.drawSelectionFocus(focusItem, event.gc);
        }
    }

    TableItem paintItems(Event event, int topPaintIndex, int bottomPaintIndex, Vector paintColumns) {
        TableItem paintItem;
        int i;
        TableItem focusItem = null;
        GC gc = event.gc;
        Color selectionColor = this.display.getSystemColor(26);
        topPaintIndex += this.getTopIndex();
        bottomPaintIndex += this.getTopIndex();
        if ((this.getStyle() & 0x10000000) != 0) {
            for (i = topPaintIndex; i <= bottomPaintIndex; ++i) {
                paintItem = (TableItem)this.getVisibleItem(i);
                if (paintItem.cached) continue;
                Event dataEvent = new Event();
                dataEvent.item = paintItem;
                this.ignoreRedraw = true;
                this.sendEvent(36, dataEvent);
                if (this.isDisposed()) {
                    return null;
                }
                this.ignoreRedraw = false;
                this.calculateItemHeight(paintItem);
                paintItem.cached = true;
            }
        }
        for (i = topPaintIndex; i <= bottomPaintIndex; ++i) {
            paintItem = (TableItem)this.getVisibleItem(i);
            int paintXPosition = paintItem.getSelectionX();
            int paintYPosition = this.getRedrawY(paintItem);
            if (paintItem.isSelected() && ((this.style & 0x8000) == 0 || this.isFocusControl())) {
                Point selectionExtent = paintItem.getSelectionExtent();
                gc.setBackground(selectionColor);
                gc.fillRectangle(paintXPosition, paintYPosition, selectionExtent.x, selectionExtent.y);
            }
            Enumeration columns = paintColumns.elements();
            while (columns.hasMoreElements()) {
                TableColumn column = (TableColumn)columns.nextElement();
                this.paintSubItem(event, paintItem, column, paintYPosition);
            }
            if (!this.hasFocus(paintItem)) continue;
            focusItem = paintItem;
        }
        return focusItem;
    }

    void paintSubItem(Event event, TableItem paintItem, TableColumn column, int paintYPosition) {
        Rectangle columnBounds = column.getBounds();
        int gridLineWidth = this.getGridLineWidth();
        int itemDrawStopX = columnBounds.x + columnBounds.width - gridLineWidth;
        if (event.x + event.width > itemDrawStopX) {
            int clipX = Math.max(columnBounds.x, event.x);
            event.gc.setClipping(clipX, event.y, Math.max(0, itemDrawStopX - clipX), event.height);
        }
        Point paintPosition = new Point(columnBounds.x, paintYPosition);
        paintItem.paint(event.gc, paintPosition, column);
        if (event.x + event.width > itemDrawStopX) {
            event.gc.setClipping(event.x, event.y, event.width, event.height);
        }
    }

    void reindexColumns(int startIndex) {
        Vector columns = this.getColumnVector();
        for (int i = startIndex; i < this.getColumnCount(); ++i) {
            TableColumn column = (TableColumn)columns.elementAt(i);
            column.setIndex(i);
        }
    }

    public void remove(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        int[] newIndices = new int[indices.length];
        System.arraycopy(indices, 0, newIndices, 0, indices.length);
        this.sort(newIndices);
        int start = newIndices[newIndices.length - 1];
        int end = newIndices[0];
        int count = this.getItemCount();
        if (0 > start || start > end || end >= count) {
            this.error(6);
        }
        int last = -1;
        for (int i = 0; i < newIndices.length; ++i) {
            int index = newIndices[i];
            if (index == last) continue;
            SelectableItem item = this.getVisibleItem(index);
            if (item != null) {
                item.dispose();
            } else {
                this.error(15);
            }
            last = index;
        }
    }

    public void redraw() {
        this.checkWidget();
        if (this.ignoreRedraw) {
            return;
        }
        super.redraw();
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        this.checkWidget();
        if (this.ignoreRedraw) {
            return;
        }
        super.redraw(x, y, width, height, all);
    }

    public void remove(int index) {
        this.checkWidget();
        SelectableItem item = this.getVisibleItem(index);
        if (item != null) {
            item.dispose();
        } else if (0 <= index && index < this.getItemVector().size()) {
            this.error(15);
        } else {
            this.error(6);
        }
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        if (0 > start || start > end || end >= this.getItemCount()) {
            this.error(6);
        }
        for (int i = end; i >= start; --i) {
            SelectableItem item = this.getVisibleItem(i);
            if (item != null) {
                item.dispose();
                continue;
            }
            this.error(15);
        }
    }

    public void removeAll() {
        this.checkWidget();
        Vector items = this.getItemVector();
        this.setRedraw(false);
        this.setRemovingAll(true);
        for (int i = items.size() - 1; i >= 0; --i) {
            ((TableItem)items.elementAt(i)).dispose();
        }
        this.setItemVector(new Vector());
        this.reset();
        this.calculateVerticalScrollbar();
        this.setRemovingAll(false);
        this.setRedraw(true);
    }

    void removeColumn(TableColumn column) {
        int index = column.getIndex();
        int columnWidth = column.getWidth();
        if (this.isRemovingAll()) {
            this.getColumnVector().removeElementAt(index);
        } else {
            this.getColumnVector().removeElementAt(index);
            int columnCount = this.getColumnCount();
            if (columnCount > 0) {
                this.removeColumnData(column);
                this.removeColumnVisual(column);
                Enumeration items = this.getItemVector().elements();
                while (items.hasMoreElements()) {
                    Font[] cellFont;
                    Color[] cellForeground;
                    TableItem item = (TableItem)items.nextElement();
                    Color[] cellBackground = item.cellBackground;
                    if (cellBackground != null) {
                        Color[] temp = new Color[columnCount];
                        System.arraycopy(cellBackground, 0, temp, 0, index);
                        System.arraycopy(cellBackground, index + 1, temp, index, columnCount - index);
                        item.cellBackground = temp;
                    }
                    if ((cellForeground = item.cellForeground) != null) {
                        Color[] temp = new Color[columnCount];
                        System.arraycopy(cellForeground, 0, temp, 0, index);
                        System.arraycopy(cellForeground, index + 1, temp, index, columnCount - index);
                        item.cellForeground = temp;
                    }
                    if ((cellFont = item.cellFont) == null) continue;
                    Font[] temp = new Font[columnCount];
                    System.arraycopy(cellFont, 0, temp, 0, index);
                    System.arraycopy(cellFont, index + 1, temp, index, columnCount - index);
                    item.cellFont = temp;
                }
            } else {
                this.redraw();
                this.getHeader().redraw();
            }
            if (index < columnCount) {
                this.reindexColumns(index);
            }
            if (columnCount == 0) {
                TableColumn defaultColumn = this.getDefaultColumn();
                defaultColumn.pack();
                this.setColumnPosition(defaultColumn);
            }
            this.setContentWidth(this.getContentWidth() - columnWidth);
            this.claimRightFreeSpace();
        }
    }

    void removeColumnData(TableColumn column) {
        Enumeration tableItems = this.getItemVector().elements();
        while (tableItems.hasMoreElements()) {
            TableItem tableItem = (TableItem)tableItems.nextElement();
            tableItem.removeColumn(column);
        }
    }

    void removeColumnVisual(TableColumn column) {
        int columnWidth = column.getWidth();
        this.moveColumns(column.getIndex(), columnWidth * -1);
        this.redraw();
        this.getHeader().redraw();
    }

    void removedItem(SelectableItem item) {
        int oldHeight = this.getItemHeight();
        super.removedItem(item);
        if (this.getItemCount() == 0 && this.drawGridLines && oldHeight != this.getItemHeight()) {
            this.redraw();
        }
    }

    void removeItem(TableItem item) {
        if (this.isRemovingAll()) {
            return;
        }
        Vector items = this.getItemVector();
        int index = items.indexOf(item);
        if (index != -1) {
            this.removingItem(item);
            items.removeElementAt(index);
            for (int i = index; i < items.size(); ++i) {
                TableItem anItem = (TableItem)items.elementAt(i);
                anItem.setIndex(anItem.getIndex() - 1);
            }
            this.removedItem(item);
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    void resetTableItems(int columnIndex) {
        Enumeration tableItems = this.getItemVector().elements();
        while (tableItems.hasMoreElements()) {
            TableItem tableItem = (TableItem)tableItems.nextElement();
            tableItem.reset(columnIndex);
        }
    }

    void resize(Event event) {
        TableColumn fillColumn = this.getFillColumn();
        super.resize(event);
        Rectangle fillColumnBounds = fillColumn.getBounds();
        fillColumnBounds.width = Math.max(0, this.getClientArea().width - this.getContentWidth());
        fillColumn.setBounds(fillColumnBounds);
        this.resizeHeader();
    }

    void resizeHeader() {
        Header tableHeader = this.getHeader();
        Point size = tableHeader.getSize();
        size.x = Math.max(this.getContentWidth(), this.getClientArea().width);
        tableHeader.setSize(size);
    }

    void resizeRedraw(TableColumn column, int oldColumnWidth, int newColumnWidth) {
        Rectangle columnBounds = column.getBounds();
        int columnIndex = column.getIndex();
        int[] oldRedrawStartX = this.getResizeRedrawX(columnIndex, oldColumnWidth);
        int[] newRedrawStartX = this.getResizeRedrawX(columnIndex, newColumnWidth);
        int itemHeight = this.getItemHeight();
        int widthChange = newColumnWidth - oldColumnWidth;
        int topIndex = this.getTopIndex();
        for (int i = 0; i < newRedrawStartX.length; ++i) {
            if (newRedrawStartX[i] == oldRedrawStartX[i]) continue;
            if (widthChange > 0) {
                newRedrawStartX[i] = oldRedrawStartX[i];
            }
            this.redraw(columnBounds.x + newRedrawStartX[i], columnBounds.y + itemHeight * (i + topIndex), columnBounds.width - newRedrawStartX[i], itemHeight, false);
        }
    }

    void scrollHorizontal(int numPixel) {
        Rectangle clientArea = this.getClientArea();
        this.scroll(numPixel, 0, 0, 0, clientArea.width, clientArea.height, true);
        this.getHeader().scroll(numPixel, 0, 0, 0, clientArea.width, clientArea.height, true);
        this.moveColumns(-1, numPixel);
    }

    void scrollVertical(int scrollIndexCount) {
        int sourceY;
        int destY;
        int scrollAmount = scrollIndexCount * this.getItemHeight();
        int headerHeight = this.getHeaderHeight();
        boolean scrollUp = scrollIndexCount < 0;
        Rectangle clientArea = this.getClientArea();
        if (scrollIndexCount == 0) {
            return;
        }
        if (scrollUp) {
            destY = headerHeight - scrollAmount;
            sourceY = headerHeight;
        } else {
            destY = headerHeight;
            sourceY = destY + scrollAmount;
        }
        this.scroll(0, destY, 0, sourceY, clientArea.width, clientArea.height, true);
    }

    void scrollVerticalAddingItem(int index) {
        int itemHeight = this.getItemHeight();
        int sourceY = this.getHeaderHeight();
        Rectangle clientArea = this.getClientArea();
        if (index >= this.getTopIndex()) {
            sourceY += (index - this.getTopIndex()) * itemHeight;
        }
        this.scroll(0, sourceY + itemHeight, 0, sourceY, clientArea.width, clientArea.height, true);
    }

    void scrollVerticalRemovedItem(int index) {
        int itemHeight = this.getItemHeight();
        int headerHeight = this.getHeaderHeight();
        Rectangle clientArea = this.getClientArea();
        int destY = Math.max(headerHeight, headerHeight + (index - this.getTopIndex()) * itemHeight);
        this.scroll(0, destY, 0, destY + itemHeight, clientArea.width, clientArea.height, true);
    }

    public void select(int[] indices) {
        int length;
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if ((length = indices.length) == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        if ((this.style & 4) != 0) {
            this.deselectAllExcept(this.getVisibleItem(indices[0]));
        }
        SelectableItem item = null;
        for (int i = length - 1; i >= 0; --i) {
            item = this.getVisibleItem(indices[i]);
            if (item == null) continue;
            this.select(item);
        }
        if (item != null) {
            this.setLastSelection(item, false);
        }
    }

    public void select(int index) {
        this.checkWidget();
        SelectableItem item = this.getVisibleItem(index);
        if (!this.isMultiSelect()) {
            this.deselectAllExcept(this.getVisibleItem(index));
        }
        if (item != null) {
            this.select(item);
            this.setLastSelection(item, false);
        }
    }

    public void select(int start, int end) {
        this.checkWidget();
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            return;
        }
        int count = this.getItemVector().size();
        if (count == 0 || start >= count) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, count - 1);
        if ((this.style & 4) != 0) {
            this.deselectAllExcept(this.getVisibleItem(start));
        }
        SelectableItem item = null;
        for (int i = end; i >= start; --i) {
            item = this.getVisibleItem(i);
            if (item == null) continue;
            this.select(item);
        }
        if (item != null) {
            this.setLastSelection(item, false);
        }
    }

    public void selectAll() {
        this.checkWidget();
        Enumeration items = this.getItemVector().elements();
        TableItem item = null;
        if (!this.isMultiSelect()) {
            return;
        }
        while (items.hasMoreElements()) {
            item = (TableItem)items.nextElement();
            this.select(item);
        }
        if (item != null) {
            this.setLastSelection(item, false);
        }
    }

    void setColumnPosition(TableColumn column) {
        Rectangle bounds = column.getBounds();
        bounds.y = this.getHeaderHeight() - this.getTopIndex() * this.getItemHeight();
        column.setBounds(bounds);
    }

    void setColumnResizeCursor(boolean isColumnResizeCursor) {
        if (isColumnResizeCursor != this.isColumnResizeCursor) {
            this.isColumnResizeCursor = isColumnResizeCursor;
            if (isColumnResizeCursor) {
                this.setCursor(this.getColumnResizeCursor());
            } else {
                this.setCursor(null);
            }
        }
    }

    void setColumnResizeX(int xPosition) {
        this.columnResizeX = xPosition;
    }

    void setContentWidth(int newWidth) {
        TableColumn fillColumn = this.getFillColumn();
        int widthDiff = newWidth - this.getContentWidth();
        super.setContentWidth(newWidth);
        if (fillColumn != null) {
            Rectangle fillColumnBounds = fillColumn.getBounds();
            fillColumnBounds.x += widthDiff;
            fillColumnBounds.width = Math.max(0, this.getClientArea().width - newWidth);
            fillColumn.setBounds(fillColumnBounds);
        }
    }

    void setFirstColumnWidth(TableItem item) {
        TableColumn column;
        if (this.internalGetColumnCount() > 0 && (column = this.internalGetColumn(0)).isDefaultWidth()) {
            int newWidth = Math.max(column.getWidth(), item.getPreferredWidth(0));
            column.setWidth(newWidth);
            column.setDefaultWidth(true);
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        int itemCount = this.getItemCount();
        if (font != null && font.equals(this.getFont())) {
            return;
        }
        this.setRedraw(false);
        this.resetItemData();
        super.setFont(font);
        GC gc = new GC(this);
        Point extent = gc.stringExtent("String");
        this.fontHeight = extent.y;
        gc.dispose();
        for (int i = 0; i < itemCount; ++i) {
            this.itemChanged(this.getItem(i), 0, this.getClientArea().width);
        }
        this.setRedraw(true);
        this.getHeader().setFont(font);
    }

    public void setHeaderVisible(boolean headerVisible) {
        this.checkWidget();
        if (headerVisible != this.getHeaderVisible()) {
            this.getHeader().setLocation(0, 0);
            this.getHeader().setVisible(headerVisible);
            this.setTopIndex(0, true);
            this.moveColumnsVertical();
            this.resizeVerticalScrollbar();
            this.redraw();
        }
    }

    public void setItemCount(int count) {
        this.checkWidget();
        count = Math.max(0, count);
        int itemCount = this.getItemCount();
        if (count == itemCount) {
            return;
        }
        this.setRedraw(false);
        this.remove(count, itemCount - 1);
        for (int i = itemCount; i < count; ++i) {
            new TableItem(this, 0);
        }
        this.setRedraw(true);
    }

    void setItemVector(Vector newVector) {
        this.items = newVector;
    }

    public void setLinesVisible(boolean drawGridLines) {
        this.checkWidget();
        if (this.drawGridLines != drawGridLines) {
            this.drawGridLines = drawGridLines;
            this.redraw();
        }
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        super.setRedraw(redraw);
        this.getHeader().setRedraw(redraw);
    }

    void setResizeColumn(TableColumn column) {
        this.resizeColumn = column;
    }

    public void setSelection(int[] indices) {
        int length;
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if ((length = indices.length) == 0 || (this.style & 4) != 0 && length > 1) {
            this.deselectAll();
            return;
        }
        if ((this.style & 2) != 0) {
            Vector<SelectableItem> keepSelected = new Vector<SelectableItem>(length);
            for (int i = 0; i < length; ++i) {
                SelectableItem item = this.getVisibleItem(indices[i]);
                if (item == null) continue;
                keepSelected.addElement(item);
            }
            this.deselectAllExcept(keepSelected);
        }
        this.select(indices);
        this.showSelection();
    }

    public void setSelection(TableItem[] items) {
        int length;
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        if ((length = items.length) == 0 || (this.style & 4) != 0 && length > 1) {
            this.deselectAll();
            return;
        }
        this.setSelectableSelection(items);
    }

    public void setSelection(int index) {
        this.checkWidget();
        this.deselectAllExcept(this.getVisibleItem(index));
        this.select(index);
        this.showSelection();
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            this.deselectAll();
            return;
        }
        int count = this.getItemVector().size();
        if (count == 0 || start >= count) {
            this.deselectAll();
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, count - 1);
        if ((this.style & 2) != 0) {
            Vector<SelectableItem> keepSelected = new Vector<SelectableItem>();
            for (int i = start; i <= end; ++i) {
                SelectableItem item = this.getVisibleItem(i);
                if (item == null) continue;
                keepSelected.addElement(item);
            }
            this.deselectAllExcept(keepSelected);
        }
        this.select(start, end);
        this.showSelection();
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        int itemCount = this.getItemCount();
        int itemCountWhole = this.getItemCountWhole();
        if (index < 0 || itemCount == 0) {
            return;
        }
        if (index >= itemCount) {
            index = itemCount - 1;
        }
        if (itemCount > itemCountWhole) {
            if (index + itemCountWhole <= itemCount) {
                this.setTopIndex(index, true);
            } else if (index > itemCount - itemCountWhole) {
                this.setTopIndex(itemCount - itemCountWhole, true);
            } else {
                this.showSelectableItem(index);
            }
        }
    }

    void setTopIndexNoScroll(int index, boolean adjustScrollbar) {
        super.setTopIndexNoScroll(index, adjustScrollbar);
        this.moveColumnsVertical();
    }

    public void showColumn(TableColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        if (column.getParent() != this) {
            return;
        }
        if (this.columns == null || this.columns.size() <= 1) {
            return;
        }
    }

    public void showItem(TableItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        this.showSelectableItem(item);
    }

    public void showSelection() {
        this.checkWidget();
        super.showSelection();
    }

    void sort(int[] items) {
        int length = items.length;
        for (int gap = length / 2; gap > 0; gap /= 2) {
            for (int i = gap; i < length; ++i) {
                for (int j = i - gap; j >= 0; j -= gap) {
                    if (items[j] > items[j + gap]) continue;
                    int swap = items[j];
                    items[j] = items[j + gap];
                    items[j + gap] = swap;
                }
            }
        }
    }

    void startColumnResize(Event event) {
        Vector columns = this.internalGetColumnVector();
        TableColumn hitColumn = this.getColumnAtX(event.x);
        int hitIndex = hitColumn.getIndex();
        if (hitColumn == this.getFillColumn()) {
            hitColumn = (TableColumn)columns.lastElement();
        } else if (event.x - hitColumn.getBounds().x <= 7 && hitIndex > 0) {
            hitColumn = (TableColumn)columns.elementAt(hitIndex - 1);
        }
        Rectangle hitColumnBounds = hitColumn.getBounds();
        this.setColumnResizeX(hitColumnBounds.x + hitColumnBounds.width);
        this.setResizeColumn(hitColumn);
    }

    String trimItemText(String text, int maxWidth, GC gc) {
        int textWidth;
        if (text != null && text.length() > 1 && (textWidth = gc.stringExtent((String)text).x) > maxWidth) {
            int dotsWidth = gc.stringExtent((String)DOT_STRING).x;
            while (textWidth + dotsWidth > maxWidth && text.length() > 1) {
                text = text.substring(0, text.length() - 1);
                textWidth = gc.stringExtent((String)text).x;
            }
            text = text.concat(DOT_STRING);
        }
        return text;
    }
}

