/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.corext.util.AllTypesCache;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.TypeInfoLabelProvider;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class MultiTypeSelectionDialog
extends ElementListSelectionDialog {
    private IRunnableContext fRunnableContext;
    private IJavaSearchScope fScope;
    private int fElementKinds;

    public MultiTypeSelectionDialog(Shell parent, IRunnableContext context, int elementKinds, IJavaSearchScope scope) {
        super(parent, (ILabelProvider)new TypeInfoLabelProvider(2));
        this.setMultipleSelection(true);
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)scope);
        this.fRunnableContext = context;
        this.fScope = scope;
        this.fElementKinds = elementKinds;
    }

    public int open() {
        final ArrayList typesFound = new ArrayList();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                AllTypesCache.getTypes(MultiTypeSelectionDialog.this.fScope, MultiTypeSelectionDialog.this.fElementKinds, monitor, typesFound);
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
            }
        };
        try {
            this.fRunnableContext.run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, JavaUIMessages.getString("MultiTypeSelectionDialog.error2Title"), JavaUIMessages.getString("MultiTypeSelectionDialog.error2Message"));
        }
        catch (InterruptedException e) {
            return 1;
        }
        this.setElements(typesFound.toArray());
        return super.open();
    }

    protected void computeResult() {
        List<Object> selection = Arrays.asList(this.getSelectedElements());
        int size = selection.size();
        if (size == 0) {
            this.setResult(null);
            return;
        }
        ArrayList<IType> result = new ArrayList<IType>(size);
        if (result != null) {
            for (int i = 0; i < size; ++i) {
                try {
                    TypeInfo typeInfo = (TypeInfo)selection.get(i);
                    IType type = typeInfo.resolveType(this.fScope);
                    if (type == null) {
                        String title = JavaUIMessages.getString("MultiTypeSelectionDialog.dialogTitle");
                        String message = JavaUIMessages.getFormattedString("MultiTypeSelectionDialog.dialogMessage", typeInfo.getPath());
                        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
                        continue;
                    }
                    result.add(type);
                    continue;
                }
                catch (JavaModelException e) {
                    String title = JavaUIMessages.getString("MultiTypeSelectionDialog.errorTitle");
                    String message = JavaUIMessages.getString("MultiTypeSelectionDialog.errorMessage");
                    ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)message, (IStatus)e.getStatus());
                }
            }
        }
        this.setResult(result);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.jdt.ui.multi_type_selection_dialog_context");
    }
}

