/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.osgi.framework.adaptor.ServiceRegistry;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.ServiceReferenceImpl;
import org.eclipse.osgi.framework.internal.core.ServiceUse;
import org.eclipse.osgi.framework.util.Headers;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceRegistrationImpl
implements ServiceRegistration {
    protected ServiceReferenceImpl reference;
    protected Framework framework;
    protected BundleContextImpl context;
    protected AbstractBundle bundle;
    protected ArrayList contextsUsing;
    protected String[] clazzes;
    protected Object service;
    protected Properties properties;
    protected long serviceid;
    protected int serviceranking;
    protected Object registrationLock = new Object();
    protected boolean unregistered;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServiceRegistrationImpl(BundleContextImpl context, String[] clazzes, Object service, Dictionary properties) {
        this.context = context;
        this.bundle = context.bundle;
        this.framework = context.framework;
        this.clazzes = clazzes;
        this.service = service;
        this.contextsUsing = null;
        this.unregistered = false;
        this.reference = new ServiceReferenceImpl(this);
        ServiceRegistry serviceRegistry = this.framework.serviceRegistry;
        synchronized (serviceRegistry) {
            this.serviceid = this.framework.getNextServiceId();
            this.properties = this.createProperties(properties);
            if (Debug.DEBUG_SERVICES) {
                Debug.println("registerService[" + this.bundle + "](" + this + ")");
            }
            this.framework.serviceRegistry.publishService(context, this);
        }
        this.framework.publishServiceEvent(1, this.reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() {
        Object object = this.registrationLock;
        synchronized (object) {
            if (this.service == null) {
                throw new IllegalStateException(Msg.formatter.getString("SERVICE_ALREADY_UNREGISTERED_EXCEPTION"));
            }
            if (Debug.DEBUG_SERVICES) {
                Debug.println("unregisterService[" + this.bundle + "](" + this + ")");
            }
            ServiceRegistry serviceRegistry = this.framework.serviceRegistry;
            synchronized (serviceRegistry) {
                this.framework.serviceRegistry.unpublishService(this.context, this);
            }
            this.service = null;
        }
        this.framework.publishServiceEvent(4, this.reference);
        this.unregistered = true;
        int size = 0;
        BundleContextImpl[] users = null;
        Object object2 = this.registrationLock;
        synchronized (object2) {
            if (this.contextsUsing != null && (size = this.contextsUsing.size()) > 0) {
                if (Debug.DEBUG_SERVICES) {
                    Debug.println("unregisterService: releasing users");
                }
                users = this.contextsUsing.toArray(new BundleContextImpl[size]);
            }
        }
        for (int i = 0; i < size; ++i) {
            this.releaseService((BundleContextImpl)users[i]);
        }
        this.contextsUsing = null;
        this.reference = null;
        this.context = null;
    }

    public ServiceReference getReference() {
        if (this.reference == null) {
            throw new IllegalStateException(Msg.formatter.getString("SERVICE_ALREADY_UNREGISTERED_EXCEPTION"));
        }
        return this.reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(Dictionary props) {
        Object object = this.registrationLock;
        synchronized (object) {
            if (this.service == null) {
                throw new IllegalStateException(Msg.formatter.getString("SERVICE_ALREADY_UNREGISTERED_EXCEPTION"));
            }
            this.properties = this.createProperties(props);
        }
        this.framework.publishServiceEvent(2, this.reference);
    }

    protected Properties createProperties(Dictionary props) {
        Properties properties = new Properties(props);
        properties.setProperty("objectClass", null);
        properties.setProperty("objectClass", this.clazzes);
        properties.setProperty("service.id", null);
        properties.setProperty("service.id", new Long(this.serviceid));
        Object ranking = properties.getProperty("service.ranking");
        this.serviceranking = ranking instanceof Integer ? (Integer)ranking : 0;
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getProperty(String key) {
        Object object = this.registrationLock;
        synchronized (object) {
            return this.properties.getProperty(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getPropertyKeys() {
        Object object = this.registrationLock;
        synchronized (object) {
            return this.properties.getPropertyKeys();
        }
    }

    protected AbstractBundle getBundle() {
        if (this.reference == null) {
            return null;
        }
        return this.bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getService(BundleContextImpl user) {
        Object object = this.registrationLock;
        synchronized (object) {
            Hashtable servicesInUse;
            ServiceUse use;
            if (this.unregistered) {
                return null;
            }
            if (Debug.DEBUG_SERVICES) {
                Debug.println("getService[" + user.bundle + "](" + this + ")");
            }
            if ((use = (ServiceUse)(servicesInUse = user.servicesInUse).get(this.reference)) == null) {
                use = new ServiceUse(user, this);
                Object service = use.getService();
                if (service != null) {
                    servicesInUse.put(this.reference, use);
                    if (this.contextsUsing == null) {
                        this.contextsUsing = new ArrayList(10);
                    }
                    this.contextsUsing.add(user);
                }
                return service;
            }
            return use.getService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean ungetService(BundleContextImpl user) {
        Object object = this.registrationLock;
        synchronized (object) {
            ServiceUse use;
            Hashtable servicesInUse;
            if (this.unregistered) {
                return false;
            }
            if (Debug.DEBUG_SERVICES) {
                String bundle = user.bundle == null ? "" : user.bundle.toString();
                Debug.println("ungetService[" + bundle + "](" + this + ")");
            }
            if ((servicesInUse = user.servicesInUse) != null && (use = (ServiceUse)servicesInUse.get(this.reference)) != null) {
                if (use.ungetService()) {
                    servicesInUse.remove(this.reference);
                    this.contextsUsing.remove(user);
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseService(BundleContextImpl user) {
        Object object = this.registrationLock;
        synchronized (object) {
            ServiceUse use;
            Hashtable servicesInUse;
            if (this.reference == null) {
                return;
            }
            if (Debug.DEBUG_SERVICES) {
                String bundle = user.bundle == null ? "" : user.bundle.toString();
                Debug.println("releaseService[" + bundle + "](" + this + ")");
            }
            if ((servicesInUse = user.servicesInUse) != null && (use = (ServiceUse)servicesInUse.remove(this.reference)) != null) {
                use.releaseService();
                this.contextsUsing.remove(user);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractBundle[] getUsingBundles() {
        Object object = this.registrationLock;
        synchronized (object) {
            if (this.unregistered) {
                return null;
            }
            if (this.contextsUsing == null) {
                return null;
            }
            int size = this.contextsUsing.size();
            if (size == 0) {
                return null;
            }
            AbstractBundle[] bundles = new AbstractBundle[size];
            for (int i = 0; i < size; ++i) {
                bundles[i] = ((BundleContextImpl)this.contextsUsing.get((int)i)).bundle;
            }
            return bundles;
        }
    }

    public String toString() {
        String[] clazzes = this.clazzes;
        int size = clazzes.length;
        StringBuffer sb = new StringBuffer(50 * size);
        sb.append('{');
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(clazzes[i]);
        }
        sb.append("}=");
        sb.append(this.properties);
        return sb.toString();
    }

    static class Properties
    extends Headers {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Properties(int size, Dictionary props) {
            super((size << 1) + 1);
            if (props != null) {
                Dictionary dictionary = props;
                synchronized (dictionary) {
                    Enumeration enumeration = props.keys();
                    while (enumeration.hasMoreElements()) {
                        Object key = enumeration.nextElement();
                        if (!(key instanceof String)) continue;
                        String header = (String)key;
                        this.setProperty(header, props.get(header));
                    }
                }
            }
        }

        protected Properties(Dictionary props) {
            this(props == null ? 2 : Math.max(2, props.size()), props);
        }

        protected Object getProperty(String key) {
            return Properties.cloneValue(this.get(key));
        }

        protected synchronized String[] getPropertyKeys() {
            int size = this.size();
            String[] keynames = new String[size];
            Enumeration enumeration = this.keys();
            for (int i = 0; i < size; ++i) {
                keynames[i] = (String)enumeration.nextElement();
            }
            return keynames;
        }

        protected synchronized Object setProperty(String key, Object value) {
            return this.set(key, Properties.cloneValue(value));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected static Object cloneValue(Object value) {
            if (value == null) return value;
            if (value instanceof String) {
                return value;
            }
            Class<?> clazz = value.getClass();
            if (clazz.isArray()) {
                Class<?> type = clazz.getComponentType();
                if (!type.isPrimitive()) return ((Object[])value).clone();
                if (Integer.TYPE.isAssignableFrom(type)) {
                    return ((int[])value).clone();
                }
                if (Long.TYPE.isAssignableFrom(type)) {
                    return ((long[])value).clone();
                }
                if (Byte.TYPE.isAssignableFrom(type)) {
                    return ((byte[])value).clone();
                }
                if (Short.TYPE.isAssignableFrom(type)) {
                    return ((short[])value).clone();
                }
                if (Character.TYPE.isAssignableFrom(type)) {
                    return ((char[])value).clone();
                }
                if (Float.TYPE.isAssignableFrom(type)) {
                    return ((float[])value).clone();
                }
                if (Double.TYPE.isAssignableFrom(type)) {
                    return ((double[])value).clone();
                }
                if (!Boolean.TYPE.isAssignableFrom(type)) return value;
                return ((boolean[])value).clone();
            }
            try {
                return clazz.getMethod("clone", null).invoke(value, null);
            }
            catch (Exception e) {
                return value;
            }
            catch (Error e) {
                if (value instanceof Vector) {
                    return ((Vector)value).clone();
                }
                if (!(value instanceof Hashtable)) return value;
                return ((Hashtable)value).clone();
            }
        }

        public synchronized String toString() {
            String[] keys = this.getPropertyKeys();
            int size = keys.length;
            StringBuffer sb = new StringBuffer(20 * size);
            sb.append('{');
            int n = 0;
            for (int i = 0; i < size; ++i) {
                String key = keys[i];
                if (key.equals("objectClass")) continue;
                if (n > 0) {
                    sb.append(", ");
                }
                sb.append(key);
                sb.append('=');
                sb.append(this.get(key));
                ++n;
            }
            sb.append('}');
            return sb.toString();
        }
    }
}

