/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.edits;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditVisitor;

public final class InsertEdit
extends TextEdit {
    private String fText;

    public InsertEdit(int offset, String text) {
        super(offset, 0);
        this.fText = text;
    }

    private InsertEdit(InsertEdit other) {
        super(other);
        this.fText = other.fText;
    }

    public String getText() {
        return this.fText;
    }

    protected TextEdit doCopy() {
        return new InsertEdit(this);
    }

    protected void accept0(TextEditVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChildren(visitor);
        }
    }

    int performDocumentUpdating(IDocument document) throws BadLocationException {
        document.replace(this.getOffset(), this.getLength(), this.fText);
        this.fDelta = this.fText.length() - this.getLength();
        return this.fDelta;
    }

    boolean deleteChildren() {
        return false;
    }

    public String toString() {
        return super.toString() + " <<" + this.fText;
    }
}

