/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.widgets;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.ILayoutExtension;
import org.eclipse.ui.forms.widgets.TableWrapData;

public final class TableWrapLayout
extends Layout
implements ILayoutExtension {
    public int numColumns = 1;
    public int leftMargin = 5;
    public int rightMargin = 5;
    public int topMargin = 5;
    public int bottomMargin = 5;
    public int horizontalSpacing = 5;
    public int verticalSpacing = 5;
    public boolean makeColumnsEqualWidth = false;
    private boolean initialLayout = true;
    private Vector grid = null;
    private Hashtable rowspans;
    private int[] minColumnWidths;
    private int[] maxColumnWidths;
    private int widestColumnWidth;
    private int[] growingColumns;
    private int[] growingRows;

    public int computeMinimumWidth(Composite parent, boolean changed) {
        changed = true;
        this.initializeIfNeeded(parent, changed);
        if (this.initialLayout) {
            changed = true;
            this.initialLayout = false;
        }
        if (this.grid == null || changed) {
            changed = true;
            this.grid = new Vector();
            this.createGrid(parent);
        }
        if (this.minColumnWidths == null) {
            this.minColumnWidths = new int[this.numColumns];
        }
        for (int i = 0; i < this.numColumns; ++i) {
            this.minColumnWidths[i] = 0;
        }
        return this.internalGetMinimumWidth(parent, changed);
    }

    public int computeMaximumWidth(Composite parent, boolean changed) {
        changed = true;
        this.initializeIfNeeded(parent, changed);
        if (this.initialLayout) {
            changed = true;
            this.initialLayout = false;
        }
        if (this.grid == null || changed) {
            changed = true;
            this.grid = new Vector();
            this.createGrid(parent);
        }
        if (this.maxColumnWidths == null) {
            this.maxColumnWidths = new int[this.numColumns];
        }
        for (int i = 0; i < this.numColumns; ++i) {
            this.maxColumnWidths[i] = 0;
        }
        return this.internalGetMaximumWidth(parent, changed);
    }

    protected void layout(Composite parent, boolean changed) {
        int i;
        int colSpace;
        int[] columnWidths;
        Rectangle clientArea = parent.getClientArea();
        Control[] children = parent.getChildren();
        if (children.length == 0) {
            return;
        }
        int parentWidth = clientArea.width;
        changed = true;
        this.initializeIfNeeded(parent, changed);
        if (this.initialLayout) {
            changed = true;
            this.initialLayout = false;
        }
        if (this.grid == null || changed) {
            changed = true;
            this.grid = new Vector();
            this.createGrid(parent);
        }
        this.resetColumnWidths();
        int minWidth = this.internalGetMinimumWidth(parent, changed);
        int maxWidth = this.internalGetMaximumWidth(parent, changed);
        int tableWidth = parentWidth;
        if (parentWidth <= minWidth) {
            tableWidth = minWidth;
            if (this.makeColumnsEqualWidth) {
                columnWidths = new int[this.numColumns];
                for (int i2 = 0; i2 < this.numColumns; ++i2) {
                    columnWidths[i2] = this.widestColumnWidth;
                }
            } else {
                columnWidths = this.minColumnWidths;
            }
        } else if (parentWidth > maxWidth) {
            if (this.growingColumns.length == 0) {
                tableWidth = maxWidth;
                columnWidths = this.maxColumnWidths;
            } else {
                columnWidths = new int[this.numColumns];
                colSpace = tableWidth - this.leftMargin - this.rightMargin;
                colSpace -= (this.numColumns - 1) * this.horizontalSpacing;
                int extra = parentWidth - maxWidth;
                int colExtra = extra / this.growingColumns.length;
                for (int i3 = 0; i3 < this.numColumns; ++i3) {
                    columnWidths[i3] = this.maxColumnWidths[i3];
                    if (!this.isGrowingColumn(i3)) continue;
                    int n = i3;
                    columnWidths[n] = columnWidths[n] + colExtra;
                }
            }
        } else {
            columnWidths = new int[this.numColumns];
            if (this.makeColumnsEqualWidth) {
                colSpace = tableWidth - this.leftMargin - this.rightMargin;
                int col = (colSpace -= (this.numColumns - 1) * this.horizontalSpacing) / this.numColumns;
                for (i = 0; i < this.numColumns; ++i) {
                    columnWidths[i] = col;
                }
            } else {
                columnWidths = this.assignExtraSpace(tableWidth, maxWidth, minWidth);
            }
        }
        int y = this.topMargin;
        int[] rowHeights = this.computeRowHeights(children, columnWidths, changed);
        for (i = 0; i < this.grid.size(); ++i) {
            int rowHeight = rowHeights[i];
            int x = this.leftMargin;
            TableWrapData[] row = (TableWrapData[])this.grid.elementAt(i);
            for (int j = 0; j < this.numColumns; ++j) {
                TableWrapData td = row[j];
                if (td.isItemData) {
                    Control child = children[td.childIndex];
                    this.placeControl(child, td, x, y, rowHeights, i);
                }
                x += columnWidths[j];
                if (j >= this.numColumns - 1) continue;
                x += this.horizontalSpacing;
            }
            y += rowHeight + this.verticalSpacing;
        }
    }

    int[] computeRowHeights(Control[] children, int[] columnWidths, boolean changed) {
        TableWrapData td;
        int[] rowHeights = new int[this.grid.size()];
        for (int i = 0; i < this.grid.size(); ++i) {
            TableWrapData[] row = (TableWrapData[])this.grid.elementAt(i);
            rowHeights[i] = 0;
            for (int j = 0; j < this.numColumns; ++j) {
                td = row[j];
                if (!td.isItemData) continue;
                Control child = children[td.childIndex];
                int span = td.colspan;
                int cwidth = 0;
                for (int k = j; k < j + span; ++k) {
                    cwidth += columnWidths[k];
                    if (k >= j + span - 1) continue;
                    cwidth += this.horizontalSpacing;
                }
                Point size = this.computeSize(child, cwidth, td.indent, changed);
                td.compWidth = cwidth;
                if (td.heightHint != -1) {
                    size = new Point(size.x, td.heightHint);
                }
                td.compSize = size;
                RowSpan rowspan = (RowSpan)this.rowspans.get(child);
                if (rowspan == null) {
                    rowHeights[i] = Math.max(rowHeights[i], size.y);
                    continue;
                }
                rowspan.height = size.y;
            }
            this.updateRowSpans(i, rowHeights[i]);
        }
        Enumeration enumeration = this.rowspans.elements();
        while (enumeration.hasMoreElements()) {
            RowSpan rowspan = (RowSpan)enumeration.nextElement();
            int increase = rowspan.getRequiredHeightIncrease();
            if (increase == 0) continue;
            td = (TableWrapData)rowspan.child.getLayoutData();
            int ngrowing = 0;
            int[] affectedRows = new int[this.grid.size()];
            for (int i = 0; i < this.growingRows.length; ++i) {
                int growingRow = this.growingRows[i];
                if (growingRow < rowspan.row || growingRow >= rowspan.row + td.rowspan) continue;
                affectedRows[ngrowing++] = growingRow;
            }
            if (ngrowing == 0) {
                ngrowing = 1;
                affectedRows[0] = rowspan.row + td.rowspan - 1;
            }
            increase += increase % ngrowing;
            int perRowIncrease = increase / ngrowing;
            for (int i = 0; i < ngrowing; ++i) {
                int growingRow;
                int n = growingRow = affectedRows[i];
                rowHeights[n] = rowHeights[n] + perRowIncrease;
            }
        }
        return rowHeights;
    }

    boolean isGrowingColumn(int col) {
        if (this.growingColumns == null) {
            return false;
        }
        for (int i = 0; i < this.growingColumns.length; ++i) {
            if (col != this.growingColumns[i]) continue;
            return true;
        }
        return false;
    }

    int[] assignExtraSpace(int tableWidth, int maxWidth, int minWidth) {
        int fixedPart = this.leftMargin + this.rightMargin + (this.numColumns - 1) * this.horizontalSpacing;
        int D = maxWidth - minWidth;
        int W = tableWidth - fixedPart - minWidth;
        int[] widths = new int[this.numColumns];
        int rem = 0;
        for (int i = 0; i < this.numColumns; ++i) {
            int extra;
            int cmin = this.minColumnWidths[i];
            int cmax = this.maxColumnWidths[i];
            int d = cmax - cmin;
            int n = extra = D != 0 ? d * W / D : 0;
            if (i < this.numColumns - 1) {
                widths[i] = cmin + extra;
                rem += widths[i];
                continue;
            }
            widths[i] = tableWidth - fixedPart - rem;
        }
        return widths;
    }

    Point computeSize(Control child, int width, int indent, boolean changed) {
        int widthArg = width - indent;
        if (!this.isWrap(child)) {
            widthArg = -1;
        }
        Point size = child.computeSize(widthArg, -1, changed);
        size.x += indent;
        return size;
    }

    void placeControl(Control control, TableWrapData td, int x, int y, int[] rowHeights, int row) {
        int xloc = x + td.indent;
        int yloc = y;
        int height = td.compSize.y;
        int colWidth = td.compWidth - td.indent;
        int width = Math.min(td.compSize.x, colWidth);
        int slotHeight = rowHeights[row];
        RowSpan rowspan = (RowSpan)this.rowspans.get(control);
        if (rowspan != null) {
            slotHeight = 0;
            for (int i = row; i < row + td.rowspan; ++i) {
                if (i > row) {
                    slotHeight += this.verticalSpacing;
                }
                slotHeight += rowHeights[i];
            }
        }
        if (td.align == 4) {
            xloc = x + colWidth / 2 - width / 2;
        } else if (td.align == 8) {
            xloc = x + colWidth - width;
        } else if (td.align == 128) {
            width = colWidth;
        }
        if (td.valign == 32) {
            yloc = y + slotHeight / 2 - height / 2;
        } else if (td.valign == 64) {
            yloc = y + slotHeight - height;
        } else if (td.valign == 128) {
            height = slotHeight;
        }
        control.setBounds(xloc, yloc, width, height);
    }

    void createGrid(Composite composite) {
        int k;
        TableWrapData spacerSpec;
        int i;
        Vector growingCols = new Vector();
        Vector growingRows = new Vector();
        this.rowspans = new Hashtable();
        Control[] children = composite.getChildren();
        if (children.length == 0) {
            return;
        }
        this.grid.addElement(this.createEmptyRow());
        int row = 0;
        int column = 0;
        for (i = 0; i < children.length; ++i) {
            Control child = children[i];
            TableWrapData spec = (TableWrapData)child.getLayoutData();
            while (((TableWrapData[])this.grid.elementAt(row))[column] != null) {
                if (++column < this.numColumns) continue;
                column = 0;
                if (++row < this.grid.size()) continue;
                this.grid.addElement(this.createEmptyRow());
            }
            if (column + spec.colspan - 1 >= this.numColumns) {
                this.grid.addElement(this.createEmptyRow());
                ++row;
                column = 0;
            }
            if (spec.rowspan > 1) {
                this.rowspans.put(child, new RowSpan(child, column, row));
            }
            for (int j = 2; j <= spec.rowspan; ++j) {
                if (row + j <= this.grid.size()) continue;
                this.grid.addElement(this.createEmptyRow());
            }
            ((TableWrapData[])this.grid.elementAt((int)row))[column] = spec;
            spec.childIndex = i;
            if (spec.grabHorizontal) {
                this.updateGrowingColumns(growingCols, spec, column);
            }
            if (spec.grabVertical) {
                this.updateGrowingRows(growingRows, spec, row);
            }
            int rowFill = spec.rowspan - 1;
            int columnFill = spec.colspan - 1;
            for (int r = 1; r <= rowFill; ++r) {
                for (int c = 0; c < spec.colspan; ++c) {
                    spacerSpec = new TableWrapData();
                    spacerSpec.isItemData = false;
                    ((TableWrapData[])this.grid.elementAt((int)(row + r)))[column + c] = spacerSpec;
                }
            }
            for (int c = 1; c <= columnFill; ++c) {
                for (int r = 0; r < spec.rowspan; ++r) {
                    spacerSpec = new TableWrapData();
                    spacerSpec.isItemData = false;
                    ((TableWrapData[])this.grid.elementAt((int)(row + r)))[column + c] = spacerSpec;
                }
            }
            column = column + spec.colspan - 1;
        }
        for (k = column + 1; k < this.numColumns; ++k) {
            spacerSpec = new TableWrapData();
            spacerSpec.isItemData = false;
            ((TableWrapData[])this.grid.elementAt((int)row))[k] = spacerSpec;
        }
        for (k = row + 1; k < this.grid.size(); ++k) {
            spacerSpec = new TableWrapData();
            spacerSpec.isItemData = false;
            ((TableWrapData[])this.grid.elementAt((int)k))[column] = spacerSpec;
        }
        this.growingColumns = new int[growingCols.size()];
        for (i = 0; i < growingCols.size(); ++i) {
            this.growingColumns[i] = (Integer)growingCols.get(i);
        }
        this.growingRows = new int[growingRows.size()];
        for (i = 0; i < growingRows.size(); ++i) {
            this.growingRows[i] = (Integer)growingRows.get(i);
        }
    }

    private void updateGrowingColumns(Vector growingColumns, TableWrapData spec, int column) {
        int affectedColumn = column + spec.colspan - 1;
        for (int i = 0; i < growingColumns.size(); ++i) {
            Integer col = (Integer)growingColumns.get(i);
            if (col != affectedColumn) continue;
            return;
        }
        growingColumns.add(new Integer(affectedColumn));
    }

    private void updateGrowingRows(Vector growingRows, TableWrapData spec, int row) {
        int affectedRow = row + spec.rowspan - 1;
        for (int i = 0; i < growingRows.size(); ++i) {
            Integer irow = (Integer)growingRows.get(i);
            if (irow != affectedRow) continue;
            return;
        }
        growingRows.add(new Integer(affectedRow));
    }

    private TableWrapData[] createEmptyRow() {
        TableWrapData[] row = new TableWrapData[this.numColumns];
        for (int i = 0; i < this.numColumns; ++i) {
            row[i] = null;
        }
        return row;
    }

    protected Point computeSize(Composite parent, int wHint, int hHint, boolean changed) {
        int i;
        int col;
        int colSpace;
        int[] columnWidths;
        Control[] children = parent.getChildren();
        if (children.length == 0) {
            return new Point(0, 0);
        }
        int parentWidth = wHint;
        changed = true;
        this.initializeIfNeeded(parent, changed);
        if (this.initialLayout) {
            changed = true;
            this.initialLayout = false;
        }
        if (this.grid == null || changed) {
            changed = true;
            this.grid = new Vector();
            this.createGrid(parent);
        }
        this.resetColumnWidths();
        int minWidth = this.internalGetMinimumWidth(parent, changed);
        int maxWidth = this.internalGetMaximumWidth(parent, changed);
        int tableWidth = parentWidth;
        if (parentWidth <= minWidth) {
            tableWidth = minWidth;
            if (this.makeColumnsEqualWidth) {
                columnWidths = new int[this.numColumns];
                for (int i2 = 0; i2 < this.numColumns; ++i2) {
                    columnWidths[i2] = this.widestColumnWidth;
                }
            } else {
                columnWidths = this.minColumnWidths;
            }
        } else if (parentWidth > maxWidth) {
            if (this.makeColumnsEqualWidth) {
                columnWidths = new int[this.numColumns];
                colSpace = parentWidth - this.leftMargin - this.rightMargin;
                col = (colSpace -= (this.numColumns - 1) * this.horizontalSpacing) / this.numColumns;
                for (i = 0; i < this.numColumns; ++i) {
                    columnWidths[i] = col;
                }
            } else {
                tableWidth = maxWidth;
                columnWidths = this.maxColumnWidths;
            }
        } else {
            columnWidths = new int[this.numColumns];
            if (this.makeColumnsEqualWidth) {
                colSpace = tableWidth - this.leftMargin - this.rightMargin;
                col = (colSpace -= (this.numColumns - 1) * this.horizontalSpacing) / this.numColumns;
                for (i = 0; i < this.numColumns; ++i) {
                    columnWidths[i] = col;
                }
            } else {
                columnWidths = this.assignExtraSpace(tableWidth, maxWidth, minWidth);
            }
        }
        int totalHeight = 0;
        int innerHeight = 0;
        for (i = 0; i < this.grid.size(); ++i) {
            TableWrapData[] row = (TableWrapData[])this.grid.elementAt(i);
            int rowHeight = 0;
            for (int j = 0; j < this.numColumns; ++j) {
                RowSpan rowspan;
                TableWrapData td = row[j];
                if (!td.isItemData) continue;
                Control child = children[td.childIndex];
                int span = td.colspan;
                int cwidth = 0;
                for (int k = j; k < j + span; ++k) {
                    if (k > j) {
                        cwidth += this.horizontalSpacing;
                    }
                    cwidth += columnWidths[k];
                }
                int cy = td.heightHint;
                if (cy == -1) {
                    Point size = this.computeSize(child, cwidth, td.indent, changed);
                    cy = size.y;
                }
                if ((rowspan = (RowSpan)this.rowspans.get(child)) != null) {
                    rowspan.height = cy;
                    continue;
                }
                rowHeight = Math.max(rowHeight, cy);
            }
            this.updateRowSpans(i, rowHeight);
            if (i > 0) {
                innerHeight += this.verticalSpacing;
            }
            innerHeight += rowHeight;
        }
        if (!this.rowspans.isEmpty()) {
            innerHeight = this.compensateForRowSpans(innerHeight);
        }
        totalHeight = this.topMargin + innerHeight + this.bottomMargin;
        return new Point(tableWidth, totalHeight);
    }

    private void updateRowSpans(int row, int rowHeight) {
        if (this.rowspans == null || this.rowspans.size() == 0) {
            return;
        }
        Enumeration enumeration = this.rowspans.elements();
        while (enumeration.hasMoreElements()) {
            RowSpan rowspan = (RowSpan)enumeration.nextElement();
            rowspan.update(row, rowHeight);
        }
    }

    private int compensateForRowSpans(int totalHeight) {
        Enumeration enumeration = this.rowspans.elements();
        while (enumeration.hasMoreElements()) {
            RowSpan rowspan = (RowSpan)enumeration.nextElement();
            totalHeight += rowspan.getRequiredHeightIncrease();
        }
        return totalHeight;
    }

    int internalGetMinimumWidth(Composite parent, boolean changed) {
        int i;
        if (changed) {
            this.calculateMinimumColumnWidths(parent, true);
        }
        int minimumWidth = 0;
        this.widestColumnWidth = 0;
        if (this.makeColumnsEqualWidth) {
            for (i = 0; i < this.numColumns; ++i) {
                this.widestColumnWidth = Math.max(this.widestColumnWidth, this.minColumnWidths[i]);
            }
        }
        for (i = 0; i < this.numColumns; ++i) {
            if (i > 0) {
                minimumWidth += this.horizontalSpacing;
            }
            if (this.makeColumnsEqualWidth) {
                minimumWidth += this.widestColumnWidth;
                continue;
            }
            minimumWidth += this.minColumnWidths[i];
        }
        return minimumWidth += this.leftMargin + this.rightMargin;
    }

    int internalGetMaximumWidth(Composite parent, boolean changed) {
        if (changed) {
            this.calculateMaximumColumnWidths(parent, true);
        }
        int maximumWidth = 0;
        for (int i = 0; i < this.numColumns; ++i) {
            if (i > 0) {
                maximumWidth += this.horizontalSpacing;
            }
            maximumWidth += this.maxColumnWidths[i];
        }
        return maximumWidth += this.leftMargin + this.rightMargin;
    }

    void resetColumnWidths() {
        int i;
        if (this.minColumnWidths == null) {
            this.minColumnWidths = new int[this.numColumns];
        }
        if (this.maxColumnWidths == null) {
            this.maxColumnWidths = new int[this.numColumns];
        }
        for (i = 0; i < this.numColumns; ++i) {
            this.minColumnWidths[i] = 0;
        }
        for (i = 0; i < this.numColumns; ++i) {
            this.maxColumnWidths[i] = 0;
        }
    }

    void calculateMinimumColumnWidths(Composite parent, boolean changed) {
        Control[] children = parent.getChildren();
        for (int i = 0; i < this.grid.size(); ++i) {
            TableWrapData[] row = (TableWrapData[])this.grid.elementAt(i);
            for (int j = 0; j < this.numColumns; ++j) {
                Composite cc;
                Layout l;
                TableWrapData td = row[j];
                if (!td.isItemData) continue;
                Control child = children[td.childIndex];
                int minWidth = -1;
                if (child instanceof Composite && (l = (cc = (Composite)child).getLayout()) instanceof ILayoutExtension) {
                    minWidth = ((ILayoutExtension)l).computeMinimumWidth(cc, changed);
                }
                if (minWidth == -1) {
                    int minWHint = this.isWrap(child) ? 0 : -1;
                    Point size = child.computeSize(minWHint, -1, changed);
                    minWidth = size.x;
                }
                minWidth += td.indent;
                if (td.colspan == 1) {
                    this.minColumnWidths[j] = Math.max(this.minColumnWidths[j], minWidth);
                    continue;
                }
                int current = 0;
                for (int k = j; k < j + td.colspan; ++k) {
                    if (k > j) {
                        current += this.horizontalSpacing;
                    }
                    current += this.minColumnWidths[k];
                }
                if (minWidth <= current) continue;
                int ndiv = 0;
                if (this.growingColumns != null) {
                    for (int k = j; k < j + td.colspan; ++k) {
                        if (!this.isGrowingColumn(k)) continue;
                        ++ndiv;
                    }
                }
                if (ndiv == 0) {
                    int n = j + td.colspan - 1;
                    this.minColumnWidths[n] = this.minColumnWidths[n] + (minWidth - current);
                    continue;
                }
                int percolumn = (current - td.colspan) / ndiv;
                if ((current - td.colspan) % ndiv > 0) {
                    ++percolumn;
                }
                for (int k = j; k < j + td.colspan; ++k) {
                    if (!this.isGrowingColumn(k)) continue;
                    int n = k;
                    this.minColumnWidths[n] = this.minColumnWidths[n] + percolumn;
                }
            }
        }
    }

    boolean isWrap(Control control) {
        if (control instanceof Composite && ((Composite)control).getLayout() instanceof ILayoutExtension) {
            return true;
        }
        return (control.getStyle() & 0x40) != 0;
    }

    void calculateMaximumColumnWidths(Composite parent, boolean changed) {
        int i;
        Control[] children = parent.getChildren();
        for (i = 0; i < this.numColumns; ++i) {
            this.maxColumnWidths[i] = 0;
        }
        for (i = 0; i < this.grid.size(); ++i) {
            TableWrapData[] row = (TableWrapData[])this.grid.elementAt(i);
            for (int j = 0; j < this.numColumns; ++j) {
                TableWrapData td = row[j];
                if (!td.isItemData) continue;
                Control child = children[td.childIndex];
                int maxWidth = -1;
                if (child instanceof Composite) {
                    Composite cc = (Composite)child;
                    Layout l = cc.getLayout();
                    if (l instanceof ILayoutExtension) {
                        maxWidth = ((ILayoutExtension)l).computeMaximumWidth(cc, changed);
                    }
                } else if (td.maxWidth != -1) {
                    maxWidth = td.maxWidth;
                }
                if (maxWidth == -1) {
                    Point size = child.computeSize(-1, -1, changed);
                    maxWidth = size.x;
                }
                maxWidth += td.indent;
                if (td.colspan == 1) {
                    this.maxColumnWidths[j] = Math.max(this.maxColumnWidths[j], maxWidth);
                    continue;
                }
                int current = 0;
                for (int k = j; k < j + td.colspan; ++k) {
                    if (k > j) {
                        current += this.horizontalSpacing;
                    }
                    current += this.maxColumnWidths[k];
                }
                if (maxWidth <= current) continue;
                int ndiv = 0;
                if (this.growingColumns != null) {
                    for (int k = j; k < j + td.colspan; ++k) {
                        if (!this.isGrowingColumn(k)) continue;
                        ++ndiv;
                    }
                }
                if (ndiv == 0) {
                    int n = j + td.colspan - 1;
                    this.maxColumnWidths[n] = this.maxColumnWidths[n] + (maxWidth - current);
                    continue;
                }
                int percolumn = (current - td.colspan) / ndiv;
                if ((current - td.colspan) % ndiv > 0) {
                    ++percolumn;
                }
                percolumn /= td.rowspan;
                for (int k = j; k < j + td.colspan; ++k) {
                    if (!this.isGrowingColumn(k)) continue;
                    int n = k;
                    this.maxColumnWidths[n] = this.maxColumnWidths[n] + percolumn;
                }
            }
        }
    }

    private void initializeIfNeeded(Composite parent, boolean changed) {
        if (changed) {
            this.initialLayout = true;
        }
        if (this.initialLayout) {
            this.initializeLayoutData(parent);
            this.initialLayout = false;
        }
    }

    void initializeLayoutData(Composite composite) {
        Control[] children = composite.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control child = children[i];
            if (child.getLayoutData() != null) continue;
            child.setLayoutData((Object)new TableWrapData());
        }
    }

    private class RowSpan {
        Control child;
        int row;
        int column;
        int height;
        int totalHeight;

        public RowSpan(Control child, int column, int row) {
            this.child = child;
            this.column = column;
            this.row = row;
        }

        public void update(int currentRow, int rowHeight) {
            TableWrapData td = (TableWrapData)this.child.getLayoutData();
            if (currentRow - this.row <= td.rowspan - 1) {
                this.totalHeight += rowHeight;
                if (currentRow > this.row) {
                    this.totalHeight += TableWrapLayout.this.verticalSpacing;
                }
            }
        }

        public int getRequiredHeightIncrease() {
            if (this.totalHeight < this.height) {
                return this.height - this.totalHeight;
            }
            return 0;
        }
    }
}

