/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class BufferedResourceNode
extends ResourceNode {
    private boolean fDirty = false;
    private IFile fDeleteFile;

    public BufferedResourceNode(IResource resource) {
        super(resource);
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    protected IStructureComparator createChild(IResource child) {
        return new BufferedResourceNode(child);
    }

    public void setContent(byte[] contents) {
        this.fDirty = true;
        super.setContent(contents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void commit(IProgressMonitor pm) throws CoreException {
        if (!this.fDirty) return;
        if (this.fDeleteFile != null) {
            this.fDeleteFile.delete(true, true, pm);
            return;
        }
        IResource resource = this.getResource();
        if (!(resource instanceof IFile)) return;
        byte[] bytes = this.getContent();
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        try {
            IFile file = (IFile)resource;
            if (file.exists()) {
                file.setContents((InputStream)is, false, true, pm);
            } else {
                file.create((InputStream)is, false, pm);
            }
            this.fDirty = false;
            Object var7_6 = null;
            if (is == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            is.close();
            return;
        }
        catch (IOException ex) {}
    }

    public ITypedElement replace(ITypedElement child, ITypedElement other) {
        IFile file;
        IFolder folder;
        IResource resource;
        if (child == null && (resource = this.getResource()) instanceof IFolder) {
            folder = (IFolder)resource;
            file = folder.getFile(other.getName());
            child = new BufferedResourceNode((IResource)file);
        }
        if (other == null) {
            resource = this.getResource();
            if (resource instanceof IFolder && (file = (folder = (IFolder)resource).getFile(child.getName())) != null && file.exists()) {
                this.fDeleteFile = file;
                this.fDirty = true;
            }
            return null;
        }
        if (other instanceof IStreamContentAccessor && child instanceof IEditableContent) {
            IEditableContent dst = (IEditableContent)((Object)child);
            try {
                InputStream is = ((IStreamContentAccessor)((Object)other)).getContents();
                byte[] bytes = Utilities.readBytes(is);
                if (bytes != null) {
                    dst.setContent(bytes);
                }
            }
            catch (CoreException ex) {
                // empty catch block
            }
        }
        return child;
    }
}

