/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.resources.CVSEntryLineTag;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Util;
import org.eclipse.team.internal.ccvs.ui.CVSPropertiesPage;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;

public class CVSFolderPropertiesPage
extends CVSPropertiesPage {
    IFolder folder;
    private Label root;
    private Label repository;
    static /* synthetic */ Class class$org$eclipse$core$resources$IFolder;

    protected Control createContents(Composite parent) {
        this.initialize();
        this.noDefaultAndApplyButton();
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        try {
            ICVSFolder cvsResource = CVSWorkspaceRoot.getCVSFolderFor((IContainer)this.folder);
            if (!cvsResource.isManaged()) {
                if (cvsResource.isIgnored()) {
                    this.createLabel(composite, Policy.bind("CVSFolderPropertiesPage.ignored"), 2);
                } else {
                    this.createLabel(composite, Policy.bind("CVSFolderPropertiesPage.notManaged"), 2);
                }
            } else if (!cvsResource.isCVSFolder()) {
                this.createLabel(composite, Policy.bind("CVSFolderPropertiesPage.notCVSFolder"), 2);
            } else {
                FolderSyncInfo syncInfo = cvsResource.getFolderSyncInfo();
                this.createLabel(composite, Policy.bind("CVSFolderPropertiesPage.root"));
                this.root = this.createLabel(composite, syncInfo.getRoot());
                this.createLabel(composite, Policy.bind("CVSFolderPropertiesPage.repository"));
                this.repository = this.createLabel(composite, syncInfo.getRepository());
                this.createLabel(composite, Policy.bind("CVSFilePropertiesPage.tag"));
                CVSEntryLineTag tag = syncInfo.getTag();
                if (tag != null && tag.getType() == 1) {
                    tag = Util.getAccurateFolderTag((IResource)this.folder, (CVSTag)tag);
                }
                this.createLabel(composite, CVSFolderPropertiesPage.getTagLabel((CVSTag)tag));
                if (syncInfo.getIsStatic()) {
                    this.createLabel(composite, Policy.bind("CVSFolderPropertiesPage.static"));
                    this.createLabel(composite, syncInfo.getIsStatic() ? Policy.bind("yes") : Policy.bind("no"));
                }
                this.createLabel(composite, "", 2);
                final Button disconnect = new Button(composite, 0);
                disconnect.setText(Policy.bind("CVSFolderPropertiesPage.disconnect"));
                GridData data = new GridData(128);
                data.heightHint = this.convertVerticalDLUsToPixels(14);
                int widthHint = this.convertHorizontalDLUsToPixels(61);
                data.widthHint = Math.max(widthHint, disconnect.computeSize((int)-1, (int)-1, (boolean)true).x);
                disconnect.setLayoutData((Object)data);
                disconnect.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        if (CVSFolderPropertiesPage.this.disconnectFolder()) {
                            CVSFolderPropertiesPage.this.root.setText(Policy.bind("CVSFilePropertiesPage.none"));
                            CVSFolderPropertiesPage.this.repository.setText(Policy.bind("CVSFilePropertiesPage.none"));
                            disconnect.setEnabled(false);
                        }
                    }
                });
            }
        }
        catch (TeamException e) {
            this.createLabel(composite, Policy.bind("CVSFilePropertiesPage.error"), 2);
        }
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.team.cvs.ui.folder_property_page_context");
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    protected Label createLabel(Composite parent, String text, int span) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = span;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    protected Label createLabel(Composite parent, String text) {
        return this.createLabel(parent, text, 1);
    }

    private void initialize() {
        this.folder = null;
        IAdaptable element = this.getElement();
        if (element instanceof IFolder) {
            this.folder = (IFolder)element;
        } else {
            Object adapter = element.getAdapter(class$org$eclipse$core$resources$IFolder == null ? (class$org$eclipse$core$resources$IFolder = CVSFolderPropertiesPage.class$("org.eclipse.core.resources.IFolder")) : class$org$eclipse$core$resources$IFolder);
            if (adapter instanceof IFolder) {
                this.folder = (IFolder)adapter;
            }
        }
    }

    private boolean disconnectFolder() {
        if (MessageDialog.openQuestion((Shell)this.getShell(), (String)Policy.bind("CVSFolderPropertiesPage.disconnectTitle"), (String)Policy.bind("CVSFolderPropertiesPage.disconnectQuestion"))) {
            final ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)this.folder);
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            cvsFolder.unmanage(null);
                        }
                        catch (CVSException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                CVSUIPlugin.openError(this.getShell(), null, null, e);
                return false;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

