/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.CyclePartAction;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;

public class CycleEditorAction
extends CyclePartAction {
    public CycleEditorAction(IWorkbenchWindow window, boolean forward) {
        super(window, forward);
        this.updateState();
    }

    protected void setText() {
        if (this.forward) {
            this.setText(WorkbenchMessages.getString("CycleEditorAction.next.text"));
            this.setToolTipText(WorkbenchMessages.getString("CycleEditorAction.next.toolTip"));
            WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.cycle_editor_forward_action_context");
            this.setActionDefinitionId("org.eclipse.ui.window.nextEditor");
        } else {
            this.setText(WorkbenchMessages.getString("CycleEditorAction.prev.text"));
            this.setToolTipText(WorkbenchMessages.getString("CycleEditorAction.prev.toolTip"));
            WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.cycle_editor_backward_action_context");
            this.setActionDefinitionId("org.eclipse.ui.window.previousEditor");
        }
    }

    public void updateState() {
        WorkbenchPage page = (WorkbenchPage)this.getActivePage();
        if (page == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(page.getSortedEditors().length >= 1);
    }

    protected void addItems(Table table, WorkbenchPage page) {
        IEditorReference[] refs = page.getSortedEditors();
        for (int i = refs.length - 1; i >= 0; --i) {
            TableItem item = null;
            item = new TableItem(table, 0);
            if (refs[i].isDirty()) {
                item.setText("*" + refs[i].getTitle());
            } else {
                item.setText(refs[i].getTitle());
            }
            item.setImage(refs[i].getTitleImage());
            item.setData((Object)refs[i]);
        }
    }

    protected String getTableHeader() {
        return WorkbenchMessages.getString("CycleEditorAction.header");
    }
}

