/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.progress;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.internal.misc.Assert;
import org.eclipse.ui.internal.progress.PendingUpdateAdapter;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.WorkbenchJob;

public class DeferredTreeContentManager {
    ITreeContentProvider contentProvider;
    AbstractTreeViewer treeViewer;
    IWorkbenchSiteProgressService progressService;
    static /* synthetic */ Class class$org$eclipse$ui$progress$IWorkbenchSiteProgressService;
    static /* synthetic */ Class class$org$eclipse$ui$progress$IDeferredWorkbenchAdapter;
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;

    public DeferredTreeContentManager(ITreeContentProvider provider, AbstractTreeViewer viewer, IWorkbenchPartSite site) {
        this(provider, viewer);
        Object siteService = site.getAdapter(class$org$eclipse$ui$progress$IWorkbenchSiteProgressService == null ? (class$org$eclipse$ui$progress$IWorkbenchSiteProgressService = DeferredTreeContentManager.class$("org.eclipse.ui.progress.IWorkbenchSiteProgressService")) : class$org$eclipse$ui$progress$IWorkbenchSiteProgressService);
        if (siteService != null) {
            this.progressService = (IWorkbenchSiteProgressService)siteService;
        }
    }

    public DeferredTreeContentManager(ITreeContentProvider provider, AbstractTreeViewer viewer) {
        this.contentProvider = provider;
        this.treeViewer = viewer;
    }

    public boolean mayHaveChildren(Object element) {
        IDeferredWorkbenchAdapter adapter = this.getAdapter(element);
        Assert.isNotNull(element, ProgressMessages.getString("DeferredTreeContentManager.NotDeferred"));
        return adapter.isContainer();
    }

    public Object[] getChildren(Object parent) {
        IDeferredWorkbenchAdapter element = this.getAdapter(parent);
        if (element == null) {
            return null;
        }
        PendingUpdateAdapter placeholder = new PendingUpdateAdapter();
        this.startFetchingDeferredChildren(parent, element, placeholder);
        return new Object[]{placeholder};
    }

    protected IDeferredWorkbenchAdapter getAdapter(Object element) {
        if (element instanceof IDeferredWorkbenchAdapter) {
            return (IDeferredWorkbenchAdapter)element;
        }
        if (!(element instanceof IAdaptable)) {
            return null;
        }
        Object adapter = ((IAdaptable)element).getAdapter(class$org$eclipse$ui$progress$IDeferredWorkbenchAdapter == null ? (class$org$eclipse$ui$progress$IDeferredWorkbenchAdapter = DeferredTreeContentManager.class$("org.eclipse.ui.progress.IDeferredWorkbenchAdapter")) : class$org$eclipse$ui$progress$IDeferredWorkbenchAdapter);
        if (adapter == null) {
            return null;
        }
        return (IDeferredWorkbenchAdapter)adapter;
    }

    protected void startFetchingDeferredChildren(final Object parent, final IDeferredWorkbenchAdapter adapter, final PendingUpdateAdapter placeholder) {
        final IElementCollector collector = this.createElementCollector(parent, placeholder);
        Platform.getJobManager().cancel(parent);
        String jobName = ProgressMessages.format("DeferredTreeContentManager.FetchingName", new Object[]{adapter.getLabel(parent)});
        Job job = new Job(jobName){

            public IStatus run(IProgressMonitor monitor) {
                adapter.fetchDeferredChildren(parent, collector, monitor);
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return this.isParent(family, parent);
            }

            private boolean isParent(Object family, Object child) {
                if (family.equals(child)) {
                    return true;
                }
                IWorkbenchAdapter workbenchAdapter = this.getWorkbenchAdapter(child);
                if (workbenchAdapter == null) {
                    return false;
                }
                Object elementParent = workbenchAdapter.getParent(child);
                if (elementParent == null) {
                    return false;
                }
                return this.isParent(family, elementParent);
            }

            private IWorkbenchAdapter getWorkbenchAdapter(Object element) {
                if (element instanceof IWorkbenchAdapter) {
                    return (IWorkbenchAdapter)element;
                }
                if (!(element instanceof IAdaptable)) {
                    return null;
                }
                Object workbenchAdapter = ((IAdaptable)element).getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = DeferredTreeContentManager.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter);
                if (workbenchAdapter == null) {
                    return null;
                }
                return (IWorkbenchAdapter)workbenchAdapter;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                DeferredTreeContentManager.this.runClearPlaceholderJob(placeholder);
            }
        });
        job.setRule(adapter.getRule(parent));
        if (this.progressService == null) {
            job.schedule();
        } else {
            this.progressService.schedule(job);
        }
    }

    protected void addChildren(final Object parent, final Object[] children, IProgressMonitor monitor) {
        WorkbenchJob updateJob = new WorkbenchJob(ProgressMessages.getString("DeferredTreeContentManager.AddingChildren")){

            public IStatus runInUIThread(IProgressMonitor updateMonitor) {
                if (DeferredTreeContentManager.this.treeViewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                DeferredTreeContentManager.this.treeViewer.getControl().setRedraw(false);
                DeferredTreeContentManager.this.treeViewer.add(parent, children);
                DeferredTreeContentManager.this.treeViewer.getControl().setRedraw(true);
                return Status.OK_STATUS;
            }
        };
        updateJob.setSystem(true);
        updateJob.schedule();
    }

    public boolean isDeferredAdapter(Object element) {
        return this.getAdapter(element) != null;
    }

    protected void runClearPlaceholderJob(final PendingUpdateAdapter placeholder) {
        if (placeholder.isRemoved()) {
            return;
        }
        WorkbenchJob clearJob = new WorkbenchJob(ProgressMessages.getString("DeferredTreeContentManager.ClearJob")){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (!placeholder.isRemoved()) {
                    Control control = DeferredTreeContentManager.this.treeViewer.getControl();
                    if (control.isDisposed()) {
                        return Status.CANCEL_STATUS;
                    }
                    DeferredTreeContentManager.this.treeViewer.remove((Object)placeholder);
                    placeholder.setRemoved(true);
                }
                return Status.OK_STATUS;
            }
        };
        clearJob.setSystem(true);
        clearJob.schedule();
    }

    public void cancel(Object parent) {
        Platform.getJobManager().cancel(parent);
    }

    protected IElementCollector createElementCollector(final Object parent, final PendingUpdateAdapter placeholder) {
        return new IElementCollector(){

            public void add(Object element, IProgressMonitor monitor) {
                this.add(new Object[]{element}, monitor);
            }

            public void add(Object[] elements, IProgressMonitor monitor) {
                DeferredTreeContentManager.this.addChildren(parent, elements, monitor);
            }

            public void done() {
                DeferredTreeContentManager.this.runClearPlaceholderJob(placeholder);
            }
        };
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

