/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.registry.ExtensionDelta;
import org.eclipse.core.internal.registry.ExtensionPoint;
import org.eclipse.core.internal.registry.Namespace;
import org.eclipse.core.internal.registry.NestedRegistryModelObject;
import org.eclipse.core.internal.registry.ReadWriteMonitor;
import org.eclipse.core.internal.registry.RegistryCacheReader;
import org.eclipse.core.internal.registry.RegistryChangeEvent;
import org.eclipse.core.internal.registry.RegistryDelta;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.ListenerList;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class ExtensionRegistry
extends NestedRegistryModelObject
implements IExtensionRegistry {
    public static boolean DEBUG;
    private static final String OPTION_DEBUG_EVENTS_EXTENSION = "org.eclipse.core.runtime/registry/debug/events/extension";
    private ReadWriteMonitor access = new ReadWriteMonitor();
    private Map allFragmentNames = new HashMap(11);
    private transient Map deltas = new HashMap(11);
    private Map elements = new HashMap(11);
    private transient boolean isDirty = false;
    private transient ListenerList listeners = new ListenerList();
    private Map orphanExtensions = new HashMap(11);
    private transient RegistryCacheReader reader = null;

    public ExtensionRegistry() {
        String debugOption = InternalPlatform.getDefault().getOption(OPTION_DEBUG_EVENTS_EXTENSION);
        boolean bl = DEBUG = debugOption == null ? false : debugOption.equalsIgnoreCase("true");
        if (DEBUG) {
            this.addRegistryChangeListener(new IRegistryChangeListener(){

                public void registryChanged(IRegistryChangeEvent event) {
                    System.out.println(event);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Namespace element) {
        this.access.enterWrite();
        try {
            this.isDirty = true;
            this.basicAdd(element, true);
            this.fireRegistryChangeEvent();
        }
        finally {
            this.access.exitWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Namespace[] elements) {
        this.access.enterWrite();
        try {
            this.isDirty = true;
            for (int i = 0; i < elements.length; ++i) {
                this.basicAdd(elements[i], true);
            }
            this.fireRegistryChangeEvent();
        }
        finally {
            this.access.exitWrite();
        }
    }

    private Object addArrays(Object a, Object b) {
        Object[] result = (Object[])Array.newInstance(a.getClass().getComponentType(), Array.getLength(a) + Array.getLength(b));
        System.arraycopy(a, 0, result, 0, Array.getLength(a));
        System.arraycopy(b, 0, result, Array.getLength(a), Array.getLength(b));
        return result;
    }

    private void addExtension(IExtension extension) {
        IExtension[] newExtensions;
        IExtensionPoint extPoint = this.basicGetExtensionPoint(extension.getExtensionPointUniqueIdentifier());
        if (extPoint == null) {
            IExtension[] existingOrphanExtensions = (IExtension[])this.orphanExtensions.get(extension.getExtensionPointUniqueIdentifier());
            if (existingOrphanExtensions != null) {
                IExtension[] newOrphanExtensions = new IExtension[existingOrphanExtensions.length + 1];
                System.arraycopy(existingOrphanExtensions, 0, newOrphanExtensions, 0, existingOrphanExtensions.length);
                newOrphanExtensions[newOrphanExtensions.length - 1] = extension;
                this.orphanExtensions.put(extension.getExtensionPointUniqueIdentifier(), newOrphanExtensions);
            } else {
                this.orphanExtensions.put(extension.getExtensionPointUniqueIdentifier(), new IExtension[]{extension});
            }
            return;
        }
        IExtension[] existingExtensions = extPoint.getExtensions();
        if (existingExtensions.length == 0) {
            newExtensions = new IExtension[]{extension};
        } else {
            newExtensions = new IExtension[existingExtensions.length + 1];
            System.arraycopy(existingExtensions, 0, newExtensions, 0, existingExtensions.length);
            newExtensions[newExtensions.length - 1] = extension;
        }
        this.link(extPoint, newExtensions);
        this.recordChange(extPoint, extension, 1);
    }

    private void addExtensionPoint(IExtensionPoint extPoint) {
        IExtension[] existingExtensions = (IExtension[])this.orphanExtensions.remove(extPoint.getUniqueIdentifier());
        if (existingExtensions == null) {
            return;
        }
        this.link(extPoint, existingExtensions);
        this.recordChange(extPoint, existingExtensions, 1);
    }

    private void addExtensionsAndExtensionPoints(Namespace element) {
        IExtensionPoint[] extPoints = element.getExtensionPoints();
        for (int i = 0; i < extPoints.length; ++i) {
            this.addExtensionPoint(extPoints[i]);
        }
        IExtension[] extensions = element.getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            this.addExtension(extensions[i]);
        }
    }

    private void addFragmentTo(String fragmentName, String masterName) {
        HashSet<String> fragmentNames = (HashSet<String>)this.allFragmentNames.get(masterName);
        if (fragmentNames == null) {
            fragmentNames = new HashSet<String>();
            this.allFragmentNames.put(masterName, fragmentNames);
        }
        fragmentNames.add(fragmentName);
    }

    public void addRegistryChangeListener(IRegistryChangeListener listener) {
        this.addRegistryChangeListener(listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRegistryChangeListener(IRegistryChangeListener listener, String filter) {
        ListenerList listenerList = this.listeners;
        synchronized (listenerList) {
            this.listeners.add(new ListenerInfo(listener, filter));
        }
    }

    void basicAdd(Namespace element, boolean link) {
        if (element.getUniqueIdentifier() == null) {
            return;
        }
        if (this.elements.containsKey(element.getUniqueIdentifier())) {
            throw new IllegalArgumentException("Element already added: " + element.getUniqueIdentifier());
        }
        this.elements.put(element.getUniqueIdentifier(), element);
        element.setParent(this);
        if (!link) {
            return;
        }
        if (element.isFragment()) {
            this.addFragmentTo(element.getUniqueIdentifier(), element.getHostIdentifier());
            if (!this.elements.containsKey(element.getHostIdentifier())) {
                return;
            }
        } else {
            Collection fragmentNames = this.getFragmentNames(element.getUniqueIdentifier());
            Iterator iter = fragmentNames.iterator();
            while (iter.hasNext()) {
                Namespace fragment = (Namespace)this.elements.get(iter.next());
                this.addExtensionsAndExtensionPoints(fragment);
            }
        }
        this.addExtensionsAndExtensionPoints(element);
    }

    private IExtensionPoint basicGetExtensionPoint(String xptUniqueId) {
        int lastdot = xptUniqueId.lastIndexOf(46);
        if (lastdot == -1) {
            return null;
        }
        return this.basicGetExtensionPoint(xptUniqueId.substring(0, lastdot), xptUniqueId.substring(lastdot + 1));
    }

    private IExtensionPoint basicGetExtensionPoint(String elementName, String xpt) {
        Namespace element = (Namespace)this.elements.get(elementName);
        if (element == null) {
            return null;
        }
        IExtensionPoint extPoint = element.getExtensionPoint(xpt);
        if (extPoint != null) {
            return extPoint;
        }
        Collection fragmentNames = this.getFragmentNames(elementName);
        Iterator iter = fragmentNames.iterator();
        while (iter.hasNext()) {
            extPoint = ((Namespace)this.elements.get(iter.next())).getExtensionPoint(xpt);
            if (extPoint == null) continue;
            return extPoint;
        }
        return null;
    }

    private IExtensionPoint[] basicGetExtensionPoints() {
        ArrayList<IExtensionPoint> extensionPoints = new ArrayList<IExtensionPoint>();
        Iterator iter = this.elements.values().iterator();
        while (iter.hasNext()) {
            Namespace model = (Namespace)iter.next();
            IExtensionPoint[] toAdd = model.getExtensionPoints();
            for (int i = 0; i < toAdd.length; ++i) {
                extensionPoints.add(toAdd[i]);
            }
        }
        return extensionPoints.toArray(new IExtensionPoint[extensionPoints.size()]);
    }

    private IExtensionPoint[] basicGetExtensionPoints(String elementName) {
        Namespace element = (Namespace)this.elements.get(elementName);
        if (element == null) {
            return new IExtensionPoint[0];
        }
        Collection fragmentNames = this.getFragmentNames(elementName);
        IExtensionPoint[] allExtensionPoints = element.getExtensionPoints();
        Iterator iter = fragmentNames.iterator();
        while (iter.hasNext()) {
            Namespace fragment = (Namespace)this.elements.get(iter.next());
            allExtensionPoints = (IExtensionPoint[])this.addArrays(allExtensionPoints, fragment.getExtensionPoints());
        }
        return allExtensionPoints;
    }

    private IExtension[] basicGetExtensions(String elementName) {
        Namespace element = (Namespace)this.elements.get(elementName);
        if (element == null) {
            return new IExtension[0];
        }
        Collection fragmentNames = this.getFragmentNames(elementName);
        IExtension[] allExtensions = element.getExtensions();
        Iterator iter = fragmentNames.iterator();
        while (iter.hasNext()) {
            Namespace fragment = (Namespace)this.elements.get(iter.next());
            allExtensions = (IExtension[])this.addArrays(allExtensions, fragment.getExtensions());
        }
        return allExtensions;
    }

    Namespace basicGetNamespace(String elementId) {
        return (Namespace)this.elements.get(elementId);
    }

    String[] basicGetNamespaces() {
        return this.elements.keySet().toArray(new String[this.elements.size()]);
    }

    private boolean basicRemove(String elementName, long bundleId) {
        if (elementName == null) {
            return false;
        }
        Namespace element = (Namespace)this.elements.get(elementName);
        if (element == null) {
            if (DEBUG) {
                System.out.println("********* Element unknown: " + elementName + " - not removed.");
            }
            return false;
        }
        if (element.getId() != bundleId) {
            return false;
        }
        this.isDirty = true;
        if (element.isFragment()) {
            if (!this.elements.containsKey(element.getHostIdentifier())) {
                this.removeFragmentFrom(elementName, element.getHostIdentifier());
                this.elements.remove(elementName);
                return true;
            }
        } else {
            Collection fragmentNames = this.getFragmentNames(element.getUniqueIdentifier());
            Iterator iter = fragmentNames.iterator();
            while (iter.hasNext()) {
                Namespace fragment = (Namespace)this.elements.get(iter.next());
                this.removeExtensionsAndExtensionPoints(fragment);
            }
        }
        this.removeExtensionsAndExtensionPoints(element);
        this.removeFragmentFrom(elementName, element.getHostIdentifier());
        this.elements.remove(elementName);
        element.setParent(null);
        return true;
    }

    void enterRead() {
        this.access.enterRead();
    }

    void exitRead() {
        this.access.exitRead();
    }

    private void fireRegistryChangeEvent() {
        if (this.deltas.isEmpty() || this.listeners.isEmpty()) {
            return;
        }
        Object[] tmpListeners = this.listeners.getListeners();
        HashMap tmpDeltas = new HashMap(this.deltas);
        this.deltas.clear();
        new ExtensionEventDispatcherJob(tmpListeners, tmpDeltas).schedule();
    }

    RegistryCacheReader getCacheReader() {
        return this.reader;
    }

    public IConfigurationElement[] getConfigurationElementsFor(String extensionPointId) {
        int lastdot = extensionPointId.lastIndexOf(46);
        if (lastdot == -1) {
            return new IConfigurationElement[0];
        }
        return this.getConfigurationElementsFor(extensionPointId.substring(0, lastdot), extensionPointId.substring(lastdot + 1));
    }

    public IConfigurationElement[] getConfigurationElementsFor(String pluginId, String extensionPointSimpleId) {
        IExtensionPoint extPoint = this.getExtensionPoint(pluginId, extensionPointSimpleId);
        if (extPoint == null) {
            return new IConfigurationElement[0];
        }
        return extPoint.getConfigurationElements();
    }

    public IConfigurationElement[] getConfigurationElementsFor(String pluginId, String extensionPointName, String extensionId) {
        IExtension extension = this.getExtension(pluginId, extensionPointName, extensionId);
        if (extension == null) {
            return new IConfigurationElement[0];
        }
        return extension.getConfigurationElements();
    }

    private RegistryDelta getDelta(String elementName) {
        RegistryDelta existingDelta = (RegistryDelta)this.deltas.get(elementName);
        if (existingDelta != null) {
            return existingDelta;
        }
        RegistryDelta delta = new RegistryDelta(elementName);
        this.deltas.put(elementName, delta);
        return delta;
    }

    public IExtension getExtension(String extensionId) {
        int lastdot = extensionId.lastIndexOf(46);
        if (lastdot == -1) {
            return null;
        }
        String namespace = extensionId.substring(0, lastdot);
        Namespace element = this.getNamespace(namespace);
        return element.getExtension(extensionId.substring(lastdot + 1));
    }

    public IExtension getExtension(String extensionPointId, String extensionId) {
        int lastdot = extensionPointId.lastIndexOf(46);
        if (lastdot == -1) {
            return null;
        }
        return this.getExtension(extensionPointId.substring(0, lastdot), extensionPointId.substring(lastdot + 1), extensionId);
    }

    public IExtension getExtension(String pluginId, String extensionPointName, String extensionId) {
        IExtensionPoint extPoint = this.getExtensionPoint(pluginId, extensionPointName);
        if (extPoint != null) {
            return extPoint.getExtension(extensionId);
        }
        return null;
    }

    public IExtensionPoint getExtensionPoint(String xptUniqueId) {
        int lastdot = xptUniqueId.lastIndexOf(46);
        if (lastdot == -1) {
            return null;
        }
        return this.getExtensionPoint(xptUniqueId.substring(0, lastdot), xptUniqueId.substring(lastdot + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IExtensionPoint getExtensionPoint(String elementName, String xpt) {
        this.access.enterRead();
        try {
            IExtensionPoint iExtensionPoint = this.basicGetExtensionPoint(elementName, xpt);
            return iExtensionPoint;
        }
        finally {
            this.access.exitRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IExtensionPoint[] getExtensionPoints() {
        this.access.enterRead();
        try {
            IExtensionPoint[] iExtensionPointArray = this.basicGetExtensionPoints();
            return iExtensionPointArray;
        }
        finally {
            this.access.exitRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IExtensionPoint[] getExtensionPoints(String elementName) {
        this.access.enterRead();
        try {
            IExtensionPoint[] iExtensionPointArray = this.basicGetExtensionPoints(elementName);
            return iExtensionPointArray;
        }
        finally {
            this.access.exitRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IExtension[] getExtensions(String elementName) {
        this.access.enterRead();
        try {
            IExtension[] iExtensionArray = this.basicGetExtensions(elementName);
            return iExtensionArray;
        }
        finally {
            this.access.exitRead();
        }
    }

    private Collection getFragmentNames(String masterName) {
        Collection fragmentNames = (Collection)this.allFragmentNames.get(masterName);
        return fragmentNames == null ? Collections.EMPTY_SET : fragmentNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Namespace getNamespace(String elementId) {
        this.access.enterRead();
        try {
            Namespace namespace = this.basicGetNamespace(elementId);
            return namespace;
        }
        finally {
            this.access.exitRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getNamespaces() {
        this.access.enterRead();
        try {
            String[] stringArray = this.basicGetNamespaces();
            return stringArray;
        }
        finally {
            this.access.exitRead();
        }
    }

    ExtensionRegistry getRegistry() {
        return this;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    private void link(IExtensionPoint extPoint, IExtension[] extensions) {
        ExtensionPoint xpm = (ExtensionPoint)extPoint;
        if (extensions == null || extensions.length == 0) {
            xpm.setExtensions(null);
            return;
        }
        xpm.setExtensions(extensions);
    }

    private void recordChange(IExtensionPoint extPoint, IExtension extension, int kind) {
        if (this.listeners.isEmpty()) {
            return;
        }
        ExtensionDelta extensionDelta = new ExtensionDelta();
        extensionDelta.setExtension(extension);
        extensionDelta.setExtensionPoint(extPoint);
        extensionDelta.setKind(kind);
        this.getDelta(extPoint.getNamespace()).addExtensionDelta(extensionDelta);
    }

    private void recordChange(IExtensionPoint extPoint, IExtension[] extensions, int kind) {
        if (this.listeners.isEmpty()) {
            return;
        }
        if (extensions.length == 0) {
            return;
        }
        RegistryDelta pluginDelta = this.getDelta(extPoint.getNamespace());
        for (int i = 0; i < extensions.length; ++i) {
            ExtensionDelta extensionDelta = new ExtensionDelta();
            extensionDelta.setExtension(extensions[i]);
            extensionDelta.setExtensionPoint(extPoint);
            extensionDelta.setKind(kind);
            pluginDelta.addExtensionDelta(extensionDelta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String elementName, long bundleId) {
        this.access.enterWrite();
        try {
            if (!this.basicRemove(elementName, bundleId)) {
                boolean bl = false;
                return bl;
            }
            this.fireRegistryChangeEvent();
            boolean bl = true;
            return bl;
        }
        finally {
            this.access.exitWrite();
        }
    }

    private void removeExtension(IExtension extension) {
        IExtensionPoint extPoint = this.basicGetExtensionPoint(extension.getExtensionPointUniqueIdentifier());
        if (extPoint == null) {
            IExtension[] existingOrphanExtensions = (IExtension[])this.orphanExtensions.get(extension.getExtensionPointUniqueIdentifier());
            if (existingOrphanExtensions == null) {
                return;
            }
            IExtension[] newOrphanExtensions = new IExtension[existingOrphanExtensions.length - 1];
            int j = 0;
            for (int i = 0; i < existingOrphanExtensions.length; ++i) {
                if (extension == existingOrphanExtensions[i]) continue;
                newOrphanExtensions[j++] = existingOrphanExtensions[i];
            }
            this.orphanExtensions.put(extension.getExtensionPointUniqueIdentifier(), newOrphanExtensions);
            return;
        }
        IExtension[] existingExtensions = extPoint.getExtensions();
        IExtension[] newExtensions = null;
        if (existingExtensions.length >= 1) {
            newExtensions = new IExtension[existingExtensions.length - 1];
            int j = 0;
            for (int i = 0; i < existingExtensions.length; ++i) {
                if (existingExtensions[i] == extension) continue;
                newExtensions[j++] = existingExtensions[i];
            }
        }
        this.link(extPoint, newExtensions);
        this.recordChange(extPoint, extension, 2);
    }

    private void removeExtensionPoint(IExtensionPoint extPoint) {
        IExtension[] existingExtensions = extPoint.getExtensions();
        if (existingExtensions.length == 0) {
            return;
        }
        this.orphanExtensions.put(extPoint.getUniqueIdentifier(), existingExtensions);
        this.link(extPoint, null);
        this.recordChange(extPoint, existingExtensions, 2);
    }

    private void removeExtensionsAndExtensionPoints(Namespace element) {
        IExtension[] extensions = element.getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            this.removeExtension(extensions[i]);
        }
        IExtensionPoint[] extPoints = element.getExtensionPoints();
        for (int i = 0; i < extPoints.length; ++i) {
            this.removeExtensionPoint(extPoints[i]);
        }
    }

    private void removeFragmentFrom(String fragmentName, String masterName) {
        Set fragmentNames = (Set)this.allFragmentNames.get(masterName);
        if (fragmentNames == null) {
            return;
        }
        fragmentNames.remove(fragmentName);
        if (fragmentNames.isEmpty()) {
            this.allFragmentNames.remove(masterName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRegistryChangeListener(IRegistryChangeListener listener) {
        ListenerList listenerList = this.listeners;
        synchronized (listenerList) {
            this.listeners.remove(new ListenerInfo(listener, null));
        }
    }

    void setCacheReader(RegistryCacheReader value) {
        this.reader = value;
    }

    void setDirty(boolean value) {
        this.isDirty = value;
    }

    class ListenerInfo {
        String filter;
        IRegistryChangeListener listener;

        public ListenerInfo(IRegistryChangeListener listener, String filter) {
            this.listener = listener;
            this.filter = filter;
        }

        public boolean equals(Object another) {
            return another instanceof ListenerInfo && ((ListenerInfo)another).listener == this.listener;
        }
    }

    private static final class ExtensionEventDispatcherJob
    extends Job {
        private static final ISchedulingRule EXTENSION_EVENT_RULE = new ISchedulingRule(){

            public boolean contains(ISchedulingRule rule) {
                return rule == this;
            }

            public boolean isConflicting(ISchedulingRule rule) {
                return rule == this;
            }
        };
        private Map deltas;
        private Object[] listenerInfos;

        public ExtensionEventDispatcherJob(Object[] listenerInfos, Map deltas) {
            super("RegistryChangeEventDispatcherJob");
            this.listenerInfos = listenerInfos;
            this.deltas = deltas;
            this.setRule(EXTENSION_EVENT_RULE);
        }

        public IStatus run(IProgressMonitor monitor) {
            MultiStatus result = new MultiStatus("org.eclipse.core.runtime", 0, Policy.bind("plugin.eventListenerError"), null);
            for (int i = 0; i < this.listenerInfos.length; ++i) {
                ListenerInfo listenerInfo = (ListenerInfo)this.listenerInfos[i];
                if (listenerInfo.filter != null && !this.deltas.containsKey(listenerInfo.filter)) continue;
                try {
                    listenerInfo.listener.registryChanged(new RegistryChangeEvent(this.deltas, listenerInfo.filter));
                    continue;
                }
                catch (RuntimeException re) {
                    String message = re.getMessage() == null ? "" : re.getMessage();
                    result.add(new Status(4, "org.eclipse.core.runtime", 0, message, re));
                }
            }
            return result;
        }
    }
}

