/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaRefactorings;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringAnalyzeUtil;
import org.eclipse.jdt.internal.corext.refactoring.rename.TempDeclarationFinder;
import org.eclipse.jdt.internal.corext.refactoring.rename.TempOccurrenceAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.tagging.INameUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class RenameTempRefactoring
extends Refactoring
implements INameUpdating,
IReferenceUpdating {
    private final int fSelectionStart;
    private final int fSelectionLength;
    private final ICompilationUnit fCu;
    private boolean fUpdateReferences;
    private String fCurrentName;
    private String fNewName;
    private CompilationUnit fCompilationUnitNode;
    private VariableDeclaration fTempDeclarationNode;
    private TextChange fChange;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$CompilationUnit;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$MethodDeclaration;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$Initializer;

    private RenameTempRefactoring(ICompilationUnit cu, int selectionStart, int selectionLength) {
        Assert.isTrue(selectionStart >= 0);
        Assert.isTrue(selectionLength >= 0);
        Assert.isTrue(cu.exists());
        this.fUpdateReferences = true;
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = cu;
        this.fNewName = "";
    }

    public static boolean isAvailable(IJavaElement element) {
        return element != null && element.getElementType() == 14;
    }

    public static RenameTempRefactoring create(ICompilationUnit cu, int selectionStart, int selectionLength) {
        return new RenameTempRefactoring(cu, selectionStart, selectionLength);
    }

    public Object getNewElement() {
        return null;
    }

    public String getName() {
        return RefactoringCoreMessages.getString("RenameTempRefactoring.rename");
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public void setUpdateReferences(boolean updateReferences) {
        this.fUpdateReferences = updateReferences;
    }

    public void setNewElementName(String newName) {
        Assert.isNotNull(newName);
        this.fNewName = newName;
    }

    public String getNewElementName() {
        return this.fNewName;
    }

    public String getCurrentElementName() {
        return this.fCurrentName;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        this.initAST();
        if (this.fTempDeclarationNode == null || this.fTempDeclarationNode.resolveBinding() == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("RenameTempRefactoring.must_select_local"));
        }
        if (!Checks.isDeclaredIn(this.fTempDeclarationNode, class$org$eclipse$jdt$core$dom$MethodDeclaration == null ? (class$org$eclipse$jdt$core$dom$MethodDeclaration = RenameTempRefactoring.class$("org.eclipse.jdt.core.dom.MethodDeclaration")) : class$org$eclipse$jdt$core$dom$MethodDeclaration) && !Checks.isDeclaredIn(this.fTempDeclarationNode, class$org$eclipse$jdt$core$dom$Initializer == null ? (class$org$eclipse$jdt$core$dom$Initializer = RenameTempRefactoring.class$("org.eclipse.jdt.core.dom.Initializer")) : class$org$eclipse$jdt$core$dom$Initializer)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("RenameTempRefactoring.only_in_methods_and_initializers"));
        }
        this.initNames();
        return new RefactoringStatus();
    }

    private void initAST() {
        this.fCompilationUnitNode = new RefactoringASTParser(2).parse(this.fCu, true);
        this.fTempDeclarationNode = TempDeclarationFinder.findTempDeclaration(this.fCompilationUnitNode, this.fSelectionStart, this.fSelectionLength);
    }

    private void initNames() {
        this.fCurrentName = this.fTempDeclarationNode.getName().getIdentifier();
    }

    public RefactoringStatus checkNewElementName(String newName) throws JavaModelException {
        RefactoringStatus result = Checks.checkFieldName(newName);
        if (!Checks.startsWithLowerCase(newName)) {
            result.addWarning(RefactoringCoreMessages.getString("RenameTempRefactoring.lowercase"));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask("", 1);
            RefactoringStatus result = new RefactoringStatus();
            result.merge(Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.fCu}), this.getValidationContext()));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            result.merge(this.checkNewElementName(this.fNewName));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            result.merge(this.analyzeAST());
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private RefactoringStatus analyzeAST() throws CoreException {
        TextEdit declarationEdit = this.createRenameEdit(this.fTempDeclarationNode.getName().getStartPosition());
        TextEdit[] allRenameEdits = this.getAllRenameEdits(declarationEdit);
        this.fChange = new CompilationUnitChange(RefactoringCoreMessages.getString("RenameTempRefactoring.rename"), this.fCu);
        MultiTextEdit rootEdit = new MultiTextEdit();
        this.fChange.setEdit((TextEdit)rootEdit);
        this.fChange.setKeepPreviewEdits(true);
        String changeName = RefactoringCoreMessages.getFormattedString("RenameTempRefactoring.changeName", new String[]{this.fCurrentName, this.fNewName});
        for (int i = 0; i < allRenameEdits.length; ++i) {
            rootEdit.addChild(allRenameEdits[i]);
            this.fChange.addTextEditGroup(new TextEditGroup(changeName, allRenameEdits[i]));
        }
        String newCuSource = this.fChange.getPreviewContent((IProgressMonitor)new NullProgressMonitor());
        ASTParser p = ASTParser.newParser((int)2);
        p.setSource(newCuSource.toCharArray());
        p.setUnitName(this.fCu.getElementName());
        p.setProject(this.fCu.getJavaProject());
        p.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaElement)this.fCu));
        CompilationUnit newCUNode = (CompilationUnit)p.createAST(null);
        RefactoringStatus result = new RefactoringStatus();
        result.merge(this.analyzeCompileErrors(newCuSource, newCUNode));
        if (result.hasError()) {
            return result;
        }
        String fullKey = RefactoringAnalyzeUtil.getFullBindingKey(this.fTempDeclarationNode);
        ASTNode enclosing = this.getEnclosingBlockOrMethod(declarationEdit, this.fChange, newCUNode);
        SimpleName[] problemNodes = ProblemNodeFinder.getProblemNodes(enclosing, allRenameEdits, this.fChange, fullKey);
        result.merge(RefactoringAnalyzeUtil.reportProblemNodes(newCuSource, problemNodes));
        return result;
    }

    private TextEdit[] getAllRenameEdits(TextEdit declarationEdit) {
        if (!this.fUpdateReferences) {
            return new TextEdit[]{declarationEdit};
        }
        TempOccurrenceAnalyzer fTempAnalyzer = new TempOccurrenceAnalyzer(this.fTempDeclarationNode, true);
        fTempAnalyzer.perform();
        int[] referenceOffsets = fTempAnalyzer.getReferenceAndJavadocOffsets();
        TextEdit[] allRenameEdits = new TextEdit[referenceOffsets.length + 1];
        for (int i = 0; i < referenceOffsets.length; ++i) {
            allRenameEdits[i] = this.createRenameEdit(referenceOffsets[i]);
        }
        allRenameEdits[referenceOffsets.length] = declarationEdit;
        return allRenameEdits;
    }

    private TextEdit createRenameEdit(int offset) {
        return new ReplaceEdit(offset, this.fCurrentName.length(), this.fNewName);
    }

    private ASTNode getEnclosingBlockOrMethod(TextEdit declarationEdit, TextChange change, CompilationUnit newCUNode) {
        Block enclosing = RefactoringAnalyzeUtil.getBlock(declarationEdit, change, newCUNode);
        if (enclosing == null) {
            enclosing = RefactoringAnalyzeUtil.getMethodDeclaration(declarationEdit, change, newCUNode);
        }
        return enclosing;
    }

    private RefactoringStatus analyzeCompileErrors(String newCuSource, CompilationUnit newCUNode) {
        RefactoringStatus result = new RefactoringStatus();
        IProblem[] newProblems = RefactoringAnalyzeUtil.getIntroducedCompileProblems(newCUNode, this.fCompilationUnitNode);
        for (int i = 0; i < newProblems.length; ++i) {
            IProblem problem = newProblems[i];
            if (!problem.isError()) continue;
            result.addEntry(JavaRefactorings.createStatusEntry(problem, newCuSource));
        }
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        pm.done();
        return this.fChange;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ProblemNodeFinder {
        private ProblemNodeFinder() {
        }

        public static SimpleName[] getProblemNodes(ASTNode methodNode, TextEdit[] edits, TextChange change, String key) {
            NameNodeVisitor visitor = new NameNodeVisitor(edits, change, key);
            methodNode.accept((ASTVisitor)visitor);
            return visitor.getProblemNodes();
        }

        private static class NameNodeVisitor
        extends ASTVisitor {
            private Collection fRanges;
            private Collection fProblemNodes;
            private String fKey;

            public NameNodeVisitor(TextEdit[] edits, TextChange change, String key) {
                Assert.isNotNull(edits);
                Assert.isNotNull(key);
                this.fRanges = new HashSet<IRegion>(Arrays.asList(RefactoringAnalyzeUtil.getNewRanges(edits, change)));
                this.fProblemNodes = new ArrayList(0);
                this.fKey = key;
            }

            public SimpleName[] getProblemNodes() {
                return this.fProblemNodes.toArray(new SimpleName[this.fProblemNodes.size()]);
            }

            private static VariableDeclaration getVariableDeclaration(Name node) {
                IBinding binding = node.resolveBinding();
                if (binding == null && node.getParent() instanceof VariableDeclaration) {
                    return (VariableDeclaration)node.getParent();
                }
                if (binding != null && binding.getKind() == 3) {
                    CompilationUnit cu = (CompilationUnit)ASTNodes.getParent((ASTNode)node, class$org$eclipse$jdt$core$dom$CompilationUnit == null ? (class$org$eclipse$jdt$core$dom$CompilationUnit = RenameTempRefactoring.class$("org.eclipse.jdt.core.dom.CompilationUnit")) : class$org$eclipse$jdt$core$dom$CompilationUnit);
                    return ASTNodes.findVariableDeclaration((IVariableBinding)binding, (ASTNode)cu);
                }
                return null;
            }

            public boolean visit(SimpleName node) {
                VariableDeclaration decl = NameNodeVisitor.getVariableDeclaration((Name)node);
                if (decl == null) {
                    return super.visit(node);
                }
                boolean keysEqual = this.fKey.equals(RefactoringAnalyzeUtil.getFullBindingKey(decl));
                boolean rangeInSet = this.fRanges.contains(new Region(node.getStartPosition(), node.getLength()));
                if (keysEqual && !rangeInSet) {
                    this.fProblemNodes.add(node);
                }
                if (!keysEqual && rangeInSet) {
                    this.fProblemNodes.add(node);
                }
                return super.visit(node);
            }
        }
    }
}

