/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.templates;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginModelFactory;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.templates.PDETemplateSection;
import org.eclipse.pde.ui.IFieldData;
import org.eclipse.pde.ui.templates.TemplateOption;

public class PopupMenuTemplate
extends PDETemplateSection {
    public static final String KEY_TARGET_OBJECT = "objectClass";
    public static final String KEY_NAME_FILTER = "nameFilter";
    public static final String KEY_SUBMENU_LABEL = "subMenuLabel";
    public static final String KEY_ACTION_LABEL = "actionLabel";
    public static final String KEY_ACTION_CLASS = "actionClass";
    public static final String KEY_SELECTION = "selection";
    private static final String NL_TITLE = "PopupMenuTemplate.title";
    private static final String NL_DESC = "PopupMenuTemplate.desc";
    private static final String NL_TARGET_CLASS = "PopupMenuTemplate.targetClass";
    private static final String NL_NAME_FILTER = "PopupMenuTemplate.nameFilter";
    private static final String NL_SUBMENU_NAME = "PopupMenuTemplate.submenuName";
    private static final String NL_DEFAULT_SUBMENU_NAME = "PopupMenuTemplate.defaultSubmenuName";
    private static final String NL_ACTION_LABEL = "PopupMenuTemplate.actionLabel";
    private static final String NL_DEFAULT_ACTION_NAME = "PopupMenuTemplate.defaultActionName";
    private static final String NL_PACKAGE_NAME = "PopupMenuTemplate.packageName";
    private static final String NL_ACTION_CLASS = "PopupMenuTemplate.actionClass";
    private static final String NL_ENABLED_FOR = "PopupMenuTemplate.enabledFor";
    private static final String NL_SINGLE_SELECTION = "PopupMenuTemplate.singleSelection";
    private static final String NL_MULTIPLE_SELECTION = "PopupMenuTemplate.multipleSelection";

    public PopupMenuTemplate() {
        this.setPageCount(1);
        this.createOptions();
    }

    public void addPages(Wizard wizard) {
        WizardPage page = this.createPage(0, "org.eclipse.pde.doc.user.template_popup_menu");
        page.setTitle(PDEPlugin.getResourceString(NL_TITLE));
        page.setDescription(PDEPlugin.getResourceString(NL_DESC));
        wizard.addPage((IWizardPage)page);
        this.markPagesAdded();
    }

    private void createOptions() {
        this.addOption(KEY_TARGET_OBJECT, PDEPlugin.getResourceString(NL_TARGET_CLASS), "org.eclipse.core.resources.IFile", 0);
        this.addOption(KEY_NAME_FILTER, PDEPlugin.getResourceString(NL_NAME_FILTER), "plugin.xml", 0);
        this.addOption(KEY_SUBMENU_LABEL, PDEPlugin.getResourceString(NL_SUBMENU_NAME), PDEPlugin.getResourceString(NL_DEFAULT_SUBMENU_NAME), 0);
        this.addOption(KEY_ACTION_LABEL, PDEPlugin.getResourceString(NL_ACTION_LABEL), PDEPlugin.getResourceString(NL_DEFAULT_ACTION_NAME), 0);
        this.addOption("packageName", PDEPlugin.getResourceString(NL_PACKAGE_NAME), null, 0);
        this.addOption(KEY_ACTION_CLASS, PDEPlugin.getResourceString(NL_ACTION_CLASS), PDEPlugin.getResourceString("PopupMenuTemplate.newAction"), 0);
        this.addOption(KEY_SELECTION, PDEPlugin.getResourceString(NL_ENABLED_FOR), new String[][]{{"singleSelection", PDEPlugin.getResourceString(NL_SINGLE_SELECTION)}, {"multipleSelection", PDEPlugin.getResourceString(NL_MULTIPLE_SELECTION)}}, "singleSelection", 0);
    }

    public String getSectionId() {
        return "popupMenus";
    }

    public boolean isDependentOnParentWizard() {
        return true;
    }

    protected void initializeFields(IFieldData data) {
        String id = data.getId();
        this.initializeOption("packageName", id + ".popup.actions");
    }

    public void initializeFields(IPluginModelBase model) {
        String pluginId = model.getPluginBase().getId();
        this.initializeOption("packageName", pluginId + ".popup.actions");
    }

    public void validateOptions(TemplateOption source) {
        if (source.isRequired() && source.isEmpty()) {
            this.flagMissingRequiredOption(source);
        } else {
            this.validateContainerPage(source);
        }
    }

    private void validateContainerPage(TemplateOption source) {
        TemplateOption[] allPageOptions = this.getOptions(0);
        for (int i = 0; i < allPageOptions.length; ++i) {
            TemplateOption nextOption = allPageOptions[i];
            if (!nextOption.isRequired() || !nextOption.isEmpty()) continue;
            this.flagMissingRequiredOption(nextOption);
            return;
        }
        this.resetPageState();
    }

    protected void updateModel(IProgressMonitor monitor) throws CoreException {
        IPluginBase plugin = this.model.getPluginBase();
        IPluginExtension extension = this.createExtension(this.getUsedExtensionPoint(), true);
        IPluginModelFactory factory = this.model.getPluginFactory();
        IPluginElement objectContributionElement = factory.createElement((IPluginObject)extension);
        objectContributionElement.setName("objectContribution");
        objectContributionElement.setAttribute(KEY_TARGET_OBJECT, this.getStringOption(KEY_TARGET_OBJECT));
        objectContributionElement.setAttribute(KEY_NAME_FILTER, this.getStringOption(KEY_NAME_FILTER));
        objectContributionElement.setAttribute("id", this.model.getPluginBase().getId() + ".contribution1");
        IPluginElement menuElement = factory.createElement((IPluginObject)objectContributionElement);
        menuElement.setName("menu");
        menuElement.setAttribute("label", this.getStringOption(KEY_SUBMENU_LABEL));
        menuElement.setAttribute("path", "additions");
        menuElement.setAttribute("id", this.model.getPluginBase().getId() + ".menu1");
        IPluginElement separatorElement = factory.createElement((IPluginObject)menuElement);
        separatorElement.setName("separator");
        separatorElement.setAttribute("name", "group1");
        menuElement.add((IPluginObject)separatorElement);
        objectContributionElement.add((IPluginObject)menuElement);
        IPluginElement actionElement = factory.createElement((IPluginObject)objectContributionElement);
        actionElement.setName("action");
        actionElement.setAttribute("label", this.getStringOption(KEY_ACTION_LABEL));
        actionElement.setAttribute("class", this.getStringOption("packageName") + "." + this.getStringOption(KEY_ACTION_CLASS));
        actionElement.setAttribute("menubarPath", this.model.getPluginBase().getId() + ".menu1/group1");
        actionElement.setAttribute("enablesFor", this.getValue(KEY_SELECTION).toString().equals("singleSelection") ? "1" : "multiple");
        actionElement.setAttribute("id", this.model.getPluginBase().getId() + ".newAction");
        objectContributionElement.add((IPluginObject)actionElement);
        extension.add((IPluginObject)objectContributionElement);
        if (!extension.isInTheModel()) {
            plugin.add(extension);
        }
    }

    public String getUsedExtensionPoint() {
        return "org.eclipse.ui.popupMenus";
    }
}

