/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ui.internal.samples;

import java.util.HashSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.ui.internal.samples.SampleWizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ProjectNamesPage
extends WizardPage {
    private SampleWizard wizard;
    private Composite container;

    public ProjectNamesPage(SampleWizard wizard) {
        super("projects");
        this.wizard = wizard;
        this.setTitle(PDEPlugin.getResourceString("ProjectNamesPage.title"));
        this.setDescription(PDEPlugin.getResourceString("ProjectNamesPage.desc"));
    }

    public void setVisible(boolean visible) {
        this.setPageComplete(this.wizard.getSelection() != null);
        if (this.container != null) {
            this.updateEntries();
        }
        super.setVisible(visible);
    }

    private void updateEntries() {
        IConfigurationElement selection = this.wizard.getSelection();
        if (selection != null) {
            int i;
            this.setMessage(null);
            IConfigurationElement[] projects = selection.getChildren("project");
            Control[] children = this.container.getChildren();
            if (projects.length == 1 && children.length == 2) {
                Text text = (Text)children[1];
                text.setText(projects[0].getAttribute("name"));
                this.validateEntries();
                return;
            }
            for (i = 0; i < children.length; ++i) {
                children[i].dispose();
            }
            if (projects.length == 1) {
                this.createEntry(PDEPlugin.getResourceString("ProjectNamesPage.projectName"), projects[0].getAttribute("name"));
            } else {
                for (i = 0; i < projects.length; ++i) {
                    String label = "Project name #" + (i + 1) + ":";
                    this.createEntry(label, projects[i].getAttribute("name"));
                }
            }
            this.container.layout();
            this.validateEntries();
        } else {
            this.setMessage(PDEPlugin.getResourceString("ProjectNamesPage.noSampleFound"), 2);
        }
    }

    public String[] getProjectNames() {
        Control[] children = this.container.getChildren();
        String[] names = new String[children.length / 2];
        int index = 0;
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof Text)) continue;
            String name = ((Text)children[i]).getText();
            names[index++] = name;
        }
        return names;
    }

    private void createEntry(String labelName, String projectName) {
        Label label = new Label(this.container, 0);
        label.setText(labelName);
        label.setLayoutData((Object)new GridData(4));
        Text text = new Text(this.container, 2052);
        text.setText(projectName);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectNamesPage.this.validateEntries();
            }
        });
        text.setLayoutData((Object)new GridData(768));
    }

    private void validateEntries() {
        Control[] children = this.container.getChildren();
        boolean empty = false;
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof Text)) continue;
            String name = ((Text)children[i]).getText();
            if (name.length() == 0) {
                empty = true;
                break;
            }
            IStatus nameStatus = PDEPlugin.getWorkspace().validateName(name, 4);
            if (!nameStatus.isOK()) {
                this.setErrorMessage(nameStatus.getMessage());
                this.setPageComplete(false);
                return;
            }
            set.add(name);
        }
        if (empty) {
            this.setErrorMessage(PDEPlugin.getResourceString("ProjectNamesPage.emptyName"));
            this.setPageComplete(false);
        } else {
            int nfields = children.length / 2;
            int nnames = set.size();
            if (nfields > nnames) {
                this.setErrorMessage(PDEPlugin.getResourceString("ProjectNamesPage.duplicateNames"));
                this.setPageComplete(false);
            } else {
                this.setPageComplete(true);
                this.setErrorMessage(null);
            }
        }
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.container.setLayout((Layout)layout);
        this.setControl((Control)this.container);
        this.updateEntries();
    }
}

