/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.lang.reflect.Method;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanParameterInfo;
import mx4j.util.Utils;

public class MBeanOperationInfo
extends MBeanFeatureInfo {
    private static final long serialVersionUID = -6178860474881375330L;
    public static final int INFO = 0;
    public static final int ACTION = 1;
    public static final int ACTION_INFO = 2;
    public static final int UNKNOWN = 3;
    private MBeanParameterInfo[] signature;
    private String type;
    private int impact;

    public MBeanOperationInfo(String description, Method method) {
        super(method.getName(), description);
        Class<?>[] params = method.getParameterTypes();
        this.signature = new MBeanParameterInfo[params.length];
        int i = 0;
        while (i < params.length) {
            this.signature[i] = new MBeanParameterInfo("", params[i].getName(), "");
            ++i;
        }
        this.type = method.getReturnType().getName();
        this.impact = 3;
    }

    public MBeanOperationInfo(String name, String description, MBeanParameterInfo[] signature, String type, int impact) {
        super(name, description);
        this.signature = signature == null ? new MBeanParameterInfo[]{} : signature;
        this.type = type;
        this.impact = impact;
    }

    public String getReturnType() {
        return this.type;
    }

    public MBeanParameterInfo[] getSignature() {
        return this.signature;
    }

    public int getImpact() {
        return this.impact;
    }

    public int hashCode() {
        int hash = super.hashCode();
        String type = this.getReturnType();
        hash ^= type == null ? 0 : type.hashCode();
        return hash ^= Utils.arrayHashCode(this.getSignature());
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        try {
            MBeanOperationInfo other = (MBeanOperationInfo)obj;
            String type = this.getReturnType();
            String otherType = other.getReturnType();
            if (type != null && !type.equals(otherType)) {
                return false;
            }
            if (type == null && otherType != null) {
                return false;
            }
            return Utils.arrayEquals(this.getSignature(), other.getSignature());
        }
        catch (ClassCastException ignored) {
            return false;
        }
    }
}

