/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.console;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.ui.console.FileLink;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleHyperlink;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.externaltools.internal.model.StringMatcher;

public class BuildFailedTracker
implements IConsoleLineTracker {
    private IConsole fConsole;
    private StringMatcher fErrorMatcher;
    private StringMatcher fErrorMatcher2;
    private boolean fBuildFailed = false;

    public void init(IConsole console) {
        this.fConsole = console;
        this.fErrorMatcher = new StringMatcher("*BUILD FAILED: *.xml*", false, false);
        this.fErrorMatcher2 = new StringMatcher("*.xml*", false, false);
    }

    public void lineAppended(IRegion line) {
        block14: {
            try {
                int lineOffset = line.getOffset();
                int lineLength = line.getLength();
                String text = this.fConsole.getDocument().get(lineOffset, lineLength);
                String fileName = null;
                String lineNumber = "";
                int fileStart = -1;
                int index = -1;
                if (this.fErrorMatcher.match(text)) {
                    this.fBuildFailed = true;
                    index = text.indexOf("file:");
                    if (index > 0) {
                        fileStart = index + 5;
                    } else {
                        index = fileStart = text.indexOf("BUILD FAILED:") + 14;
                    }
                } else if (this.fBuildFailed && this.fErrorMatcher2.match(text)) {
                    index = 0;
                    fileStart = 0;
                }
                if (index > -1 && (index = text.indexOf("xml", index)) > 0) {
                    int numberStart = index + 4;
                    int numberEnd = text.indexOf(58, numberStart);
                    int fileEnd = index + 3;
                    if (numberStart > 0 && fileEnd > 0) {
                        fileName = text.substring(fileStart, fileEnd).trim();
                        if (numberEnd > 0) {
                            lineNumber = text.substring(numberStart, numberEnd).trim();
                        }
                    }
                }
                if (fileName == null) break block14;
                int num = -1;
                try {
                    num = Integer.parseInt(lineNumber);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(fileName));
                IFile file = null;
                if (files.length > 0) {
                    file = files[0];
                }
                if (file != null && file.exists()) {
                    FileLink link = new FileLink(file, null, -1, -1, num);
                    this.fConsole.addLink((IConsoleHyperlink)link, lineOffset + fileStart, lineLength - fileStart);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void dispose() {
        this.fConsole = null;
    }
}

