/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.siesta.client;

import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.Client;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.sonatype.sisu.siesta.client.internal.ClientInvocationHandler;

public class ClientBuilder {
    public static Target using(Client client) {
        return new Target(client);
    }

    public static class Target {
        private final Client client;

        public Target(Client client) {
            this.client = (Client)Preconditions.checkNotNull((Object)client);
        }

        public Factory toAccess(String url) {
            return new Factory(this.client, url);
        }

        public static class Factory {
            private final Client client;
            private final String url;

            public Factory(Client client, String url) {
                this.client = (Client)Preconditions.checkNotNull((Object)client);
                this.url = (String)Preconditions.checkNotNull((Object)url);
            }

            public <T> T build(Class<T> clientType) {
                return (T)Proxy.newProxyInstance(((Class)Preconditions.checkNotNull(clientType)).getClassLoader(), new Class[]{clientType}, (InvocationHandler)new ClientInvocationHandler(clientType, this.client, this.url));
            }
        }
    }
}

