/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.internal;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.sonatype.spice.zapper.Range;

public class RangeOutputStream
extends FilterOutputStream {
    private final Range range;
    private long allowedToWrite;
    private boolean allowedToClose;

    public RangeOutputStream(OutputStream wrappedStream, Range range, boolean allowedToClose) throws IOException {
        super(wrappedStream);
        if (range == null) {
            throw new NullPointerException("Range is null!");
        }
        this.range = range;
        this.allowedToWrite = range.getLength();
        this.allowedToClose = allowedToClose;
    }

    public Range getRange() {
        return this.range;
    }

    public void write(int b) throws IOException {
        if (this.allowedToWrite <= 0L) {
            return;
        }
        super.write(b);
        --this.allowedToWrite;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.allowedToWrite <= 0L) {
            return;
        }
        int lenToWrite = this.mathMin(len, this.allowedToWrite);
        super.write(b, off, lenToWrite);
        this.allowedToWrite -= (long)lenToWrite;
    }

    public void close() throws IOException {
        if (this.allowedToClose) {
            super.close();
        }
    }

    protected long getAllowedToWrite() {
        return this.allowedToWrite;
    }

    protected int mathMin(int a, long b) {
        if (b < Integer.MAX_VALUE) {
            return Math.min(a, (int)b);
        }
        return a;
    }
}

