/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.remove;

import java.io.File;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.remove.AbstractRemoveCommand;
import org.apache.maven.scm.command.remove.RemoveScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.gitexe.command.GitCommandLineUtils;
import org.apache.maven.scm.provider.git.gitexe.command.remove.GitRemoveConsumer;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class GitRemoveCommand
extends AbstractRemoveCommand
implements GitCommand {
    protected ScmResult executeRemoveCommand(ScmProviderRepository repo, ScmFileSet fileSet, String message) throws ScmException {
        CommandLineUtils.StringStreamConsumer stderr;
        GitRemoveConsumer consumer;
        GitScmProviderRepository repository = (GitScmProviderRepository)repo;
        if (fileSet.getFileList().isEmpty()) {
            throw new ScmException("You must provide at least one file/directory to remove");
        }
        Commandline cl = GitRemoveCommand.createCommandLine(fileSet.getBasedir(), fileSet.getFileList());
        int exitCode = GitCommandLineUtils.execute(cl, consumer = new GitRemoveConsumer(this.getLogger()), stderr = new CommandLineUtils.StringStreamConsumer(), this.getLogger());
        if (exitCode != 0) {
            return new RemoveScmResult(cl.toString(), "The git command failed.", stderr.getOutput(), false);
        }
        return new RemoveScmResult(cl.toString(), consumer.getRemovedFiles());
    }

    public static Commandline createCommandLine(File workingDirectory, List files) throws ScmException {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine(workingDirectory, "rm");
        GitCommandLineUtils.addTarget(cl, files);
        return cl;
    }
}

