/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.core.condition;

import java.util.regex.Pattern;
import org.sonatype.nexus.client.core.Condition;
import org.sonatype.nexus.client.core.NexusStatus;
import org.sonatype.nexus.client.internal.util.Check;

public abstract class EditionConditions {
    private static final Pattern ALL_EDITIONS = Pattern.compile(".*");
    private static final Pattern OSS_EDITION = Pattern.compile("OSS");
    private static final Pattern PRO_EDITION = Pattern.compile("^PRO.*$");
    private static final Pattern REGISTERED_PRO_EDITION = Pattern.compile("^PRO$");

    public static Condition anyEdition() {
        return new EditionCondition(ALL_EDITIONS);
    }

    public static Condition anyOssEdition() {
        return new EditionCondition(OSS_EDITION);
    }

    public static Condition anyProEdition() {
        return new EditionCondition(PRO_EDITION);
    }

    public static Condition anyRegisteredProEdition() {
        return new EditionCondition(REGISTERED_PRO_EDITION);
    }

    private static class EditionCondition
    implements Condition {
        private final Pattern editionPattern;

        private EditionCondition(Pattern editionPattern) {
            this.editionPattern = Check.notNull(editionPattern, Pattern.class);
        }

        @Override
        public boolean isSatisfiedBy(NexusStatus status) {
            String shortEdition = status.getEditionShort();
            return this.editionPattern.matcher(shortEdition).matches();
        }

        @Override
        public String explainNotSatisfied(NexusStatus status) {
            return String.format("(edition \"%s\" matches \"%s\")", status.getEditionShort(), this.editionPattern);
        }
    }
}

