/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.charger.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.sonatype.sisu.charger.CallableExecutor;
import org.sonatype.sisu.charger.ChargeStrategy;
import org.sonatype.sisu.charger.ExceptionHandler;
import org.sonatype.sisu.charger.internal.ChargeWrapper;
import org.sonatype.sisu.charger.internal.Check;

public class Charge<E> {
    private final List<ChargeWrapper<E>> ammunition;
    private final ChargeStrategy<E> strategy;
    private volatile boolean done;

    public Charge(ChargeStrategy<E> strategy) {
        this.strategy = Check.notNull(strategy, "Strategy is null!");
        this.ammunition = new ArrayList<ChargeWrapper<E>>();
    }

    public void addAmmo(Callable<? extends E> callable, ExceptionHandler exceptionHandler) {
        this.ammunition.add(new ChargeWrapper<E>(this, callable, exceptionHandler));
    }

    public List<ChargeWrapper<E>> getAmmoFutures() {
        return this.ammunition;
    }

    public synchronized void exec(CallableExecutor runner) {
        for (ChargeWrapper<E> ammo : this.ammunition) {
            ammo.setFuture(runner.submit(ammo));
        }
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone()) {
            return false;
        }
        for (ChargeWrapper<E> wrapper : this.ammunition) {
            wrapper.getFuture().cancel(mayInterruptIfRunning);
        }
        return true;
    }

    public boolean isDone() {
        return this.done;
    }

    public List<E> getResult() throws Exception {
        return this.strategy.getResult(this);
    }

    public synchronized void checkIsDone(ChargeWrapper<E> wrapper) {
        if (this.strategy.isDone(this, wrapper)) {
            this.done = true;
        }
    }
}

