/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.charger.internal;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.sonatype.sisu.charger.internal.AbstractChargeStrategy;
import org.sonatype.sisu.charger.internal.Charge;
import org.sonatype.sisu.charger.internal.ChargeWrapper;

public class FirstArrivedInOrderChargeStrategy<E>
extends AbstractChargeStrategy<E> {
    @Override
    public boolean isDone(Charge<E> charge, ChargeWrapper<E> wrapper) {
        List<ChargeWrapper<E>> ammoFutures = charge.getAmmoFutures();
        for (ChargeWrapper<E> a : ammoFutures) {
            Future<E> f = a.getFuture();
            if (f == null || !f.isDone()) continue;
            try {
                if (this.getFutureResult(a) == null) continue;
                return true;
            }
            catch (Exception e) {
                return true;
            }
        }
        return false;
    }

    @Override
    public List<E> getResult(Charge<E> charge) throws Exception {
        List<ChargeWrapper<E>> futures = charge.getAmmoFutures();
        for (ChargeWrapper<E> f : futures) {
            E e = this.getFutureResult(f);
            if (e == null) continue;
            return Collections.singletonList(e);
        }
        return Collections.emptyList();
    }
}

