/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.konan.diagnostics;

import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.konan.diagnostics.ErrorsNative;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J(\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001d2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/resolve/konan/diagnostics/NativeIdentifierChecker;", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "invalidChars", "", "", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkDeclaration", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "checkIdentifier", "simpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "checkNamed", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "reportIfNeeded", "name", "", "reportOn", "Lkotlin/Function0;", "Lcom/intellij/psi/PsiElement;", "frontend.native"})
public final class NativeIdentifierChecker
implements IdentifierChecker,
DeclarationChecker {
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final Set<Character> invalidChars;

    public NativeIdentifierChecker(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.languageVersionSettings = languageVersionSettings;
        Object[] objectArray = new Character[]{Character.valueOf('.'), Character.valueOf(';'), Character.valueOf(','), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('/'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf(':'), Character.valueOf('\\'), Character.valueOf('$'), Character.valueOf('&'), Character.valueOf('~'), Character.valueOf('*'), Character.valueOf('?'), Character.valueOf('#'), Character.valueOf('|'), Character.valueOf('\u00a7'), Character.valueOf('%'), Character.valueOf('@')};
        this.invalidChars = SetsKt.setOf((Object[])objectArray);
    }

    @Override
    public void checkIdentifier(@NotNull KtSimpleNameExpression simpleNameExpression, @NotNull DiagnosticSink diagnosticHolder) {
        Intrinsics.checkNotNullParameter((Object)simpleNameExpression, (String)"simpleNameExpression");
        Intrinsics.checkNotNullParameter((Object)diagnosticHolder, (String)"diagnosticHolder");
        this.reportIfNeeded(simpleNameExpression.getReferencedName(), (Function0<? extends PsiElement>)((Function0)new Function0<PsiElement>(simpleNameExpression){
            final /* synthetic */ KtSimpleNameExpression $simpleNameExpression;
            {
                this.$simpleNameExpression = $simpleNameExpression;
                super(0);
            }

            @Nullable
            public final PsiElement invoke() {
                return this.$simpleNameExpression.getIdentifier();
            }
        }), diagnosticHolder);
    }

    @Override
    public void checkDeclaration(@NotNull KtDeclaration declaration2, @NotNull DiagnosticSink diagnosticHolder) {
        ASTDelegatePsiElement it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)diagnosticHolder, (String)"diagnosticHolder");
        if (declaration2 instanceof KtDestructuringDeclaration) {
            List<KtDestructuringDeclarationEntry> list2 = ((KtDestructuringDeclaration)declaration2).getEntries();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"declaration.entries");
            $this$forEach$iv = list2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (KtDestructuringDeclarationEntry)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                this.checkNamed((KtNamedDeclaration)((Object)it), diagnosticHolder);
            }
        }
        if (declaration2 instanceof KtCallableDeclaration) {
            List<KtParameter> list3 = ((KtCallableDeclaration)declaration2).getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"declaration.valueParameters");
            $this$forEach$iv = list3;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (KtParameter)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                this.checkNamed((KtNamedDeclaration)((Object)it), diagnosticHolder);
            }
        }
        if (declaration2 instanceof KtTypeParameterListOwner) {
            List<KtTypeParameter> list4 = ((KtTypeParameterListOwner)declaration2).getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list4, (String)"declaration.typeParameters");
            $this$forEach$iv = list4;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (KtTypeParameter)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                this.checkNamed((KtNamedDeclaration)((Object)it), diagnosticHolder);
            }
        }
        if (declaration2 instanceof KtNamedDeclaration) {
            this.checkNamed((KtNamedDeclaration)declaration2, diagnosticHolder);
        }
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (declaration2 instanceof KtTypeAlias) {
            this.checkNamed((KtNamedDeclaration)declaration2, context2.getTrace());
        }
    }

    private final void checkNamed(KtNamedDeclaration declaration2, DiagnosticSink diagnosticHolder) {
        String string2 = declaration2.getName();
        if (string2 == null) {
            return;
        }
        String name = string2;
        this.reportIfNeeded(name, (Function0<? extends PsiElement>)((Function0)new Function0<PsiElement>(declaration2){
            final /* synthetic */ KtNamedDeclaration $declaration;
            {
                this.$declaration = $declaration;
                super(0);
            }

            @Nullable
            public final PsiElement invoke() {
                PsiElement psiElement = this.$declaration.getNameIdentifier();
                if (psiElement == null) {
                    psiElement = this.$declaration;
                }
                return psiElement;
            }
        }), diagnosticHolder);
    }

    private final void reportIfNeeded(String name, Function0<? extends PsiElement> reportOn, DiagnosticSink diagnosticHolder) {
        String string2 = KtPsiUtil.unquoteIdentifier(name);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"unquoteIdentifier(name)");
        String text2 = string2;
        if (((CharSequence)text2).length() == 0) {
            PsiElement psiElement = (PsiElement)reportOn.invoke();
            if (psiElement == null) {
                return;
            }
            diagnosticHolder.report(ErrorsNative.INVALID_CHARACTERS_NATIVE.on(this.languageVersionSettings, psiElement, "should not be empty"));
        } else {
            boolean bl;
            block6: {
                CharSequence $this$any$iv = text2;
                boolean $i$f$any = false;
                for (int i = 0; i < $this$any$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$any$iv.charAt(i);
                    boolean bl2 = false;
                    if (!this.invalidChars.contains(Character.valueOf(it))) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
            if (bl) {
                PsiElement psiElement = (PsiElement)reportOn.invoke();
                if (psiElement == null) {
                    return;
                }
                diagnosticHolder.report(ErrorsNative.INVALID_CHARACTERS_NATIVE.on(this.languageVersionSettings, psiElement, "contains illegal characters: " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.intersect((Iterable)this.invalidChars, (Iterable)StringsKt.toSet((CharSequence)text2)), (CharSequence)"", (CharSequence)"\"", (CharSequence)"\"", (int)0, null, null, (int)56, null)));
            }
        }
    }
}

