/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.UseLatestVersionsMojoBase;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.api.recording.ChangeRecord;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.ordering.InvalidSegmentException;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.mojo.versions.utils.SegmentUtils;

@Mojo(name="use-latest-snapshots", threadSafe=true)
public class UseLatestSnapshotsMojo
extends UseLatestVersionsMojoBase {
    @Parameter(property="allowMajorUpdates", defaultValue="false")
    protected boolean allowMajorUpdates;
    @Parameter(property="allowMinorUpdates", defaultValue="false")
    protected boolean allowMinorUpdates;
    @Parameter(property="allowIncrementalUpdates", defaultValue="true")
    protected boolean allowIncrementalUpdates;

    @Inject
    public UseLatestSnapshotsMojo(RepositorySystem repositorySystem, org.eclipse.aether.RepositorySystem aetherRepositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) {
        super(repositorySystem, aetherRepositorySystem, wagonMap, changeRecorders);
    }

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException, VersionRetrievalException {
        try {
            DependencyManagement dependencyManagement;
            if (this.isProcessingDependencyManagement() && (dependencyManagement = PomHelper.getRawModel((MavenProject)this.getProject()).getDependencyManagement()) != null) {
                this.useLatestSnapshots(pom, dependencyManagement.getDependencies(), ChangeRecord.ChangeKind.DEPENDENCY_MANAGEMENT);
            }
            if (this.getProject().getDependencies() != null && this.isProcessingDependencies()) {
                this.useLatestSnapshots(pom, this.getProject().getDependencies(), ChangeRecord.ChangeKind.DEPENDENCY);
            }
            if (this.getProject().getParent() != null && this.isProcessingParent()) {
                this.useLatestSnapshots(pom, Collections.singletonList(this.getParentDependency()), ChangeRecord.ChangeKind.PARENT);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void useLatestSnapshots(ModifiedPomXMLEventReader pom, Collection<Dependency> dependencies, ChangeRecord.ChangeKind changeKind) throws XMLStreamException, MojoExecutionException, VersionRetrievalException {
        Optional unchangedSegment = SegmentUtils.determineUnchangedSegment((boolean)this.allowMajorUpdates, (boolean)this.allowMinorUpdates, (boolean)this.allowIncrementalUpdates, (Log)this.getLog());
        this.useLatestVersions(pom, dependencies, (dep, versions) -> {
            try {
                return Arrays.stream(versions.getNewerVersions(dep.getVersion(), unchangedSegment, true, false)).filter(v -> SNAPSHOT_REGEX.matcher(v.toString()).matches()).max(Comparator.naturalOrder());
            }
            catch (InvalidSegmentException e) {
                this.getLog().info((CharSequence)("Ignoring " + this.toString((Dependency)dep) + " as the version number is too short"));
                return Optional.empty();
            }
        }, changeKind, dep -> !SNAPSHOT_REGEX.matcher(dep.getVersion()).matches());
    }
}

