/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.proxy.common;

import io.mockk.proxy.MockKInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u0001:\u0002\r\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J2\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0010\u0010\n\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u000bH\u0096\u0002\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/mockk/proxy/common/ProxyInvocationHandler;", "Ljava/lang/reflect/InvocationHandler;", "handler", "Lio/mockk/proxy/MockKInvocationHandler;", "(Lio/mockk/proxy/MockKInvocationHandler;)V", "invoke", "", "proxy", "method", "Ljava/lang/reflect/Method;", "args", "", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", "CallProxySuper", "Companion", "mockk-agent-common"})
public final class ProxyInvocationHandler
implements InvocationHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MockKInvocationHandler handler;
    @NotNull
    private static final String equalsMethodName;
    @NotNull
    private static final String hashCodeMethodName;

    public ProxyInvocationHandler(@NotNull MockKInvocationHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.handler = handler;
    }

    @Override
    @Nullable
    public Object invoke(@NotNull Object proxy2, @NotNull Method method, @Nullable Object[] args) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)proxy2, (String)"proxy");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (ProxyInvocationHandler.Companion.isEqualsMethod(method)) {
            object = proxy2 == (args == null ? null : args[0]);
        } else if (ProxyInvocationHandler.Companion.isHashCodeMethod(method)) {
            object = System.identityHashCode(proxy2);
        } else {
            Object[] objectArray = args;
            if (args == null) {
                objectArray = new Object[]{};
            }
            Callable callable = new CallProxySuper(proxy2, method, objectArray);
            Object[] objectArray2 = args;
            if (args == null) {
                objectArray2 = new Object[]{};
            }
            object = this.handler.invocation(proxy2, method, callable, objectArray2);
        }
        return object;
    }

    static {
        String string = "equals".intern();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).intern()");
        equalsMethodName = string;
        string = "hashCode".intern();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).intern()");
        hashCodeMethodName = string;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\n\u001a\n \u000b*\u0004\u0018\u00010\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u0018\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/mockk/proxy/common/ProxyInvocationHandler$CallProxySuper;", "Ljava/util/concurrent/Callable;", "", "proxy", "method", "Ljava/lang/reflect/Method;", "args", "", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)V", "[Ljava/lang/Object;", "call", "kotlin.jvm.PlatformType", "superMethodName", "", "mockk-agent-common"})
    private static final class CallProxySuper
    implements Callable<Object> {
        @NotNull
        private final Object proxy;
        @NotNull
        private final Method method;
        @NotNull
        private final Object[] args;

        public CallProxySuper(@NotNull Object proxy2, @NotNull Method method, @NotNull Object[] args) {
            Intrinsics.checkNotNullParameter((Object)proxy2, (String)"proxy");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.proxy = proxy2;
            this.method = method;
            this.args = args;
        }

        private final String superMethodName(Method method) {
            StringBuilder stringBuilder = new StringBuilder().append("super$").append((Object)method.getName()).append('$');
            String string = method.getReturnType().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method.returnType.name");
            return stringBuilder.append(StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string, (char)'.', (char)'_', (boolean)false, (int)4, null), (char)'[', (char)'_', (boolean)false, (int)4, null), (char)';', (char)'_', (boolean)false, (int)4, null)).toString();
        }

        @Override
        public Object call() {
            Object object;
            try {
                object = this.method.getParameterTypes();
                Method method = this.proxy.getClass().getMethod(this.superMethodName(this.method), Arrays.copyOf(object, ((Class<?>[])object).length));
                object = this.args;
                object = method.invoke(this.proxy, Arrays.copyOf(object, ((Object[])object).length));
            }
            catch (InvocationTargetException e) {
                Throwable throwable = e.getCause();
                Intrinsics.checkNotNull((Object)throwable);
                Throwable throwable2 = throwable;
                Intrinsics.checkNotNullExpressionValue((Object)throwable2, (String)"e.cause!!");
                throw throwable2;
            }
            return object;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/mockk/proxy/common/ProxyInvocationHandler$Companion;", "", "()V", "equalsMethodName", "", "hashCodeMethodName", "isEqualsMethod", "", "method", "Ljava/lang/reflect/Method;", "isHashCodeMethod", "mockk-agent-common"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isEqualsMethod(Method method) {
            return method.getName() != equalsMethodName ? false : (method.getParameterTypes().length != 1 ? false : Intrinsics.areEqual(method.getParameterTypes()[0], Object.class));
        }

        private final boolean isHashCodeMethod(Method method) {
            boolean bl;
            if (method.getName() != hashCodeMethodName) {
                bl = false;
            } else {
                Class<?>[] classArray = method.getParameterTypes();
                Intrinsics.checkNotNullExpressionValue(classArray, (String)"method.parameterTypes");
                bl = ((Object[])classArray).length == 0;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

