# $FreeBSD: cfg_local.pm,v 1.37 2011/07/31 18:29:13 peter Exp $

####################################################################
####################################################################
# This file contains local configuration for the CVSROOT perl
# scripts.  It is loaded by cfg.pm and overrides the default
# configuration in that file.
#
# It is advised that you test it with
#     'env CVSROOT=/path/to/cvsroot perl -cw cfg.pm'
# before you commit any changes.  The check is to cfg.pm which
# loads this file.
####################################################################
####################################################################

$TZ = 'Etc/UTC';
$CHECK_HEADERS = 1;
$IDHEADER = 'FreeBSD';
$UNEXPAND_RCSID = 1;
$USE_AWAKE = "/usr/local/bin/awake";
$COMMITTER = $ENV{"CVS_AUTHOR"} || $ENV{"LOGNAME"} || $ENV{'USER'}
	|| getlogin || (getpwuid($<))[0] || sprintf("uid#%d",$<);


%TEMPLATE_HEADERS = (
	"Reviewed by"		=> '.*',
	"Submitted by"		=> '.*',
	"Obtained from"		=> '.*',
	"Approved by"		=> '.*',
	"PR"			=> '.*',
	"MFC after"		=> '.*',
	"Security"		=> '.*'
);
#	"MFC after"		=> '\d+(\s+(days?|weeks?|months?))?',

$MAILCMD = "/usr/local/bin/mailsend -H";
$MAIL_BRANCH_HDR  = "X-FreeBSD-CVS-Branch";
$ADD_TO_LINE = 0;
$MAILBANNER = "FreeBSD src repository";
if (defined $ENV{'CVS_COMMIT_ATTRIB'}) {
  my $attrib = $ENV{'CVS_COMMIT_ATTRIB'};
  $MAILBANNER .= " ($attrib committer)";
}

# Sanity check to make sure we've been run through the wrapper and are
# now primary group 'ncvs'.
#
#$COMMITCHECK_EXTRA = sub {
#	my $GRP=`/usr/bin/id -gn`;
#	chomp $GRP;
#	unless ( $GRP =~ /^ncvs$/ ) {
#		print "You do not have group ncvs (commitcheck)!\n";
#		exit 1;	# We could return false here.  But there's
#			# nothing to stop us taking action here instead.
#	}
#	return 1;
#};

# Wrap this in a hostname check to prevent mail to the FreeBSD
# list if someone borrows this file and forgets to change it.
my $hostname = `/bin/hostname`;
die "Can't determine hostname!\n" if $? >> 8;
chomp $hostname;
@COMMIT_HOSTS = qw(repoman.freebsd.org);
if ($hostname =~ /^repoman\.freebsd\.org$/i) {
#	$MAILADDRS='src-committers@FreeBSD.org cvs-src@FreeBSD.org cvs-all@FreeBSD.org';
#	$MAILADDRS = 'cvs@FreeBSD.org' if $DEBUG;
	$MAILADDRS = 'devnull@freebsd.org';
#	$MAILADDRS = 'cvs-src-old@freebsd.org';
}


@LOG_FILE_MAP = (
	'CVSROOT'	=> '^CVSROOT/',
	'distrib'	=> '^distrib/',

	'bin'		=> '^src/bin/',
	'contrib'	=> '^src/contrib/',
	'crypto'	=> '^src/crypto/',
	'eBones'	=> '^src/eBones/',
	'etc'		=> '^src/etc/',
	'games'		=> '^src/games/',
	'gnu'		=> '^src/gnu/',
	'include'	=> '^src/include/',
	'kerberos5'	=> '^src/kerberos5/',
	'kerberosIV'	=> '^src/kerberosIV/',
	'lib'		=> '^src/lib/',
	'libexec'	=> '^src/libexec/',
	'lkm'		=> '^src/lkm/',
	'release'	=> '^src/release/',
	'sbin'		=> '^src/sbin/',
	'secure'	=> '^src/secure/',
	'share'		=> '^src/share/',
	'sys'		=> '^src/sys/',
	'tools'		=> '^src/tools/',
	'usrbin'	=> '^src/usr\.bin/',
	'usrsbin'	=> '^src/usr\.sbin/',
	'user'		=> '^src/',

	'other'		=> '.*'
);

1; # Perl requires all modules to return true.  Don't delete!!!!
#end
