package String::Normal::Config::BusinessStem;
use strict;
use warnings;

use String::Normal::Config;

sub _data {
    my %params = @_;

    my $fh;
    if ($params{business_stem}) {
        open $fh, $params{business_stem} or die "Can't read '$params{business_stem}' $!\n";
    } else {
        $fh = *DATA;
    }

    my %stem = String::Normal::Config::_slurp( $fh );
    return \%stem;
}

1;

=head1 NAME

String::Normal::Config::BusinessStem;

=head1 DESCRIPTION

This package defines substitutions to be performed on Business types.

=head1 STRUCTURE

One entry pair per line: first the value to be matched then the value
to be changed to. For example:

  foo fu

Would change all occurances of C<foo> to C<fu>. See C<__DATA__> block below.

You can provide your own data by creating a text file containing your
values and provide the path to that file via the constructor:

  my $normalizer = String::Normal->new( business_stem => '/path/to/values.txt' );

=head1 AUTHOR

Jeff Anderson, C<< <jeffa at cpan.org> >>

=head1 LICENSE AND COPYRIGHT

Copyright 2024 Jeff Anderson.

This program is free software; you can redistribute it and/or modify it
under the terms of the the Artistic License (2.0). You may obtain a
copy of the full license at:

L<http://www.perlfoundation.org/artistic_license_2_0>

Any use, modification, and distribution of the Standard or Modified
Versions is governed by this Artistic License. By using, modifying or
distributing the Package, you accept this license. Do not use, modify,
or distribute the Package, if you do not accept this license.

If your Modified Version has been derived from a Modified Version made
by someone other than you, you are nevertheless required to ensure that
your Modified Version complies with the requirements of this license.

This license does not grant you the right to use any trademark, service
mark, tradename, or logo of the Copyright Holder.

This license includes the non-exclusive, worldwide, free-of-charge
patent license to make, have made, use, offer to sell, sell, import and
otherwise transfer the Package with respect to any patent claims
licensable by the Copyright Holder that are necessarily infringed by the
Package. If you institute patent litigation (including a cross-claim or
counterclaim) against any party alleging that the Package constitutes
direct or contributory patent infringement, then this Artistic License
to you shall terminate on the date that such litigation is filed.

Disclaimer of Warranty: THE PACKAGE IS PROVIDED BY THE COPYRIGHT HOLDER
AND CONTRIBUTORS "AS IS' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.
THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE, OR NON-INFRINGEMENT ARE DISCLAIMED TO THE EXTENT PERMITTED BY
YOUR LOCAL LAW. UNLESS REQUIRED BY LAW, NO COPYRIGHT HOLDER OR
CONTRIBUTOR WILL BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, OR
CONSEQUENTIAL DAMAGES ARISING IN ANY WAY OUT OF THE USE OF THE PACKAGE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=cut

__DATA__
# no
@ at
academy acad
academies acad
accent acet
accents acet
accessory acces
accessories acces
account acct
accounts acct
accountant acctnt
accountants acctnt
accounting acctg
administration admin
administrations admin
admiral adm
admirals adm
advertise adv
advertising advg
agency agci
agencies agci
alley aly
alleys aly
american amer
americans amer
amount amt
amounts amt
amusement amuse
amusements amuse
antique antq
antiques antq
apartment apt
apartments apt
appliance appl
appliances appl
aquarium aqm
arcade arcd
arcades arcd
architect archt
architects archt
assistant asst
assistants asst
associate assoc
associates assoc
association assn
associations assn
attny atty
attorney atty
attorneys atty
auction auctn
auctions auctn
auctioneer auctnr
auctioneers auctnr
authority auth
authorities auth
authorized authzd
automatic automtc
automobile auto
automobiles auto
automotive automtv
automotives automtv
baptist bapt
baptists bapt
beach bch
beaches bch
bluff blf
bluffs blf
bookkeeping bkpg
boutique btq
boutiques btq
branch br
branches br
brother bro
brothers bro
building bldg
buildings bldg
bureau bur
bureaus bur
burg bg
burgs bg
business bus
businesses bus
cabinet cabnt
cabinets cabnt
cadillac cad
cadillacs cad
caffe cafe
caffes cafe
camera cam
cameras cam
canyon cyn
canyons cyn
cape cpe
capes cpe
center ctr
centers ctr
ceramic crmc
cermc crmc
certified cert
chemical chem
chemicals chem
chevrolet chev
children child
childrn child
chiropractic chiro
church chr
churches chr
cliff clf
cliffs clf
college clg
colleges clg
commercial coml
commercials coml
commission commn
commissions commn
communication comm
communications comm
community cmnty
company co
companies co
compressor comprsr
compressors comprsr
condition cond
conditions cond
condominium condo
condominiums condo
congregation congrgtn
congregations congrgtn
consolidated cons
construction constr
constructions constr
consultant conslnt
consultants conslnt
consulting consltng
consultings consltng
container contnr
containers contnr
continental contl
continentals contl
continued contd
contracting contrng
contractings contrng
contractor contr
contractors contr
conversion convrsn
conversions convrsn
cooperative coop
cooperatives coop
corner cor
corners cor
corporation corp
corporations corp
course crse
courses crse
court ct
courts ct
custom cstm
customs cstm
delicatessen deli
delicatessens deli
dep dept
department dept
departments dept
departmnt dept
developer devlpr
developers devlpr
development devmnt
developments devmnt
discount disc
discounts disc
dismantler dismtlr
dismantlers dismtlr
dispensary dispense
dispensaries dispense
disposal dispose
disposals dispose
distributor distr
distributors distr
district dist
districts dist
division div
divisions div
do dr
doctor dr
doctors dr
doughnut donut
doughnuts donut
drgst drug
drive dr
druggist drug
east e
electric elctrc
electrics elctrc
electrical elecl
electronics elctro
employee empl
employees empl
emporium empr
emporiums empr
engine eng
engines eng
engineer engr
engineers engr
engraving engrv
engravings engrv
ent entrprs
enterprise entrprs
enterprises entrprs
entertainment entrtn
entertainments entrtn
entrmt entrtn
equip eqpt
equipment eqpt
estate est
estates est
excavating excavtg
exchange exch
exchanges exch
express exp
fabrication fab
fabrications fab
fall fl
falls fl
fdrl fed
federal fed
fedl fed
fedrl fed
ferry fry
fertilizer fert
fertilizers fert
financial fncl
fitness fitns
forwarder frwrdrs
forwarders frwrdrs
freight frt
frtlzr fert
furnishings furnsng
furniture furn
garage grge
garages grge
garden gdn
gardens gdn
general gen
generals gen
generator genrtr
generators genrtr
genl gen
gentlemen gent
grain grn
grains grn
grocery groc
groceries groc
ground grnd
grounds grnd
handicapped hndcpd
harbor hbr
harbors hbr
hardware hdwr
hardwares hdwr
hdq hq
hdqrs hq
hdqs hq
headquarter hq
headquarters hq
heating htg
heavy hvy
heavies hvy
heights ht
highland hgld
highlands hgld
hill hl
hills hl
home hm
homes hm
hospital hosp
hospitals hosp
house hse
housees hse
hqts hq
hudson hdsn
ii 2
iii 3
implement impl
impress imprsn
impression imprsn
impressions imprsn
improvement imprvmt
improvements imprvmt
incorporated inc
industrial indl
industry ind
industries ind
information info
installation instltn
installations instltn
institute inst
institutes inst
institution instn
institutional instnl
institutions instn
instrument instr
instruments instr
insurance ins
insurances ins
intercontinental intercontl
international intl
interstate i
interstates i
irrigation irrgtn
isl is
island is
islands is
iv 4
ix 9
junction jct
junctions jct
kennel knnl
kennels knnl
knoll knl
knolls knl
laboratory lab
laboratories lab
landscaping landscpg
lawnmower lawnmwr
lawnmowers lawnmwr
limited ltd
lithograph lithogph
lithographs lithogph
lithographer lithogphr
lithographers lithogphr
lithographing lithogphng
lrtng letter
lubricant lubcnt
lubricants lubcnt
lubrication lub
lubrications lub
lumber lbr
lutheran luth
lutherans luth
machine mach
machines mach
machinery machry
machineries machry
maintenance mntnc
maintenances mntnc
management mgmt
managements mgmt
manager mgr
managers mgr
manufactured mfd
manufacturer mfr
manufacturers mfr
manufacturing mfg
marine mrne
market mkt
markets mkt
marketing mktg
masonry mason
md dr
mechanic mech
mechanical mechcl
medical medcl
memorial meml
memorials meml
mercantile merctl
mercantiles merctl
merchandise mdse
mercury merc
methodist mthdst
mill ml
mills ml
millwork millwk
mission msn
missions msn
mortgage mtg
mortgages mtg
mount mt
mounts mt
mountain mt
mountains mt
mtn mt
muni mun
municipal mncpl
municipals mncpl
museum mus
museums mus
mutual mutl
national natl
nationals natl
natural natrl
naturals natrl
north n
northeast ne
northwest nw
number no
numbers no
nursery nrsy
nurseries nrsy
nursing nurse
nutrition nutri
office ofc
offices ofc
oldsmobile olds
optical optl
optician opt
opticians opt
organization org
organizations org
orthopedic ortho
package pkg
packages pkg
packaging pkgng
packagings pkgng
partner prtnr
partners prtnr
pathology path
petroleum petro
pharmacy pharm
pharmacies pharm
phd dr
phrmcy pharm
physician phy
physicians phy
pickup pkup
plain pln
plains pln
plumbing plbg
printer print
printers print
printing ptg
private pvt
processing procng
processor proc
processors proc
product prod
products prod
professional pro
professionals pro
protection protctn
psychiatric psych
public pubc
publication publ
publications publ
publisher pubh
publishers pubh
publishing pubg
radiator radtr
radiators radtr
reconditioning recond
recreation rec
refining refng
refrigeration refrign
refrigerator refrig
refrigerators refrig
regional regl
rehabilitation rehab
remodeling remod
removal remvl
rental rent
rentals rent
resort resrt
resorts resrt
restaurant rstrnt
restaurants rstrnt
retirement retire
rmdlg remod
rnt rent
rntl rent
rubber rbr
rubbers rbr
rubbish rbsh
saint st
saints st
san sn
sanitation sani
science sci
sciences sci
sec second
secretarial sectrl
securities sec
service svc
servicenter svctr
services svc
sharpening sharp
shoal shl
shoals shl
shopping shpg
shore shr
shores shr
showroom showrm
showrooms showrm
small sm
south s
southeast se
southwest sw
specialist speclst
specialists speclst
specialties spec
specialty spec
spring spg
springs spg
standard std
standards std
station sta
stations sta
stationery statnry
storage stge
storages stge
supercenter suprctr
supercenters suprctr
supermarket sprmkt
supermarkets sprmkt
supl suply
supplement suplmt
supplements suplmt
supplier suplr
supplies supl
suppliers suplr
supply supl
supplys supl
surgery surg
surgical surgcl
sweeping swpg
system syst
systems syst
technology tech
telephone phone
telephones phone
television tv
televisions tv
townhouse twnhse
townhouses twnhse
township twp
townships twp
transcontinental transcontl
transmission trans
transmissions trans
transportation trnsprtn
transportations trnsprtn
trophy troph
trophies troph
tropical trop
tropicals trop
tunnel tunl
tunnels tunl
tuxedo tux
tuxedoes tux
universal univrsl
universities univ
university univ
unlimited unltd
vacation vac
vacations vac
valley vly
valleys vly
veterinarian vet
veterinarians vet
veterinary vetry
veterinaries vetry
vii 7
viii 8
village vlg
villages vlg
volkswagen vw
wallpaper wlpaper
warehouse wrhse
warehouses wrhse
wedding wedd
weddings wedd
west w
wharf whf
wharves whf
wholesale whls
wholesaler whlsr
wholesalers whlsr
woodworking woodwkg
wrecking wrckg
yard yd
yards yd
centre ctr
centres ctr
county cnty
counties cnty
ser svc
doc dr
facility fclty
facilities fclty
aree aree
ane ane
ans ans
ase ase
ases ases
bes bes
das das
group grp
groups grp
ifs ifs
ife ife
ifes ifes
ins ins
ore ore
thesing thesing
aircond ac
aircondition ac
airconditioning ac
acpnctr acupunctur
advncd advanc
altrtn alter
altrtns alter
anml anim
apprsl apprais
airport arprt
airports arprt
assmbls assembli
assmbly assembli
assault asslt
attrctn attract
attrctns attract
attys atty
bptst bapt
barbeque bbq
barbeques bbq
barbque bbq
barbcue bbq
barbq bbq
barbques bbq
bbque bbq
builder bldr
builders bldr
bank bnk
banks bnk
basket bskt
baskets bskt
crdlgy cardiologi
ctrng cater
chldrn child
childcare chldcr
chamber chmbr
chambers chmbr
chmbrs chmbr
chapel chpl
chapels chpl
chpls chpl
clng clean
clnng clean
clinic clnc
clinics clnc
clncs clnc
clthng cloth
comnty cmnty
campground cmpgrnd
campgrounds cmpgrnd
concept cncpt
concepts cncpt
counselor cnslr
counselors cnslr
control cntrl
cllctbl collect
cllctbls collect
collectbl collect
collectbls collect
cmmrc commerc
cmmrce commerc
cmrc commerc
commrc commerc
commrce commerc
cmmsnr commissioner
cmmsnrs commissioner
cmmssnr commissioner
cmmssnrs commissioner
cnsgnmnt consign
cnstrctn constr
cntmprry contemporari
crrctn correct
crrctns correct
csmtc cosmet
csmtcs cosmet
csmtlgy cosmetologi
cntry countri
cardiovascular crdvsclr
crmnl crimin
carwash crwsh
citizen ctzn
citizens ctzn
clnry culinari
cstdy custodi
dfns defens
dlvrnc deliver
dntsry dentistri
drmtlgy dermatologi
dgnstc diagnost
dgnstcs diagnost
discjockey dj
dental dntl
driveinn drivein
drycleaner dryclean
drycleaners dryclean
drycleaning dryclean
dryclnr dryclean
dryclnrs dryclean
design dsgn
designs dsgn
downtown dwntwn
electrcl elecl
elctrlyss electrolysi
elem elementari
elemntry elementari
elmntry elementari
emrgncy emerg
emplymnt employ
enfrcmnt enforc
entrtnmnt entrtn
envrnmntl environment
evdnc evid
evidnce evid
excptnl except
exchng exch
xchange exch
xpress exp
xpert expert
xperts expert
extnsn extens
extnsns extens
xtra extra
xtreme extrem
fctry factori
fmly famili
fclts fclty
ftnss fitns
fellowship fllwshp
florist flrst
florists flrst
fndtn foundat
frnrl funer
gllry galleri
gstrntrlgy gastroenterologi
grdn gdn
grdns gdn
gifts gfts
glass glss
govnmt govern
govnmts govern
govt govern
govts govern
gvrnmnt govern
gvrnmnts govern
grmng groom
gynclgy gynecologi
gyneclgy gynecologi
gynecology gynecologi
hmtlgy hematologi
health hlth
hme hm
hmes hm
handyman hndymn
imgng imag
indp independ
indpndnt independ
infrtlty infertil
inspctn inspect
inspctns inspect
intrvtn intervent
intrvtns intervent
interior intrr
interiors intrr
invstmnt invest
invstmnts invest
invstgtn investig
invstgtns investig
invstgtr investig
invstgtrs investig
jwlry jewelri
jujitsu jiujitsu
junior jr
juniors jr
kindergarten kndrgrtn
lndry laundri
lcksmths lcksmth
locksmith lcksmth
locksmiths lcksmth
lrnng learn
limousine limo
limousines limo
lvg live
lvng live
laundromat lndrmt
laundromats lndrmt
lawyer lwyr
lawyers lwyr
mtrnty matern
mdcn medicin
mntl mental
mntlly mental
mrchndsng merchand
mktng mktg
maxillofacial mxllfcl
mxlfcl mxllfcl
ntl natl
ntnl natl
nphrlgy nephrologi
nrsrgry neurosurgeri
nrsry nrsy
nrsng nurse
obgyne obgyn
onclgy oncologi
opthlmlgy ophthalmologi
optometrist optmtrst
optometrists optmtrst
orgnztn org
orgnztns org
orthpdc ortho
orthpdcs ortho
orthdntc orthodont
orthdntcs orthodont
owner ownr
owners ownr
prkng park
pediatric pdtrc
pediatrics pdtrc
prfrmng perform
prmnnt perman
phtgrphy photographi
physcn phy
physcns phy
plnnng plan
plmbng plbg
plumber plmbr
plumbers plmbr
plastic plstc
prcses prcss
prcsss prcss
process prcss
processes prcss
prekindergarten prek
prekndrgrtn prek
prsrvtn preserv
prvntn prevent
program prgrm
programs prgrm
prbtn probat
prprty properti
prsthcs prosthet
prsthtc prosthet
prsthtcs prosthet
protections protctn
prtct protctn
prtctn protctn
presch prschl
preschl prschl
preschls prschl
preschool prschl
preschools prschl
psychthrpy psychotherapi
prntng ptg
pblshng pubg
rdgrphy radiographi
rdlgy radiologi
rdng read
readng read
rcrtn rec
rcrtns rec
rcvry recoveri
rcyclng recycl
rgstrtn registr
remdlng remod
remodel remod
remodlng remod
rntls rent
rplcmnt replac
rprdctn reproduct
rsrvtn reserv
rsrvtns reserv
rsdntl residenti
rsdntls residenti
resrc resourc
resrcs resourc
rsrc resourc
rsrcs resourc
rstrtn restor
rtrmnt retire
rhmtlgy rhumatologi
realtor rltr
realtors rltr
repair rpr
repairs rpr
research rsrch
sfty safeti
sch schl
school schl
schools schl
shelter shltr
shelters shltr
shoppe shop
shoppes shop
shp shop
shps shop
shepherd shphrd
shepherds shphrd
solution sltn
solutions sltn
smkng smoke
sprmrkt sprmkt
sprmrkts sprmkt
sprinkler sprnklr
sprinklers sprnklr
senior sr
seniors sr
snr sr
snrs sr
surgeon srgn
surgeons srgn
srgry surg
srgy surg
surgeries surg
surgry surg
servic svc
svces svc
ticket tckt
tickets tckt
tec tech
tek tech
tsting test
thrpy therapi
thru through
tntng tint
twng tow
trnng train
transport transprt
trnsprt transprt
transprtn trnsprtn
trust trst
treatment trtmnt
trmt trtmnt
teeshirt tshirt
teeshirts tshirt
townhome twnhm
townhomes twnhm
unvrsty univ
upholstery uphlstry
urlgy urologi
veteran vtrn
veterans vtrn
wllcvrng wallcov
wtrprfng waterproof
wllnss well
wnry wineri
witnss wit
witnsss wit
wtness wit
wtnss wit
wrecker wrckr
whse wrhse
worker wrkr
workers wrkr
