/*
 * Decompiled with CFR 0.152.
 */
package installer;

import installer.Install;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JComboBox;

public abstract class OperatingSystem {
    public static final OperatingSystem UNIX = new Unix();
    public static final OperatingSystem MACOS_X = new MacOSX();
    public static final OperatingSystem MACOS = new MacOS();
    public static final OperatingSystem WINDOWS = new Windows();
    public static final OperatingSystem OS2 = new HalfAnOS();
    private static OperatingSystem os;

    public abstract String getInstallDirectory(String var1);

    public String toString() {
        return "Unknown OS";
    }

    public String getShortcutDirectory(String version) {
        return null;
    }

    public void createScript(Install installer, String installDir, String binDir) throws IOException {
    }

    public void mkdirs(String directory) throws IOException {
        File file = new File(directory);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public void chmodScript(String fileName) throws IOException {
    }

    public String getExecScriptExtension() {
        return null;
    }

    public static OperatingSystem getOperatingSystem() {
        if (os != null) {
            return os;
        }
        String osName = System.getProperty("os.name");
        os = osName.indexOf("Windows") != -1 ? WINDOWS : (osName.indexOf("MacOS X") != -1 ? MACOS_X : (osName.indexOf("Mac") != -1 ? MACOS : (osName.indexOf("OS/2") != -1 ? OS2 : UNIX)));
        return os;
    }

    public static OperatingSystem[] getAvailableOperatingSystems() {
        OperatingSystem[] oses = new OperatingSystem[]{UNIX, MACOS_X, MACOS, WINDOWS, OS2};
        return oses;
    }

    public static void setOperatingSystem(OperatingSystem newOs) {
        os = newOs;
    }

    public static JComboBox createGUI() {
        OperatingSystem[] availOS = OperatingSystem.getAvailableOperatingSystems();
        JComboBox<OperatingSystem> cb = new JComboBox<OperatingSystem>(availOS);
        cb.setSelectedItem(OperatingSystem.getOperatingSystem());
        cb.addActionListener(new GUIHandler());
        return cb;
    }

    public static void main(String[] args) {
        OperatingSystem os = WINDOWS;
        Install i = new Install();
        try {
            os.createScript(i, "/home/reynal/temp", "/home/reynal/jpicedt/jpicedt/dist");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static class GUIHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            JComboBox cb = (JComboBox)e.getSource();
            OperatingSystem selOS = (OperatingSystem)cb.getSelectedItem();
            OperatingSystem.setOperatingSystem(selOS);
        }

        GUIHandler() {
        }
    }

    public static class MacOSX
    extends OperatingSystem {
        public String getInstallDirectory(String version) {
            return "/Applications/jPicEdt " + version;
        }

        public String toString() {
            return "MacOS X";
        }
    }

    public static class Unix
    extends OperatingSystem {
        public String getInstallDirectory(String version) {
            return "/usr/local/share/jpicedt/" + version;
        }

        public String getShortcutDirectory(String version) {
            return "/usr/local/bin";
        }

        public String toString() {
            return "Unix";
        }

        public void createScript(Install installer, String installDir, String binDir) throws IOException {
            String script = binDir + "/jpicedt";
            new File(script).delete();
            FileWriter out = new FileWriter(script);
            out.write("#!/bin/sh\n");
            out.write("# Java heap size, in megabytes (see quickstart.html)\n");
            out.write("JAVA_HEAP_SIZE=32\n");
            out.write("exec " + System.getProperty("java.home") + "/bin/java " + "-mx${JAVA_HEAP_SIZE}m ${JPICEDT} " + "-classpath \"${CLASSPATH}:" + installDir + ":" + installDir + "/lib/jpicedt.jar\" " + "jpicedt.JPicEdt " + "$@\n");
            out.close();
            this.chmodScript(script);
        }

        public void chmodScript(String fileName) throws IOException {
            String[] chmodArgs = new String[]{"chmod", "755", fileName};
            this.exec(chmodArgs);
        }

        public String getExecScriptExtension() {
            return ".sh";
        }

        public void mkdirs(String directory) throws IOException {
            File file = new File(directory);
            if (!file.exists()) {
                String[] mkdirArgs = new String[]{"mkdir", "-m", "755", "-p", directory};
                this.exec(mkdirArgs);
            }
        }

        public void exec(String[] args) throws IOException {
            Process proc = Runtime.getRuntime().exec(args);
            proc.getInputStream().close();
            proc.getOutputStream().close();
            proc.getErrorStream().close();
            try {
                proc.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static class Windows
    extends OperatingSystem {
        public String getInstallDirectory(String version) {
            return "C:\\Program Files\\jPicEdt " + version;
        }

        public String getShortcutDirectory(String version) {
            return "C:\\Program Files\\jPicEdt" + version;
        }

        public String toString() {
            return "MS Windows";
        }

        public String getExecScriptExtension() {
            return ".bat";
        }

        public void createScript(Install installer, String installDir, String binDir) throws IOException {
            String script = binDir + "\\jpicedt.bat";
            script = script.replace('/', '\\');
            installDir = installDir.replace('/', '\\');
            FileWriter out = new FileWriter(script);
            out.write("rem Java heap size, in megabytes (see quickstart.html)\r\n");
            out.write("@set JAVA_HEAP_SIZE=32\r\n");
            out.write("\"" + System.getProperty("java.home") + "\\bin\\java\" " + "-mx%JAVA_HEAP_SIZE%m " + "-classpath \"%CLASSPATH%;" + installDir + ";" + installDir + "\\lib\\jpicedt.jar\" " + "jpicedt.JPicEdt " + "%1 %2 %3 %4 %5 %6 %7 %8 %9\r\n");
            out.close();
        }
    }

    public static class MacOS
    extends OperatingSystem {
        public String getInstallDirectory(String version) {
            return "jPicEdt " + version;
        }

        public String toString() {
            return "MacOS";
        }
    }

    public static class HalfAnOS
    extends OperatingSystem {
        public String getInstallDirectory(String version) {
            return "C:\\jPicEdt " + version;
        }

        public String toString() {
            return "OS/2";
        }
    }
}

