/*
 * Decompiled with CFR 0.152.
 */
package installer;

import installer.Install;
import installer.InstallThread;
import installer.OperatingSystem;
import installer.Page;
import installer.Progress;
import installer.Wizard;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class SwingInstall
extends JFrame {
    private Install installer;
    private Wizard wizard;
    private ChooseDirectory chooseDirectory;
    private SelectProgramPackages selectPackages;

    public SwingInstall() {
        System.out.print("Loading installer...");
        this.installer = new Install();
        System.out.print(".");
        this.setTitle("jPicEdt " + this.installer.getVersion() + " installer");
        System.out.print(".");
        SwingInstall swingInstall = this;
        if (swingInstall == null) {
            throw null;
        }
        this.wizard = new InstallWizard(swingInstall);
        this.getContentPane().add("Center", this.wizard);
        System.out.print(".");
        this.setDefaultCloseOperation(0);
        SwingInstall swingInstall2 = this;
        if (swingInstall2 == null) {
            throw null;
        }
        this.addWindowListener(new WindowAdapter(swingInstall2){
            private final /* synthetic */ SwingInstall this$0;

            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
            {
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(SwingInstall swingInstall) {
            }
        });
        System.out.print(".");
        Dimension screen = this.getToolkit().getScreenSize();
        this.pack();
        System.out.println(".");
        ((Component)this).setLocation((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2);
        this.show();
    }

    private class InstallWizard
    extends Wizard {
        private final /* synthetic */ SwingInstall this$0;

        protected void cancelCallback() {
            System.exit(0);
        }

        protected void finishCallback() {
            System.exit(0);
        }

        InstallWizard(SwingInstall swingInstall) {
            SwingInstall swingInstall2 = this.this$0 = swingInstall;
            if (swingInstall2 == null) {
                throw null;
            }
            this.this$0.chooseDirectory = swingInstall2.new ChooseDirectory();
            System.out.print(".");
            SwingInstall swingInstall3 = this.this$0;
            if (swingInstall3 == null) {
                throw null;
            }
            this.this$0.selectPackages = swingInstall3.new SelectProgramPackages();
            System.out.print(".");
            Page[] pageArray = new Page[6];
            SwingInstall swingInstall4 = this.this$0;
            if (swingInstall4 == null) {
                throw null;
            }
            pageArray[0] = swingInstall4.new About();
            SwingInstall swingInstall5 = this.this$0;
            if (swingInstall5 == null) {
                throw null;
            }
            pageArray[1] = swingInstall5.new License();
            pageArray[2] = this.this$0.chooseDirectory;
            pageArray[3] = this.this$0.selectPackages;
            SwingInstall swingInstall6 = this.this$0;
            if (swingInstall6 == null) {
                throw null;
            }
            pageArray[4] = swingInstall6.new SwingProgress();
            SwingInstall swingInstall7 = this.this$0;
            if (swingInstall7 == null) {
                throw null;
            }
            pageArray[5] = swingInstall7.new Readme();
            Page[] pages = pageArray;
            System.out.print(".");
            this.setPages(pages);
        }
    }

    private class ShowFile
    extends Page {
        ShowFile(String key) {
            super(new BorderLayout());
            JLabel caption = new JLabel("jPicEdt " + SwingInstall.this.installer.getVersion());
            caption.setBorder(new EmptyBorder(0, 0, 12, 0));
            Font font = caption.getFont();
            caption.setFont(new Font(font.getFamily(), font.getStyle(), 18));
            this.add("North", caption);
            JEditorPane text = new JEditorPane();
            String content = SwingInstall.this.installer.getProperty(key);
            try {
                text.setText("Loading '" + content + "'...");
                text.setPage(this.getClass().getResource(content));
            }
            catch (IOException io) {
                text.setText("Error loading '" + content + "'");
                io.printStackTrace();
            }
            text.setEditable(false);
            JScrollPane scrollPane = new JScrollPane(text);
            Dimension dim = new Dimension();
            dim.height = 250;
            scrollPane.setPreferredSize(dim);
            this.add("Center", scrollPane);
        }
    }

    private class About
    extends ShowFile {
        About() {
            super("app.intro");
        }
    }

    private class Readme
    extends ShowFile {
        public String getNextButtonLabel() {
            return "Done";
        }

        public boolean canPreviousPage() {
            return false;
        }

        Readme() {
            super("app.readme");
        }
    }

    private class License
    extends ShowFile
    implements ActionListener {
        private JCheckBox cb = new JCheckBox("I approve this license agreement.");

        public boolean canNextPage() {
            return this.cb.isSelected();
        }

        public void actionPerformed(ActionEvent evt) {
            ((SwingInstall)SwingInstall.this).wizard.nextButton.setEnabled(this.cb.isSelected());
        }

        License() {
            super("app.license");
            this.cb.addActionListener(this);
            this.add("South", this.cb);
        }
    }

    private class ChooseDirectory
    extends Page
    implements ActionListener {
        private JTextField installDirTF;
        private JTextField binDirTF;
        private JButton chooseInstallBT;
        private JButton chooseBinBT;

        public void actionPerformed(ActionEvent evt) {
            JTextField field = evt.getSource() == this.chooseInstallBT ? this.installDirTF : this.binDirTF;
            File directory = new File(field.getText());
            JFileChooser chooser = new JFileChooser(directory.getParent());
            chooser.setFileSelectionMode(1);
            chooser.setSelectedFile(directory);
            if (chooser.showOpenDialog(SwingInstall.this) == 0) {
                String s = chooser.getSelectedFile().getPath();
                if (evt.getSource() == this.chooseInstallBT) {
                    s = s + File.separator + "jpicedt" + File.separator + SwingInstall.this.installer.getVersion();
                }
                field.setText(s);
            }
        }

        ChooseDirectory() {
            super(new BorderLayout());
            JLabel caption = new JLabel("jPicEdt installation directories...");
            Font font = caption.getFont();
            caption.setFont(new Font(font.getFamily(), font.getStyle(), 18));
            this.add("North", caption);
            Box box = new Box(1);
            box.add(new JLabel("Operating System : " + OperatingSystem.getOperatingSystem()));
            String binDir = OperatingSystem.getOperatingSystem().getShortcutDirectory(SwingInstall.this.installer.getVersion());
            JPanel directoryPanel = new JPanel();
            GridBagLayout layout = new GridBagLayout();
            directoryPanel.setLayout(layout);
            GridBagConstraints cons = new GridBagConstraints();
            cons.anchor = 17;
            cons.fill = 2;
            cons.gridy = 1;
            cons.insets = new Insets(0, 0, 6, 0);
            JLabel label = new JLabel("Install program in: ", 4);
            label.setBorder(new EmptyBorder(0, 0, 0, 12));
            layout.setConstraints(label, cons);
            directoryPanel.add(label);
            cons.weightx = 1.0;
            this.installDirTF = new JTextField();
            this.installDirTF.setText(OperatingSystem.getOperatingSystem().getInstallDirectory(SwingInstall.this.installer.getVersion()));
            layout.setConstraints(this.installDirTF, cons);
            directoryPanel.add(this.installDirTF);
            if (binDir != null) {
                cons.gridy = 2;
                cons.weightx = 0.0;
                cons.insets = new Insets(0, 0, 0, 0);
                label = new JLabel("Install shortcut in: ", 4);
                label.setBorder(new EmptyBorder(0, 0, 0, 12));
                layout.setConstraints(label, cons);
                directoryPanel.add(label);
                cons.weightx = 1.0;
                this.binDirTF = new JTextField(binDir);
                layout.setConstraints(this.binDirTF, cons);
                directoryPanel.add(this.binDirTF);
            }
            box.add(directoryPanel);
            Box buttons = new Box(0);
            this.chooseInstallBT = new JButton("Choose Install Directory...");
            this.chooseInstallBT.setRequestFocusEnabled(false);
            this.chooseInstallBT.addActionListener(this);
            buttons.add(this.chooseInstallBT);
            if (binDir != null) {
                buttons.add(Box.createHorizontalStrut(6));
                this.chooseBinBT = new JButton("Choose Shortcut Directory...");
                this.chooseBinBT.setRequestFocusEnabled(false);
                this.chooseBinBT.addActionListener(this);
                buttons.add(this.chooseBinBT);
            }
            box.add(buttons);
            box.add(Box.createGlue());
            this.add("Center", box);
        }
    }

    private class SelectProgramPackages
    extends Page
    implements ActionListener {
        JPanel comp;
        JLabel sizeLabel;

        public String getNextButtonLabel() {
            return "Install";
        }

        public void actionPerformed(ActionEvent evt) {
            this.updateSize();
        }

        private JPanel createCompPanel() {
            int count = SwingInstall.this.installer.getIntProperty("comp.count");
            JPanel panel = new JPanel(new GridLayout(count, 1));
            int i = 0;
            while (i < count) {
                JCheckBox checkBox = new JCheckBox(SwingInstall.this.installer.getProperty("comp." + i + ".name") + " (" + SwingInstall.this.installer.getProperty("comp." + i + ".size") + "Kb)");
                checkBox.getModel().setSelected(true);
                checkBox.setToolTipText(SwingInstall.this.installer.getProperty("comp." + i + ".tooltip"));
                checkBox.addActionListener(this);
                checkBox.setRequestFocusEnabled(false);
                panel.add(checkBox);
                ++i;
            }
            Dimension dim = panel.getPreferredSize();
            dim.width = Integer.MAX_VALUE;
            panel.setMaximumSize(dim);
            return panel;
        }

        private void updateSize() {
            int size = 0;
            int i = 0;
            while (i < this.comp.getComponentCount()) {
                if (((JCheckBox)this.comp.getComponent(i)).getModel().isSelected()) {
                    size += SwingInstall.this.installer.getIntProperty("comp." + i + ".size");
                }
                ++i;
            }
            this.sizeLabel.setText("Estimated disk usage of selected components: " + size + "Kb");
        }

        SelectProgramPackages() {
            super(new BorderLayout());
            JLabel caption = new JLabel("Program components to install:");
            Font font = caption.getFont();
            caption.setFont(new Font(font.getFamily(), font.getStyle(), 18));
            this.add("North", caption);
            Box box = new Box(1);
            box.add(Box.createGlue());
            this.comp = this.createCompPanel();
            box.add(this.comp);
            box.add(Box.createGlue());
            this.add("Center", box);
            this.sizeLabel = new JLabel("", 2);
            this.add("South", this.sizeLabel);
            this.updateSize();
        }
    }

    private class SwingProgress
    extends Page
    implements ActionListener,
    Progress {
        private JLabel messageLBL;
        private JProgressBar progressPB;
        private JButton stopBT;
        private InstallThread thread;

        public void madeVisible() {
            Vector<String> components = new Vector<String>();
            int size = 0;
            JPanel comp = ((SwingInstall)SwingInstall.this).selectPackages.comp;
            int i = 0;
            while (i < comp.getComponentCount()) {
                if (((JCheckBox)comp.getComponent(i)).getModel().isSelected()) {
                    size += SwingInstall.this.installer.getIntProperty("comp." + i + ".size");
                    components.addElement(SwingInstall.this.installer.getProperty("comp." + i + ".fileset"));
                }
                ++i;
            }
            JTextField binDirTF = SwingInstall.this.chooseDirectory.binDirTF;
            String installDir = SwingInstall.this.chooseDirectory.installDirTF.getText();
            if (installDir != null && installDir.endsWith(File.separator)) {
                installDir = installDir.substring(0, installDir.length() - 1);
            }
            String binDir = null;
            if (binDirTF != null && (binDir = binDirTF.getText()).endsWith(File.separator)) {
                binDir = binDir.substring(0, binDir.length() - 1);
            }
            InstallThread thread = new InstallThread(SwingInstall.this.installer, this, installDir, binDir, size, components);
            this.setThread(thread);
            thread.start();
        }

        public boolean canPreviousPage() {
            return false;
        }

        public String getNextButtonLabel() {
            return "View readme file";
        }

        public void showMessage(String msg) {
            SwingProgress swingProgress = this;
            if (swingProgress == null) {
                throw null;
            }
            SwingUtilities.invokeLater(new Runnable(swingProgress, msg){
                private final /* synthetic */ SwingProgress this$0;
                private final /* synthetic */ String val$msg;

                public void run() {
                    SwingProgress.access$0(this.this$0).setText(this.val$msg);
                }
                {
                    this.val$msg = val$msg;
                    this.this$0 = this$0;
                    this.constructor$0(this$0);
                }

                private final void constructor$0(SwingProgress swingProgress) {
                }
            });
        }

        public void setMaximum(int max) {
            SwingProgress swingProgress = this;
            if (swingProgress == null) {
                throw null;
            }
            SwingUtilities.invokeLater(new Runnable(swingProgress, max){
                private final /* synthetic */ SwingProgress this$0;
                private final /* synthetic */ int val$max;

                public void run() {
                    SwingProgress.access$1(this.this$0).setMaximum(this.val$max);
                }
                {
                    this.val$max = val$max;
                    this.this$0 = this$0;
                    this.constructor$0(this$0);
                }

                private final void constructor$0(SwingProgress swingProgress) {
                }
            });
        }

        public void advance(int value) {
            try {
                SwingProgress swingProgress = this;
                if (swingProgress == null) {
                    throw null;
                }
                SwingUtilities.invokeAndWait(new Runnable(swingProgress, value){
                    private final /* synthetic */ SwingProgress this$0;
                    private final /* synthetic */ int val$value;

                    public void run() {
                        SwingProgress.access$1(this.this$0).setValue(SwingProgress.access$1(this.this$0).getValue() + this.val$value);
                    }
                    {
                        this.val$value = val$value;
                        this.this$0 = this$0;
                        this.constructor$0(this$0);
                    }

                    private final void constructor$0(SwingProgress swingProgress) {
                    }
                });
                Thread.yield();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void done() {
            SwingProgress swingProgress = this;
            if (swingProgress == null) {
                throw null;
            }
            SwingUtilities.invokeLater(new Runnable(swingProgress){
                private final /* synthetic */ SwingProgress this$0;

                public void run() {
                    this.this$0.showMessage("jPicEdt was installed successfully.\n");
                    SwingProgress.access$2(this.this$0).setText("Finish");
                }
                {
                    this.this$0 = this$0;
                    this.constructor$0(this$0);
                }

                private final void constructor$0(SwingProgress swingProgress) {
                }
            });
        }

        public void error(String message) {
            SwingProgress swingProgress = this;
            if (swingProgress == null) {
                throw null;
            }
            SwingUtilities.invokeLater(new Runnable(swingProgress, message){
                private final /* synthetic */ SwingProgress this$0;
                private final /* synthetic */ String val$message;
                private final /* synthetic */ SwingInstall this$1;

                public void run() {
                    this.this$1.dispose();
                    JOptionPane.showMessageDialog(null, this.val$message, "Installation aborted", 0);
                    System.exit(1);
                }
                {
                    this.val$message = val$message;
                    this.this$0 = this$0;
                    this.this$1 = SwingProgress.access$3(this.this$0);
                    this.constructor$0(this$0);
                }

                private final void constructor$0(SwingProgress swingProgress) {
                }
            });
        }

        public void setThread(InstallThread thread) {
            this.thread = thread;
        }

        public void actionPerformed(ActionEvent evt) {
            if (this.stopBT.getText().equals("Stop")) {
                this.stopBT.getModel().setEnabled(false);
                this.thread.kill();
                SwingInstall.this.dispose();
                JOptionPane.showMessageDialog(null, "Installation aborted.", "Installation aborted", 0);
                System.exit(1);
            } else {
                SwingInstall.this.dispose();
                System.exit(0);
            }
        }

        static /* synthetic */ JLabel access$0(SwingProgress swingProgress) {
            return swingProgress.messageLBL;
        }

        static /* synthetic */ JProgressBar access$1(SwingProgress swingProgress) {
            return swingProgress.progressPB;
        }

        static /* synthetic */ JButton access$2(SwingProgress swingProgress) {
            return swingProgress.stopBT;
        }

        static /* synthetic */ SwingInstall access$3(SwingProgress swingProgress) {
            return swingProgress.SwingInstall.this;
        }

        public SwingProgress() {
            super(new BorderLayout());
            System.out.print(".");
            this.setBorder(new EmptyBorder(12, 12, 12, 12));
            this.messageLBL = new JLabel("Installing JPicEdt ...");
            this.messageLBL.setBorder(new EmptyBorder(0, 0, 12, 0));
            this.add("North", this.messageLBL);
            this.progressPB = new JProgressBar();
            this.progressPB.setStringPainted(true);
            this.add("Center", this.progressPB);
            this.stopBT = new JButton("Stop");
            this.stopBT.addActionListener(this);
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 0));
            panel.setBorder(new EmptyBorder(12, 0, 0, 0));
            panel.add(Box.createGlue());
            panel.add(this.stopBT);
            panel.add(Box.createGlue());
            this.add("South", panel);
        }
    }
}

