/* IRIS GL module */
#include <device.h>
#include <gl.h>
#include "defs.h"
#include <stdio.h>
#include <math.h>
#define byte_size 8
#define BASE_INDEX 8
/* store these pointers to allow lookups into the CGM data structures */
static struct one_opt 		*popt;	/* the command line options, in only */
static struct mf_d_struct 	*pc1;	/* the class 1 elements, in only */
static struct pic_d_struct 	*pc2;	/* the class 2 elements, in only */
static struct control_struct	*pc3;	/* the class 3 elements, in only */
static struct attrib_struct	*pc5;	/* the class 5 elements, in only */
static struct info_struct 	*dptr;	/* device info in and out */


/* these are the screen variables */
static unsigned int retpwidth, retpheight;
static float retwidth, retheight, retresolx, retresoly;
static unsigned int dev_type, tot_indices, colors, maps, rbits, gbits, bbits,
	ibits, res_indices, regen;
#define max_str 128
static char fname[max_str + 1];
static int fname_l;
static int state_level;
static unsigned int gbl_style = ~0;
static char file_buffer[max_str + 1], prog_buffer[max_str + 1];
void set_colour();
extern char *allocate_mem();
static Colorindex old_index;
static int max_val;	/* maximum colour value */
#define MAX_D_VAL 255		/* max direct colour value */
/* macro to convert from real to integer colour value */
#define short_col(r_col) ((short) ((r_col) * MAX_D_VAL + 0.49999))
static struct rgbi_struct back_col;
static int my_inds[3];
/* start everything up */
igl_begin(comment, file_name, prog_name)
char *comment, *file_name, *prog_name;

{
	if (*file_name) {
	    strncpy(file_buffer, file_name, max_str);
	    file_buffer[max_str] = '\0';
	} else file_buffer[0] = '\0';
	if (*prog_name) {
	    strncpy(prog_buffer, prog_name, max_str);
	    prog_buffer[max_str] = '\0';
	} else prog_buffer[0] = '\0';
	return(1);
}
/* start a page  */
igl_bpage(pic_name, xoffset, yoffset, rotation, rb, gb, bb, page_no, 
    xsize, ysize)
char *pic_name;
float rotation;
int xoffset, yoffset, page_no, xsize, ysize;
float rb, gb, bb;	/* background colour values */
{
int i, top_index;
long xorig, yorig, x2, y2;
short red, green, blue;
extern int get_cinds();
#ifdef NEVER
	getorigin(&xorig, &yorig);
	x2 = xorig + xsize;
	y2 = yorig + ysize;
	winposition(xorig, x2, yorig, y2); 
	reshapeviewport();
#endif
	if (*pic_name) wintitle(pic_name);
	else if (*file_buffer) wintitle(file_buffer);
	else if (*prog_buffer) wintitle(prog_buffer);
	else wintitle("GPLOT");
	/* take care of colours */
	old_index = -1;
	drawmode(NORMALDRAW);
	if (!popt[(int) screen].set) cursoff();  

	if (pc2->c_s_mode == d_c_mode) {	/* direct colour */
	    get_cinds(max_val - BASE_INDEX, my_inds);
	    load_dcmap(my_inds);
	} else 
	if (pc2->c_s_mode == i_c_mode) {	/* indexed colour */
	    /* fill out the colour map */
	    top_index = ((pc1->max_c_index + BASE_INDEX) > max_val) ? max_val :
	    	pc1->max_c_index + BASE_INDEX;
	    for (i=0; i < top_index; ++i) {
	        mapcolor((Colorindex) (i + BASE_INDEX), 
		    short_col(*(pc5->ctab + i * 3)),
		    short_col(*(pc5->ctab + i * 3 + 1)), 
		    short_col(*(pc5->ctab + i * 3 + 2)));
	    }
	} else {
	    fprintf(stderr, "illegal colour mode %d\n", (int) pc2->c_s_mode);
	}
	/* set the background colour */
	back_col.ind = 0;
	back_col.red = rb;
	back_col.green = gb;
	back_col.blue = bb;
	set_colour(&back_col);
	clear();
	return(1);

}
/* end a page */
igl_epage(copies)
int copies;
{
short data;
	qreset();	/* reset the queue */
	qdevice(LEFTMOUSE);	/* watch for this */
	if (popt[(int) screen].set) while (LEFTMOUSE != qread(&data)) 
            sleep(1); /* did the user click ? */
	return(1);
}
/* end the metafile */
igl_end(pages_done)
int pages_done;
{
	return(1);
}
/* plot a set of lines between alternate points */
igl_dpline(no_pairs, x1_ptr, y1_ptr)
int no_pairs, *x1_ptr, *y1_ptr;
{
unsigned int dpl_atb;

	return(1);
}
/* do line between a series of points */
igl_pline(no_pairs, x1_ptr, y1_ptr)
int no_pairs, *x1_ptr, *y1_ptr;
{
int i;
long my_vert[2];

	set_colour(&pc5->line_colour);
	bgnline();

	for (i=0; i<no_pairs; ++i) {
	    my_vert[0] = (long) x1_ptr[i];
	    my_vert[1] = (long) y1_ptr[i];
	    v2i(my_vert);

	}
	endline();

	return(1);
}

/* do a polygon, may want to fill it */
igl_pgon(no_pairs, x1_ptr, y1_ptr)
int no_pairs, *x1_ptr, *y1_ptr;
{
#define MAX_VERTICES 256
long my_vert[2];
int i, want_edge;
	if ( no_pairs <= 1 ) return(1);
	if (no_pairs > MAX_VERTICES) no_pairs = MAX_VERTICES; /* for now */

	/* first do the polygon interior */
	switch (pc5->int_style) {
	case hollow :
	case empty :		set_colour(&back_col); break;

	
	case pattern :	
		/* no pattern fill yet */
	case hatch :	
		/* no hatch fill yet */
	case solid_i :		set_colour(&pc5->fill_colour);
				break;
	}
	bgnpolygon();
	for (i=0; i<no_pairs; ++i) {
	    my_vert[0] = (long) x1_ptr[i];
	    my_vert[1] = (long) y1_ptr[i];
	    v2i(my_vert);
	}
	endpolygon();

	/* may want visible edge */
	want_edge = (pc5->edge_vis == on) || (pc5->int_style == hollow);
	if (want_edge){	
	    if (pc5->edge_vis == on) set_colour(&pc5->edge_colour);
	    else set_colour(&pc5->fill_colour);
	}
	bgnline();
	for (i=0; i<no_pairs; ++i) {
	    my_vert[0] = (long) x1_ptr[i];
	    my_vert[1] = (long) y1_ptr[i];
	    v2i(my_vert);
	}
	endline();

	return(1);
}
#undef MAX_VERTICES
/* do a rectangle */
igl_rectangle(x1, y1, x2, y2)
int x1, x2, y1, y2;
{
	return(1);
}
/* first the basic circle routine */
static do_circle(x, y, r, deg0, deg1, use_atb)
int x, y, r;	/* position of centre and radius */
float deg0, deg1;	/* beginning and ending degrees (start at top) */
unsigned int use_atb;
{
	return(1);
}
/* set  a Circle */
igl_circle(x, y, r)
int x, y, r;
{
	return(1);
}

/* set an arc, we get the positions of 1st pt, intermediate pt, end pt */
/* see utils.c for details */
igl_c3(pt_ptr)
int *pt_ptr;
{
	return(1);
}
/* set  a closed arc, get the positions of 1st pt, intermdiate pt, end pt */
igl_c3_close(pt_ptr, chord)
int *pt_ptr;
enum boolean chord;
{
	return(1);
}
/* set an arc, ends specified by vectors */
igl_c_centre(x, y, vec_array, r)
int x, y, *vec_array, r;
{
	return(1);
}
/* set an arc, ends specified by vectors, but close it */
igl_c_c_close(x, y, vec_array, r, chord)
int x, y, *vec_array, r;
enum boolean chord;
{
	return(1);
}
/* first the basic  ellipse routine */
static do_ellipse(x, y, r, deg0, deg1)
int x, y, r;	/* position of centre and radius */
float *deg0, *deg1;	/* beginning and ending degrees (start at top) */
{
	return(1);
}
/* set an ellipse, centre and two endpoints */
igl_ellipse(pt_array)
int *pt_array;
{

	return(1);
}
/* set an elliptical arc, centre, two endpoints, vectors for ends */
igl_ell_arc(pt_array, vec_array)
int *pt_array, *vec_array;
{

	return(1);
}
/* set an elliptical arc, close it */
igl_e_a_close(pt_array, vec_array, chord)
int *pt_array, *vec_array;
enum boolean chord;
{

	return(1);
}

/* set marker at a series of points */
igl_pmarker(no_pairs, x1_ptr, y1_ptr)
int no_pairs, *x1_ptr, *y1_ptr;
{
	return(1);
}
/* for cell arrays */
igl_carray(cp, cq, cr, nx, ny, col_prec, dat_ptr, rep_mode, no_bytes)
int *cp;	/* first corner */
int *cq;	/* the diagonal to cp p*/
int *cr;	/* first row is from cp to cr */
int nx;		/* number of elements in x rows (i.e., parallel to cp-cr) */
int ny;		/* number of rows */
int col_prec;	/* the colour precision (how many possible colour values */
unsigned char *dat_ptr;	/* pointer to the body of information */
int rep_mode;	/* the representation mode; 0, run length encoded, 1 normal */
int no_bytes;	/* number of data bytes */
{
short *new_ptr;
unsigned int new_bytes, i, j, row_size, bdone, c_size, new_size;
Screencoord x1, x2, y1, y2;
#define lctab_size 2
static float lctab[3 * lctab_size] = {1.0, 1.0, 1.0, 0.0, 0.0, 0.0};
int out_flag;
int my_flag = 0;
int want_rmode = 1;
int want_cp;
int want_csmode = 0;
int new_nx, new_ny;
int bytes_needed, bits_row, bytes_row, first_index;
int px, py, qx, qy, rx, ry;	/* the local co-ord system */

	px = cp[0];
	py = cp[1];
	qx = cq[0];
	qy = cq[1];
	rx = cr[0];
	ry = cr[1];
	want_cp = 16	/* 16 bits per pixel */;
	first_index =  (pc2->c_s_mode == d_c_mode) ? 1 : 0;
	/* the rows and columns we need */
	new_nx = (rx > px) ? 1 + rx - px : 1 + px - rx;
	new_ny = (qy > py) ? 1 + qy - py : 1 + py - qy;
	
	bits_row = new_nx * want_cp;
	bytes_row = (bits_row + byte_size - 1) / byte_size;
	bytes_needed = bytes_row * new_ny;

	if (!(new_ptr = (short *) allocate_mem(bytes_needed, 1)))
	    return(2);

	/* get the appropriate IGL coordinates */
	/* basically only need the bottom left hand corner, nx and ny */
	x1 = (cp[0] < cr[0]) ? cp[0] : cr[0];
	y1 = (cp[1] < cq[1]) ? cp[1] : cq[1];
	x2 = x1 + new_nx - 1;
	y2 = y1 + new_ny - 1;

/* lets make the cell array fit */

	new_carray(NULL, nx, ny, col_prec, rep_mode, 
	    0, dat_ptr, no_bytes, pc2->c_s_mode,
	    pc5->ctab, pc1->max_c_index, px, py, qx, qy,
	    rx, ry, new_nx, new_ny,
	    want_cp, want_rmode, bits_row, new_ptr, bytes_needed, 
	    want_csmode, lctab, lctab_size, my_flag, &out_flag, 
	    first_index, my_inds, &(pc1->c_v_extent));

	/* at this point we are sure of a normal cell array in cgm format; */
	/* everything almost in shape */
	for (i=0; i<new_nx*new_ny; ++i) new_ptr[i] += BASE_INDEX;

	/* write out the array */
	rectwrite(x1, y1, x2, y2, new_ptr);

	(void) free(new_ptr);
	return(1);
}
/* set text */
igl_text(x, y, final, buffer)
int x, y, final;
char *buffer;
{
	return(1);

}
/* now set the attributes */
/* set the line type */
igl_l_type(l_type)
enum line_enum l_type;
{
	return(1);
}
/* set the line width */
igl_l_width(l_width, rmul)
int l_width;
float rmul;
{

	return(1);
}
/* set the character height */
igl_cheight(size)
int size;
{

	return(1);
}
/* get a colour table here */
igl_ctab(beg_index, no_entries, ctab)
int beg_index, 	/* beginning index */
no_entries; 	/* number of entries to add starting at beg_index */
float *ctab;	/* direct colour array, *(ctab + i*3) is the red
		   entry for the i'th index, followed by g and b */
{
int i, top_index;

	if (pc2->c_s_mode != i_c_mode) return(2);
	/* fill out the colour map */
	top_index = beg_index + no_entries;
	top_index = ((top_index + BASE_INDEX) > max_val) ? max_val :
	    top_index + BASE_INDEX;
	for (i=beg_index; i < top_index; ++i) {
	    mapcolor((Colorindex) (i + BASE_INDEX), 
		short_col(*(ctab + i * 3)),
		short_col(*(ctab + i * 3 + 1)), 
		short_col(*(ctab + i * 3 + 2)));
	}
	return(1);
}

/* set a font */
igl_font(index, size)
int index, size;
{
	
	return(1);
}
/* this is the routine that sets everything up */
/* the initialising routine for the IRIS GL module */
void igl_setup(opt, dev_info, c1, c2, c3, c5, delim, mfdesc, pdesc, mfctrl,
	gprim, attr, escfun, extfun, ctrl, pargc, argv)

struct one_opt 		*opt;	/* the command line options, in only */
struct info_struct *dev_info;	/* device info to fill out, out only */
struct mf_d_struct 	*c1;	/* the class 1 elements, in only */
struct pic_d_struct 	*c2;	/* the class 2 elements, in only */
struct control_struct	*c3;	/* the class 3 elements, in only */
struct attrib_struct	*c5;	/* the class 5 elements, in only */
int (*delim[Delim_Size])();	/* delimiter functions */
int (*mfdesc[MfDesc_Size])();	/* metafile descriptor functions */
int (*pdesc[PDesc_Size])();	/* page descriptor functions */
int (*mfctrl[Control_Size])();	/* control functions */
int (*gprim[GPrim_Size])();	/* graphical primitives */
int (*attr[Att_Size])();	/* the attribute functions */
int (*escfun[Esc_Size])();	/* the escape functions */
int (*extfun[Ext_Size])();	/* the external functions */
int (*ctrl[Delim_Size])();	/* external controller functions */
int *pargc;			/* argc pointer */
char **argv;			/* argv */	
{
long xw_size, yw_size, x_wanted, y_wanted, x_start, y_start;
int no_planes;

	/* store the command line argument pointer */
	popt = opt;
	/* store the device info pointer */
	dptr = dev_info;
	/* store the CGM data structure pointers */
	pc1 = c1;
	pc2 = c2;
	pc3 = c3;
	pc5 = c5;

	/* fill out the device info structure */
	dev_info->pxl_in 	= 100.0;	/* arbitrary decision */
	dev_info->ypxl_in 	= 100.0;

/* do we want a particular size or position ? */

	if (popt[(int) x_size].set && popt[(int) y_size].set &&
	    popt[(int) x_offset].set && popt[(int) y_offset].set) {
	    x_wanted = popt[(int) x_size].val.r * dev_info->pxl_in;
	    y_wanted = popt[(int) y_size].val.r * dev_info->ypxl_in;
	    x_start = popt[(int) x_offset].val.r * dev_info->pxl_in;
	    y_start = popt[(int) y_offset].val.r * dev_info->ypxl_in;
	    prefposition(x_start, x_start + x_wanted - 1,
		y_start, y_start + y_wanted - 1);
	} else if (popt[(int) x_size].set && popt[(int) y_size].set) {
	    x_wanted = popt[(int) x_size].val.r * dev_info->pxl_in;
	    y_wanted = popt[(int) y_size].val.r * dev_info->ypxl_in;
	    prefsize(x_wanted, y_wanted);
	}

	/* open up the window */
	foreground();
	winopen("GPLOT");
	concave(TRUE);  /* Tell igl to expect concave polygons  */
        /* get the details of the workstation */
	no_planes = getplanes();
	max_val = (1 << no_planes) - 256;	/* 256 are reserved */
	if (max_val <BASE_INDEX) {
	    fprintf(stderr, " no colours available !\n");
	}
	getsize(&xw_size, &yw_size);
	if (opt[(int) debug].set)

	{
	    fprintf(stderr, "%d planes, window size = (%d,%d)\n",
		no_planes, (int) xw_size, (int) yw_size);
	}
	dev_info->x_size 	= xw_size / dev_info->pxl_in;
	dev_info->y_size 	= yw_size / dev_info->ypxl_in;
	dev_info->x_offset	= 0.0;	/* fix later */
	dev_info->y_offset	= 0.0;
	dev_info->c_height	= 12;
	dev_info->c_width	= 12;
	dev_info->d_l_width	= 1;				
	dev_info->d_e_width	= 1;				
	dev_info->d_m_size	= dev_info->c_height;	/* marker size */
	*dev_info->out_name	= '\0';		/* no output file */
	dev_info->capability	= 0;	/* for now */

	/* now fill out the function pointer arrays for CGM */
	/* the delimiter functions */
	delim[(int) B_Mf] 	= igl_begin;
	delim[(int) E_Mf]	= igl_end;
	delim[(int) B_Pic_Body]	= igl_bpage;
	delim[(int) E_Pic]	= igl_epage;

	/* the graphical primitives */
	gprim[(int) PolyLine]	= igl_pline;
	gprim[(int) Polygon]	= igl_pgon;
	gprim[(int) Cell_Array]	= igl_carray; 
/*	gprim[(int) Dis_Poly]	= igl_dpline;
	gprim[(int) PolyMarker]	= igl_pmarker;
	gprim[(int) Text]	= igl_text;
	gprim[(int) Rectangle]	= igl_rectangle;
	gprim[(int) Cgm_Circle]	= igl_circle;
	gprim[(int) Circ_3]	= igl_c3;
	gprim[(int) Circ_3_Close]	= igl_c3_close;
	gprim[(int) Circ_Centre]	= igl_c_centre;
	gprim[(int) Circ_C_Close]	= igl_c_c_close;
	gprim[(int) Ellipse]	= igl_ellipse;
	gprim[(int) Ellip_Arc]	= igl_ell_arc;
	gprim[(int) El_Arc_Close] 	= igl_e_a_close;

*/	/* the attributes */
	attr[(int) LType]	= igl_l_type;
	attr[(int) LWidth]	= igl_l_width;
	attr[(int) CHeight]	= igl_cheight;
	attr[(int) ColTab] 	= igl_ctab;
	return;
}
/* general colour setting routine */
static void set_colour(cptr)
struct rgbi_struct *cptr;
{
Colorindex c;


	if (pc2->c_s_mode == i_c_mode) {	/* indexed */
	    c = (Colorindex) (BASE_INDEX + cptr->ind); 
	}
	else if (pc2->c_s_mode == d_c_mode) {	/* direct colour */
	    c = (Colorindex) int_rgb(cptr->red, cptr->green, cptr->blue,
		my_inds);
	    c += BASE_INDEX;
	}
	if (c != old_index) {
	    color(c);
	    old_index = c;
	}
	return;
}
/* experimental Direct Colour stuff */
/* load the DC colour map */
static load_dcmap(ninds)
int *ninds;
{
int i, j, k;
short rs, gs, bs;
Colorindex c;
float top0, top1, top2;

	/* establish bounds */
	top0 = (ninds[0] > 1) ? ninds[0] - 1.0 : 1.0;
	top1 = (ninds[1] > 1) ? ninds[1] - 1.0 : 1.0;
	top2 = (ninds[2] > 1) ? ninds[2] - 1.0 : 1.0;

	for (i=0; i<ninds[2]; ++i) {
	    for (j=0; j<ninds[1]; ++j) {
		for (k=0; k<ninds[0]; ++k) {
		    c = (Colorindex) 
			(ind_ijk(ninds, i, j, k) + BASE_INDEX);
		    mapcolor(c,
				(short) ((MAX_D_VAL * k) / top0),
				(short) ((MAX_D_VAL * j) / top1),
				(short) ((MAX_D_VAL * i) / top2));
		}
	    }
	}
	return(1);
}
