/*-
******************************************************************************
******************************************************************************
**
**  ARCHIVE HEADER INFORMATION
**
**  @C-file{
**      FILENAME    = "vvutils.h",
**      VERSION     = "1.00",
**      DATE        = "",
**      TIME        = "",
**
**      AUTHOR      = "Niel Kempson",
**      ADDRESS     = "25 Whitethorn Drive
**                     Cheltenham
**                     GL52 5LL
**                     England",
**      TELEPHONE   = "+44-242 579105",
**      EMAIL       = "kempson@tex.ac.uk (Internet)",
**
**      SUPPORTED   = "yes",
**      ARCHIVED    = "tex.ac.uk, ftp.tex.ac.uk",
**      KEYWORDS    = "VVcode",
**
**      CODETABLE   = "ISO/ASCII",
**      CHECKSUM    = "51492 1481 5732 57976",
**
**      DOCSTRING   = { This file is part of VVcode.
**                  }
**  }
**
**  MODULE CONTENTS
**
**      allocate_buffer         Allocate memory for a buffer.
**      display_comment         Display a VVE file comment.
**      f_close                 Close a file.
**      getc_format             Get the format specified on the command line.
**      getc_mode               Get the mode specified on the command line.
**      getc_reclen             Get the maximum record length specified on
**                              the command line.
**      getc_timestamp          Get the timestamp specified on the command 
**                              line.
**      header_type             Look for a header string in a list of headers.
**      init_crc32_table        Initialize the 32 bit CRC table.
**      lookup_key              Look for a string in a list of keywords.
**      make_time               Convert a 'tm' structure into a Unix style
**                              time_t value.
**      open_log_file           Open the log file for writing.
**      parse_header            Extract the value of a VVE/XLT header line.
**      pars_time               Parse a string in VVcode timestamp format and
**                              convert it to a Unix style time_t value.
**      pars_xlt_tbl            Parse a character set translation table.
**      rd_enc_tbl              Read and check an encoding table from a
**                              specified file.
**      rd_xlt_tbl              Read and check a character set translation 
**                              table from a specified file.
**      set_dec_tbl             Invert an encoding table to form a decoding 
**                              table.
**      set_xlt_tbl             Setup the character set translation table.
**      show_file_context       Show the context in which a file processing
**                              error occurred.
**      vstrchr                 Search a string for the first occurrence of a 
**                              specified character.
**      vstricmp                Compare two strings ignoring case differences.
**      vstrnicmp               Compare at most 'n' characters of two strings
**                              ignoring case differences.
**      vstrrchr                Search a string for the last occurrence of a 
**                              specified character.
**      vstrrstr                Search a string for the last occurrence of
**                              any of a list of specified characters.
**      vstrstr                 Search a string for the first occurrence of
**                              any of a list of specified characters.
**      vv_timestamp            Convert a Unix style time_t value into a 
**                              VVcode format timestamp string.
**      vstrdup                 Duplicate a string, allocating memory for the
**                              copy.
**      vstrtrws                Strip trailing whitespace from a string.
**
**  COPYRIGHT
**
**      Written 1991-1992 by Niel Kempson <kempson@tex.ac.uk> who claims
**      no copyright over this program - you are free to use it as you wish.
**
**  CHANGE LOG
**
******************************************************************************
******************************************************************************
*/


/*
**----------------------------------------------------------------------------
** Forward declarations of functions in the file 'vvutils.c'
**----------------------------------------------------------------------------
*/
char *allocate_buffer           ARGS ((CONST SIZE_T buf_len,
                                    CONST char *buf_name));
void display_comment            ARGS ((CONST File_Info *ip_file,
                                    CONST char *line_ptr,
                                    Header_Struct *hdr_struct));
void f_close                    ARGS ((File_Info *file));
Int16 getc_format               ARGS ((CONST Qualifier_Struct *qual_format,
                                    CONST char *fmt_str_array[]));
Int16 getc_mode                 ARGS ((CONST Qualifier_Struct *qual_mode,
				    CONST char *mode_str_array[]));
Int32 getc_reclen               ARGS ((CONST Qualifier_Struct *qual_reclen,
                                    CONST File_Info *ip_file));
TIME_T getc_timestamp           ARGS ((CONST Qualifier_Struct *qual_timestamp));
Int16 header_type               ARGS ((CONST File_Info *ip_file,
                                    CONST char *line_ptr,
                                    CONST Header_Struct *hdr_array));
void init_crc32_table           ARGS ((CONST Int16 crc_table_size,
                                    CONST Unsigned32 crc_polynomial,
                                    Unsigned32 *crc_table));
Int16 lookup_key                ARGS ((CONST char *key_list[],
                                    CONST char *key_string,
                                    CONST Int16 allow_abbrevs,
                                    CONST Int16 case_sensitivity));
TIME_T make_time                ARGS ((CONST struct tm *t_struct));
void open_log_file              ARGS ((CONST Qualifier_Struct *log_qualifier,
                                    CONST char *def_file_name,
                                    CONST Int16 overwrite_flag,
                                    File_Info *log_file));
void parse_header               ARGS ((CONST File_Info *ip_file,
                                    CONST char *line_ptr,
                                    Header_Struct *hdr_struct));
TIME_T pars_time                ARGS ((CONST char *time_str));
Boolean pars_xlt_tbl            ARGS ((CONST char *xlt_buffer,
                                    Xlt_Struct *xlt_tbl,
                                    Int16 subst_char));
Boolean rd_enc_tbl              ARGS ((File_Info *enc_file,
				    CONST Int16 enc_tbl_len,
				    char *encode_table));
Int16 rd_xlt_tbl                ARGS ((Header_Struct *xlt_hdr_array,
				    File_Info *xlt_file,
				    Xlt_Struct *xlt_tbl));
void set_dec_tbl                ARGS ((CONST Int16 enc_tbl_len,
				    CONST char *encode_table,
				    CONST Int16 dec_tbl_len,
                                    Int16 *decode_table));
void set_xlt_tbl                ARGS ((File_Info *xlt_file,
                                    Xlt_Struct *xlt_table,
				    Header_Struct *xlt_hdr_array));
void show_file_context          ARGS ((CONST File_Info *file,
                                    CONST char *file_text));
char *vstrchr                   ARGS ((CONST char *str,
                                    CONST int ch));
int vstricmp                    ARGS ((CONST char *str1,
                                    CONST char *str2));
int vstrncmp                    ARGS ((CONST char *str1,
                                    CONST char *str2,
                                    CONST int max_chars));
int vstrnicmp                   ARGS ((CONST char *str1,
                                    CONST char *str2,
                                    CONST int max_chars));
char *vstrrchr                  ARGS ((CONST char *str,
                                    CONST int ch));
char *vstrrstr                  ARGS ((CONST char *str,
                                    CONST char *search_str));
char *vstrstr                   ARGS ((CONST char *str,
                                    CONST char *search_str));
char *vv_timestamp              ARGS ((TIME_T time_val));
char *vstrdup                   ARGS ((CONST char *str));
char *vstrtrws                  ARGS ((char *str));
