/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.cli;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.api.records.NodeAttributeInfo;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.client.cli.YarnCLI;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.nodelabels.CommonNodeLabelsManager;

@InterfaceAudience.Private
public class ClusterCLI
extends YarnCLI {
    private static final String TITLE = "yarn cluster";
    public static final String LIST_LABELS_CMD = "list-node-labels";
    public static final String DIRECTLY_ACCESS_NODE_LABEL_STORE = "directly-access-node-label-store";
    public static final String LIST_CLUSTER_ATTRIBUTES = "list-node-attributes";
    public static final String CMD = "cluster";
    private boolean accessLocal = false;
    static CommonNodeLabelsManager localNodeLabelsManager = null;

    public static void main(String[] args) throws Exception {
        ClusterCLI cli = new ClusterCLI();
        cli.setSysOutPrintStream(System.out);
        cli.setSysErrPrintStream(System.err);
        int res = ToolRunner.run(cli, args);
        cli.stop();
        System.exit(res);
    }

    @Override
    public int run(String[] args) throws Exception {
        Options opts = new Options();
        opts.addOption("lnl", LIST_LABELS_CMD, false, "List cluster node-label collection");
        opts.addOption("lna", LIST_CLUSTER_ATTRIBUTES, false, "List cluster node-attribute collection");
        opts.addOption("h", "help", false, "Displays help for all commands.");
        opts.addOption("dnl", DIRECTLY_ACCESS_NODE_LABEL_STORE, false, "This is DEPRECATED, will be removed in future releases. Directly access node label store, with this option, all node label related operations will NOT connect RM. Instead, they will access/modify stored node labels directly. By default, it is false (access via RM). AND PLEASE NOTE: if you configured yarn.node-labels.fs-store.root-dir to a local directory (instead of NFS or HDFS), this option will only work when the command run on the machine where RM is running. Also, this option is UNSTABLE, could be removed in future releases.");
        int exitCode = -1;
        CommandLine parsedCli = null;
        try {
            parsedCli = new GnuParser().parse(opts, args);
        }
        catch (MissingArgumentException ex) {
            this.sysout.println("Missing argument for options");
            this.printUsage(opts);
            return exitCode;
        }
        this.createAndStartYarnClient();
        if (parsedCli.hasOption(DIRECTLY_ACCESS_NODE_LABEL_STORE)) {
            this.accessLocal = true;
        }
        if (parsedCli.hasOption(LIST_LABELS_CMD)) {
            this.printClusterNodeLabels();
        } else if (parsedCli.hasOption(LIST_CLUSTER_ATTRIBUTES)) {
            this.printClusterNodeAttributes();
        } else {
            if (parsedCli.hasOption("help")) {
                this.printUsage(opts);
                return 0;
            }
            this.syserr.println("Invalid Command Usage : ");
            this.printUsage(opts);
        }
        return 0;
    }

    private void printClusterNodeAttributes() throws IOException, YarnException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)baos, Charset.forName("UTF-8")));
        for (NodeAttributeInfo attribute : this.client.getClusterAttributes()) {
            pw.println(attribute.toString());
        }
        pw.close();
        this.sysout.println(baos.toString("UTF-8"));
    }

    void printClusterNodeLabels() throws YarnException, IOException {
        ArrayList<NodeLabel> nodeLabels = null;
        nodeLabels = this.accessLocal ? new ArrayList<NodeLabel>(ClusterCLI.getNodeLabelManagerInstance(this.getConf()).getClusterNodeLabels()) : new ArrayList<NodeLabel>(this.client.getClusterNodeLabels());
        this.sysout.println(String.format("Node Labels: %s", StringUtils.join(nodeLabels.iterator(), ",")));
    }

    @VisibleForTesting
    static synchronized CommonNodeLabelsManager getNodeLabelManagerInstance(Configuration conf) {
        if (localNodeLabelsManager == null) {
            localNodeLabelsManager = new CommonNodeLabelsManager();
            localNodeLabelsManager.init(conf);
            localNodeLabelsManager.start();
        }
        return localNodeLabelsManager;
    }

    @VisibleForTesting
    void printUsage(Options opts) throws UnsupportedEncodingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)baos, Charset.forName("UTF-8")));
        new HelpFormatter().printHelp(pw, 74, TITLE, null, opts, 1, 3, null);
        pw.close();
        this.sysout.println(baos.toString("UTF-8"));
    }
}

