/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;

public interface Source {
    public String getName();

    public InputStream read() throws IOException;

    public static class StdInSource
    extends InputStreamSource {
        public StdInSource() {
            this(System.in);
        }

        public StdInSource(InputStream in) {
            super(in, false, null);
        }
    }

    public static class InputStreamSource
    implements Source {
        final InputStream in;
        final String name;

        public InputStreamSource(InputStream in, boolean close, String name) {
            Objects.requireNonNull(in);
            this.in = close ? in : new FilterInputStream(in){

                @Override
                public void close() throws IOException {
                }
            };
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public InputStream read() throws IOException {
            return this.in;
        }
    }

    public static class PathSource
    implements Source {
        final Path path;
        final String name;

        public PathSource(File file, String name) {
            this(Objects.requireNonNull(file).toPath(), name);
        }

        public PathSource(Path path, String name) {
            this.path = Objects.requireNonNull(path);
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public InputStream read() throws IOException {
            return Files.newInputStream(this.path, new OpenOption[0]);
        }
    }

    public static class URLSource
    implements Source {
        final URL url;
        final String name;

        public URLSource(URL url, String name) {
            this.url = Objects.requireNonNull(url);
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public InputStream read() throws IOException {
            return this.url.openStream();
        }
    }
}

