/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.IOException;
import java.io.Writer;
import org.jibx.runtime.ICharacterEscaper;

public class USASCIIEscaper
implements ICharacterEscaper {
    private static final USASCIIEscaper s_instance = new USASCIIEscaper();

    private USASCIIEscaper() {
    }

    @Override
    public void writeAttribute(String text, Writer writer) throws IOException {
        int chr;
        int mark = 0;
        for (int i = 0; i < text.length(); i += Character.charCount(chr)) {
            chr = text.codePointAt(i);
            if (chr == 34) {
                writer.write(text, mark, i - mark);
                mark = i + 1;
                writer.write("&quot;");
                continue;
            }
            if (chr == 38) {
                writer.write(text, mark, i - mark);
                mark = i + 1;
                writer.write("&amp;");
                continue;
            }
            if (chr == 60) {
                writer.write(text, mark, i - mark);
                mark = i + 1;
                writer.write("&lt;");
                continue;
            }
            if (chr == 62 && i > 2 && text.charAt(i - 1) == ']' && text.charAt(i - 2) == ']') {
                writer.write(text, mark, i - mark - 2);
                mark = i + 1;
                writer.write("]]&gt;");
                continue;
            }
            if (chr < 32) {
                if (chr == 9 || chr == 10 || chr == 13) continue;
                throw new IOException("Illegal character code 0x" + Integer.toHexString(chr) + " in attribute value text");
            }
            if (chr <= 127) continue;
            writer.write(text, mark, i - mark);
            mark = i + Character.charCount(chr);
            if (chr > 55295 && (chr < 57344 || chr == 65534 || chr == 65535 || chr > 0x10FFFF)) {
                throw new IOException("Illegal character code 0x" + Integer.toHexString(chr) + " in attribute value text");
            }
            writer.write("&#x");
            writer.write(Integer.toHexString(chr));
            writer.write(59);
        }
        writer.write(text, mark, text.length() - mark);
    }

    @Override
    public void writeContent(String text, Writer writer) throws IOException {
        int chr;
        int mark = 0;
        for (int i = 0; i < text.length(); i += Character.charCount(chr)) {
            chr = text.codePointAt(i);
            if (chr == 38) {
                writer.write(text, mark, i - mark);
                mark = i + 1;
                writer.write("&amp;");
                continue;
            }
            if (chr == 60) {
                writer.write(text, mark, i - mark);
                mark = i + 1;
                writer.write("&lt;");
                continue;
            }
            if (chr == 62 && i > 2 && text.charAt(i - 1) == ']' && text.charAt(i - 2) == ']') {
                writer.write(text, mark, i - mark - 2);
                mark = i + 1;
                writer.write("]]&gt;");
                continue;
            }
            if (chr < 32) {
                if (chr == 9 || chr == 10 || chr == 13) continue;
                throw new IOException("Illegal character code 0x" + Integer.toHexString(chr) + " in content text");
            }
            if (chr <= 127) continue;
            writer.write(text, mark, i - mark);
            mark = i + Character.charCount(chr);
            if (chr > 55295 && (chr < 57344 || chr == 65534 || chr == 65535 || chr > 0x10FFFF)) {
                throw new IOException("Illegal character code 0x" + Integer.toHexString(chr) + " in content text");
            }
            writer.write("&#x");
            writer.write(Integer.toHexString(chr));
            writer.write(59);
        }
        writer.write(text, mark, text.length() - mark);
    }

    @Override
    public void writeCData(String text, Writer writer) throws IOException {
        int chr;
        writer.write("<![CDATA[");
        for (int i = 0; i < text.length(); i += Character.charCount(chr)) {
            chr = text.codePointAt(i);
            if (chr == 62 && i > 2 && text.charAt(i - 1) == ']' && text.charAt(i - 2) == ']') {
                throw new IOException("Sequence \"]]>\" is not allowed within CDATA section text");
            }
            if (chr < 32) {
                if (chr == 9 || chr == 10 || chr == 13) continue;
                throw new IOException("Illegal character code 0x" + Integer.toHexString(chr) + " in CDATA section");
            }
            if (chr < 128) continue;
            throw new IOException("Character code 0x" + Integer.toHexString(chr) + " not supported by encoding in CDATA section");
        }
        writer.write(text);
        writer.write("]]>");
    }

    public static ICharacterEscaper getInstance() {
        return s_instance;
    }
}

