/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos.utils.substrate.impl;

import aQute.bnd.annotation.spi.ServiceProvider;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.felix.atomos.utils.substrate.api.NativeImageArgumentsBuilder;
import org.apache.felix.atomos.utils.substrate.api.dynproxy.DynamicProxyConfiguration;
import org.apache.felix.atomos.utils.substrate.api.reflect.ReflectionConfiguration;
import org.apache.felix.atomos.utils.substrate.api.resource.ResourceConfiguration;
import org.apache.felix.atomos.utils.substrate.impl.BaseNativeImageArguments;
import org.apache.felix.atomos.utils.substrate.impl.NativeImageArgumentsImpl;
import org.apache.felix.atomos.utils.substrate.impl.json.DynamicProxyJsonUtil;
import org.apache.felix.atomos.utils.substrate.impl.json.ReflectJsonUtil;
import org.apache.felix.atomos.utils.substrate.impl.json.ResourceJsonUtil;

@ServiceProvider(value=NativeImageArgumentsBuilder.class)
public class NativeImageArgumentsBuilderImpl
implements NativeImageArgumentsBuilder {
    private final NativeImageArgumentsImpl a = new NativeImageArgumentsImpl();

    public NativeImageArgumentsBuilder allowIncompleteClasspath(boolean allowIncompleteClasspath) {
        this.a.allowIncompleteClasspath = allowIncompleteClasspath;
        return this;
    }

    public BaseNativeImageArguments build() {
        return this.a;
    }

    public NativeImageArgumentsBuilder classPathFile(Optional<Path> classPathFile) {
        classPathFile.ifPresent(this.a.classPathFiles::add);
        return this;
    }

    public NativeImageArgumentsBuilder classPathFiles(Optional<List<Path>> classPathFiles) {
        classPathFiles.ifPresent(this.a.classPathFiles::addAll);
        return this;
    }

    public NativeImageArgumentsBuilder debugAttach(boolean debugAttach) {
        this.a.debugAttach = debugAttach;
        return this;
    }

    public NativeImageArgumentsBuilder dynamicProxyConfiguration(Optional<DynamicProxyConfiguration> dynamicProxyConfiguration) {
        dynamicProxyConfiguration.ifPresent(this::processDynamicProxyConfiguration);
        return this;
    }

    public NativeImageArgumentsBuilder dynamicProxyConfigurationFile(Optional<Path> dynamicProxyConfigurationFile) {
        dynamicProxyConfigurationFile.ifPresent(this.a.dynamicProxyConfigurationFiles::add);
        return this;
    }

    public NativeImageArgumentsBuilder dynamicProxyConfigurationFiles(Optional<List<Path>> dynamicProxyConfigurationFiles) {
        dynamicProxyConfigurationFiles.ifPresent(this.a.dynamicProxyConfigurationFiles::addAll);
        return this;
    }

    public NativeImageArgumentsBuilder dynamicProxyConfigurations(Optional<List<DynamicProxyConfiguration>> dynamicProxyConfigurations) {
        dynamicProxyConfigurations.ifPresent(list -> list.forEach(this::processDynamicProxyConfiguration));
        return this;
    }

    public NativeImageArgumentsBuilder imageName(String imageName) {
        this.a.imageName = imageName;
        return this;
    }

    public NativeImageArgumentsBuilder initializeAtBuildTimePackage(Optional<String> initializeAtBuildTimePackage) {
        initializeAtBuildTimePackage.ifPresent(this.a.initializeAtBuildTime::add);
        return this;
    }

    public NativeImageArgumentsBuilder initializeAtBuildTimePackages(Optional<List<String>> initializeAtBuildTimePackages) {
        initializeAtBuildTimePackages.ifPresent(this.a.initializeAtBuildTime::addAll);
        return this;
    }

    public NativeImageArgumentsBuilder mainClass(String mainClass) {
        this.a.mainClass = mainClass;
        return this;
    }

    public NativeImageArgumentsBuilder noFallback(boolean noFallback) {
        this.a.noFallback = noFallback;
        return this;
    }

    private void processDynamicProxyConfiguration(DynamicProxyConfiguration dynamicProxyConfiguration) {
        Path p = this.write("dynamicProxyConfiguration", DynamicProxyJsonUtil.json(dynamicProxyConfiguration));
        this.dynamicProxyConfigurationFile(Optional.of(p));
    }

    private void processReflectConfiguration(ReflectionConfiguration reflectConfiguration) {
        Path p = this.write("reflectConfiguration", ReflectJsonUtil.json(reflectConfiguration));
        this.reflectionConfigurationFile(Optional.of(p));
    }

    private void processResourceConfiguration(ResourceConfiguration resourceConfiguration) {
        Path p = this.write("resourceConfiguration", ResourceJsonUtil.json(resourceConfiguration));
        this.resourceConfigurationFile(Optional.of(p));
    }

    public NativeImageArgumentsBuilder reflectionConfiguration(Optional<ReflectionConfiguration> reflectionConfiguration) {
        reflectionConfiguration.ifPresent(this::processReflectConfiguration);
        return this;
    }

    public NativeImageArgumentsBuilder reflectionConfigurationFile(Optional<Path> reflectionConfigurationFile) {
        reflectionConfigurationFile.ifPresent(this.a.reflectionConfigurationFiles::add);
        return this;
    }

    public NativeImageArgumentsBuilder reflectionConfigurationFiles(Optional<List<Path>> reflectionConfigurationFiles) {
        reflectionConfigurationFiles.ifPresent(this.a.reflectionConfigurationFiles::addAll);
        return this;
    }

    public NativeImageArgumentsBuilder reflectionConfigurations(Optional<List<ReflectionConfiguration>> reflectConfiguration) {
        reflectConfiguration.ifPresent(list -> list.forEach(this::processReflectConfiguration));
        return this;
    }

    public NativeImageArgumentsBuilder reportExceptionStackTraces(boolean reportExceptionStackTraces) {
        this.a.reportExceptionStackTraces = reportExceptionStackTraces;
        return this;
    }

    public NativeImageArgumentsBuilder reportUnsupportedElementsAtRuntime(boolean reportUnsupportedElementsAtRuntime) {
        this.a.reportUnsupportedElementsAtRuntime = reportUnsupportedElementsAtRuntime;
        return this;
    }

    public NativeImageArgumentsBuilder resourceConfiguration(Optional<ResourceConfiguration> resourceConfiguration) {
        resourceConfiguration.ifPresent(this::processResourceConfiguration);
        return this;
    }

    public NativeImageArgumentsBuilder resourceConfigurationFile(Optional<Path> resourceConfigurationFile) {
        resourceConfigurationFile.ifPresent(this.a.resourceConfigurationFiles::add);
        return this;
    }

    public NativeImageArgumentsBuilder resourceConfigurationFiles(Optional<List<Path>> resourceConfigurationFiles) {
        resourceConfigurationFiles.ifPresent(this.a.resourceConfigurationFiles::addAll);
        return this;
    }

    public NativeImageArgumentsBuilder resourceConfigurations(Optional<List<ResourceConfiguration>> resourceConfigurations) {
        resourceConfigurations.ifPresent(list -> list.forEach(this::processResourceConfiguration));
        return this;
    }

    public NativeImageArgumentsBuilder traceClassInitialization(boolean traceClassInitialization) {
        this.a.traceClassInitialization = traceClassInitialization;
        return this;
    }

    public NativeImageArgumentsBuilder vmFlag(Optional<String> vmFlag) {
        vmFlag.ifPresent(this.a.vmFlags::add);
        return this;
    }

    public NativeImageArgumentsBuilder vmFlags(Optional<List<String>> vmFlags) {
        vmFlags.ifPresent(this.a.vmFlags::addAll);
        return this;
    }

    public NativeImageArgumentsBuilder vmSystemProperties(Optional<Map<String, String>> vmSystemProperties) {
        vmSystemProperties.ifPresent(this.a.vmSystemProperties::putAll);
        return this;
    }

    public NativeImageArgumentsBuilder vmSystemProperty(String key, String value) {
        this.a.vmSystemProperties.put(key, value);
        return this;
    }

    private Path write(String prefix, String json) {
        try {
            return Files.createTempFile(prefix, "json", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public NativeImageArgumentsBuilder printClassInitialization(boolean printClassInitialization) {
        this.a.printClassInitialization = printClassInitialization;
        return this;
    }
}

