/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.io;

import flex2.compiler.io.VirtualFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public final class FileUtil {
    public static final boolean caseInsensitive = System.getProperty("os.name").toLowerCase().startsWith("windows") || System.getProperty("os.name").toLowerCase().startsWith("mac");

    public static File openFile(String path) {
        try {
            return new File(path);
        }
        catch (Error e) {
            return null;
        }
    }

    public static File openFile(String path, boolean mkdir) {
        File f = new File(path).getAbsoluteFile();
        if (mkdir) {
            new File(f.getParent()).mkdirs();
        }
        return f;
    }

    public static File openFile(File parentPath, String fileName) {
        try {
            return new File(parentPath, fileName);
        }
        catch (Error e) {
            return null;
        }
    }

    public static File createTempFile(InputStream in) throws IOException {
        File temp = File.createTempFile("Flex2_", "");
        FileUtil.writeBinaryFile(temp, in);
        return temp;
    }

    public static InputStream openStream(File file) throws FileNotFoundException, IOException {
        return FileUtil.openStream(file.getAbsolutePath());
    }

    public static InputStream openStream(String path) throws FileNotFoundException, IOException {
        return FileUtil.openStream(new FileInputStream(path));
    }

    public static InputStream openStream(InputStream in) throws IOException {
        byte[] bom = new byte[3];
        in.read(bom, 0, 3);
        if (bom[0] == 239 && bom[1] == 187 && bom[2] == 191) {
            return in;
        }
        return new BOMInputStream(bom, in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBinaryFile(File file, InputStream in) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        in = new BufferedInputStream(in);
        try {
            FileUtil.streamOutput(in, out);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ((OutputStream)out).close();
            throw throwable;
        }
        ((OutputStream)out).close();
    }

    public static void streamOutput(InputStream in, OutputStream out) throws IOException {
        int len = 8192;
        byte[] bytes = new byte[len];
        while ((len = in.read(bytes, 0, len)) != -1) {
            out.write(bytes, 0, len);
        }
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String fileName, String output) throws FileNotFoundException, IOException {
        File file = FileUtil.openFile(fileName);
        if (file == null) {
            throw new FileNotFoundException(fileName);
        }
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
        try {
            out.write(output);
            ((Writer)out).flush();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((Writer)out).close();
            throw throwable;
        }
        ((Writer)out).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBinaryFile(String fileName, byte[] output) throws FileNotFoundException, IOException {
        File file = FileUtil.openFile(fileName);
        if (file == null) {
            throw new FileNotFoundException(fileName);
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        try {
            ((OutputStream)out).write(output);
            ((OutputStream)out).flush();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((OutputStream)out).close();
            throw throwable;
        }
        ((OutputStream)out).close();
    }

    public static String getCanonicalPath(String path) {
        File f = FileUtil.openFile(path);
        return f == null ? null : FileUtil.getCanonicalPath(f);
    }

    public static String getCanonicalPath(File f) {
        try {
            return f.getCanonicalPath();
        }
        catch (IOException ex) {
            return f.getAbsolutePath();
        }
    }

    public static File getCanonicalFile(File f) {
        try {
            return f.getCanonicalFile();
        }
        catch (IOException ex) {
            return f.getAbsoluteFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String readFile(File f) {
        String string;
        BufferedReader file;
        block12: {
            file = null;
            StringBuilder buffer = new StringBuilder((int)f.length());
            String lineSep = System.getProperty("line.separator");
            file = new BufferedReader(new InputStreamReader(FileUtil.openStream(f)));
            String s = null;
            while ((s = file.readLine()) != null) {
                buffer.append(s);
                buffer.append(lineSep);
            }
            string = buffer.toString();
            Object var7_10 = null;
            if (file == null) break block12;
            try {
                file.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string;
        catch (FileNotFoundException ex) {
            String string2;
            block13: {
                string2 = null;
                Object var7_11 = null;
                if (file == null) break block13;
                try {
                    file.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return string2;
        }
        catch (IOException ex) {
            String string3;
            block14: {
                string3 = null;
                Object var7_12 = null;
                if (file == null) break block14;
                {
                    catch (Throwable throwable) {
                        block15: {
                            Object var7_13 = null;
                            if (file == null) break block15;
                            try {
                                file.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                }
                try {
                    file.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return string3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String readLine(String f, int line) {
        String i22;
        BufferedReader file;
        block12: {
            file = null;
            file = new BufferedReader(new InputStreamReader(FileUtil.openStream(f), "UTF8"));
            for (int i22 = 0; i22 < line - 1 && file.readLine() != null; ++i22) {
            }
            i22 = file.readLine();
            Object var6_7 = null;
            if (file == null) break block12;
            try {
                file.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return i22;
        catch (FileNotFoundException ex) {
            String string;
            block13: {
                string = null;
                Object var6_8 = null;
                if (file == null) break block13;
                try {
                    file.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return string;
        }
        catch (IOException ex) {
            String string;
            block14: {
                string = null;
                Object var6_9 = null;
                if (file == null) break block14;
                {
                    catch (Throwable throwable) {
                        block15: {
                            Object var6_10 = null;
                            if (file == null) break block15;
                            try {
                                file.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                }
                try {
                    file.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readBytes(String f, int line) {
        block27: {
            block26: {
                block24: {
                    in = null;
                    baos = new ByteArrayOutputStream();
                    lastIsCR = false;
                    pos = 0;
                    ch = 0;
                    count = 0;
                    try {
                        try {
                            in = new BufferedInputStream(FileUtil.openStream(f));
                            while ((ch = in.read()) != -1) {
                                block25: {
                                    block28: {
                                        if (!lastIsCR) break block28;
                                        if (line == ++count) {
                                            var8_8 = baos.toByteArray();
                                            var11_13 = null;
                                            if (in == null) return var8_8;
                                            break block24;
                                        }
                                        baos.reset();
                                        if (ch == 10) {
                                            lastIsCR = false;
                                            break block25;
                                        } else if (ch == 13) {
                                            lastIsCR = true;
                                            break block25;
                                        } else {
                                            baos.write(ch);
                                            lastIsCR = false;
                                        }
                                        break block25;
                                    }
                                    if (ch == 10) {
                                        if (line == ++count) {
                                            var8_9 = baos.toByteArray();
                                            break block26;
                                        }
                                        baos.reset();
                                        lastIsCR = false;
                                    } else if (ch == 13) {
                                        lastIsCR = true;
                                    } else {
                                        baos.write(ch);
                                        lastIsCR = false;
                                    }
                                }
                                ++pos;
                            }
                            var8_10 = null;
                            break block27;
                        }
                        catch (FileNotFoundException ex) {
                            var9_25 = null;
                            var11_16 = null;
                            if (in == null) return var9_25;
                            try {
                                in.close();
                                return var9_25;
                            }
                            catch (IOException var12_22) {
                                // empty catch block
                            }
                            return var9_25;
                        }
                        catch (IOException ex) {
                            var9_26 = null;
                            var11_17 = null;
                            if (in == null) return var9_26;
                            ** try [egrp 2[TRYBLOCK] [12 : 224->231)] { 
lbl65:
                            // 1 sources

                            in.close();
                            return var9_26;
lbl67:
                            // 1 sources

                            catch (IOException var12_23) {
                                // empty catch block
                            }
                            return var9_26;
                        }
                    }
                    catch (Throwable var10_27) {
                        var11_18 = null;
                        if (in == null) throw var10_27;
                        try {}
                        catch (IOException var12_24) {
                            throw var10_27;
                        }
                        in.close();
                        throw var10_27;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [12 : 224->231)] { 
lbl81:
                // 1 sources

                in.close();
                return var8_8;
lbl83:
                // 1 sources

                catch (IOException var12_19) {
                    // empty catch block
                }
                return var8_8;
            }
            var11_14 = null;
            if (in == null) return var8_9;
            ** try [egrp 2[TRYBLOCK] [12 : 224->231)] { 
lbl90:
            // 1 sources

            in.close();
            return var8_9;
lbl92:
            // 1 sources

            catch (IOException var12_20) {
                // empty catch block
            }
            return var8_9;
        }
        var11_15 = null;
        if (in == null) return var8_10;
        try {}
        catch (IOException var12_21) {
            // empty catch block
            return var8_10;
        }
        in.close();
        return var8_10;
    }

    public static int isSubdirectoryOf(File pathFile, List directories) {
        String path = pathFile.toString();
        int size = directories.size();
        for (int j = 0; j < size; ++j) {
            File dirFile = FileUtil.getCanonicalFile((File)directories.get(j));
            String dir = dirFile.toString();
            if (pathFile.getParent().equals(dirFile.getParent()) || (path.length() <= dir.length() || !path.startsWith(dir)) && (dir.length() <= path.length() || !dir.startsWith(path))) continue;
            return j;
        }
        return -1;
    }

    public static int isSubdirectoryOf(String directory, VirtualFile[] directories) {
        int size;
        File pathFile = FileUtil.openFile(directory);
        String path = pathFile.toString();
        int n = size = directories == null ? 0 : directories.length;
        for (int j = 0; j < size; ++j) {
            File dirFile = FileUtil.openFile(directories[j].getName());
            String dir = dirFile.toString();
            if (pathFile.getParent().equals(dirFile.getParent()) || path.length() <= dir.length() || !path.startsWith(dir)) continue;
            return j;
        }
        return -1;
    }

    public static String getExceptionMessage(Exception ex) {
        return FileUtil.getExceptionMessage(ex, true);
    }

    public static String getExceptionMessage(Exception ex, boolean stackDump) {
        String m = ex.getMessage();
        if (m == null) {
            m = ex.getLocalizedMessage();
        }
        if (m == null) {
            m = "(" + ex.getClass().getName() + ")";
            if (stackDump) {
                StringWriter s = new StringWriter();
                PrintWriter p = new PrintWriter((Writer)s, true);
                ex.printStackTrace(p);
                m = m + s.getBuffer().toString();
            }
        }
        return m;
    }

    private static final class BOMInputStream
    extends InputStream {
        private byte[] bom;
        private final int bomSize;
        private final InputStream in;
        private int index;

        private BOMInputStream(byte[] bom, InputStream in) {
            this.bom = bom;
            this.bomSize = bom.length;
            this.in = in;
            this.index = 0;
        }

        public int read() throws IOException {
            if (this.bom == null) {
                return this.in.read();
            }
            byte c = this.bom[this.index];
            if (this.index == this.bomSize - 1) {
                this.bom = null;
            }
            ++this.index;
            return c;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int count;
            if (this.bom == null) {
                return this.in.read(b, off, len);
            }
            for (count = 0; this.index < 3 && count < len; ++count) {
                b[off + count] = this.bom[this.index++];
            }
            if (this.index == 3) {
                this.bom = null;
            }
            if (len <= count) {
                return count;
            }
            int r = this.in.read(b, off + count, len - count);
            return r == -1 ? -1 : r + count;
        }

        public long skip(long n) throws IOException {
            throw new UnsupportedOperationException("supports read() and close() only...");
        }

        public int available() throws IOException {
            int num = this.in.available();
            if (this.bom == null) {
                return num;
            }
            return this.bomSize - this.index + num;
        }

        public void close() throws IOException {
            this.in.close();
        }

        public synchronized void mark(int readlimit) {
            throw new UnsupportedOperationException("supports read() and close() only...");
        }

        public synchronized void reset() throws IOException {
            throw new UnsupportedOperationException("supports read() and close() only...");
        }

        public boolean markSupported() {
            return false;
        }
    }
}

