/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.forks.velocity.runtime.directive;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.apache.flex.forks.velocity.context.InternalContextAdapter;
import org.apache.flex.forks.velocity.exception.MethodInvocationException;
import org.apache.flex.forks.velocity.exception.ParseErrorException;
import org.apache.flex.forks.velocity.exception.ResourceNotFoundException;
import org.apache.flex.forks.velocity.runtime.RuntimeServices;
import org.apache.flex.forks.velocity.runtime.directive.Directive;
import org.apache.flex.forks.velocity.runtime.parser.node.Node;
import org.apache.flex.forks.velocity.util.introspection.Info;

public class Foreach
extends Directive {
    private String counterName;
    private int counterInitialValue;
    private String elementKey;
    protected Info uberInfo;

    public String getName() {
        return "foreach";
    }

    public int getType() {
        return 1;
    }

    public void init(RuntimeServices rs, InternalContextAdapter context, Node node) throws Exception {
        super.init(rs, context, node);
        if (this.counterName != null) {
            return;
        }
        this.counterName = this.rsvc.getString("directive.foreach.counter.name");
        this.counterInitialValue = this.rsvc.getInt("directive.foreach.counter.initial.value");
        this.elementKey = node.jjtGetChild(0).getFirstTokenImage().substring(1);
        this.uberInfo = new Info(context.getCurrentTemplateName(), this.getLine(), this.getColumn());
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException, MethodInvocationException, ResourceNotFoundException, ParseErrorException {
        Object listObject = node.jjtGetChild(2).value(context);
        if (listObject == null) {
            return false;
        }
        Iterator i = null;
        try {
            i = this.rsvc.getUberspect().getIterator(listObject, this.uberInfo);
        }
        catch (Exception ee) {
            System.out.println(ee);
        }
        if (i == null) {
            return false;
        }
        int counter = this.counterInitialValue;
        Object o = context.get(this.elementKey);
        Object ctr = context.get(this.counterName);
        while (i.hasNext()) {
            context.put(this.counterName, new Integer(counter));
            context.put(this.elementKey, i.next());
            node.jjtGetChild(3).render(context, writer);
            ++counter;
        }
        if (ctr != null) {
            context.put(this.counterName, ctr);
        } else {
            context.remove(this.counterName);
        }
        if (o != null) {
            context.put(this.elementKey, o);
        } else {
            context.remove(this.elementKey);
        }
        return true;
    }
}

