/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom.strokes;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.dom.FXGNode;
import com.adobe.fxg.util.FXGLog;
import com.adobe.internal.fxg.dom.DOMParserHelper;
import com.adobe.internal.fxg.dom.GradientEntryNode;
import com.adobe.internal.fxg.dom.ScalableGradientNode;
import com.adobe.internal.fxg.dom.strokes.AbstractStrokeNode;
import com.adobe.internal.fxg.dom.transforms.MatrixNode;
import com.adobe.internal.fxg.dom.types.InterpolationMethod;
import com.adobe.internal.fxg.dom.types.SpreadMethod;
import java.util.ArrayList;
import java.util.List;

public class RadialGradientStrokeNode
extends AbstractStrokeNode
implements ScalableGradientNode {
    private static final double FOCAL_MIN_INCLUSIVE = -1.0;
    private static final double FOCAL_MAX_INCLUSIVE = 1.0;
    public double x = Double.NaN;
    public double y = Double.NaN;
    public double scaleX = Double.NaN;
    public double scaleY = Double.NaN;
    public double rotation = 0.0;
    public SpreadMethod spreadMethod = SpreadMethod.PAD;
    public InterpolationMethod interpolationMethod = InterpolationMethod.RGB;
    public double focalPointRatio = 0.0;
    private boolean translateSet;
    private boolean scaleSet;
    private boolean rotationSet;
    public MatrixNode matrix;
    public List<GradientEntryNode> entries;

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public double getRotation() {
        return this.rotation;
    }

    public MatrixNode getMatrixNode() {
        return this.matrix;
    }

    public boolean isLinear() {
        return false;
    }

    public void addChild(FXGNode child) {
        if (child instanceof MatrixNode) {
            if (this.translateSet || this.scaleSet || this.rotationSet) {
                throw new FXGException(child.getStartLine(), child.getStartColumn(), "InvalidChildMatrixNode", new Object[0]);
            }
            this.matrix = (MatrixNode)child;
        } else if (child instanceof GradientEntryNode) {
            if (this.entries == null) {
                this.entries = new ArrayList<GradientEntryNode>(4);
            } else if (this.entries.size() >= 15) {
                FXGLog.getLogger().log(30000, "InvalidRadialGradientStrokeNumElements", null, this.getDocumentName(), this.startLine, this.startColumn);
                return;
            }
            this.entries.add((GradientEntryNode)child);
        } else {
            super.addChild(child);
        }
    }

    public String getNodeName() {
        return "RadialGradientStroke";
    }

    public void setAttribute(String name, String value) {
        if ("x".equals(name)) {
            this.x = DOMParserHelper.parseDouble(this, value, name);
            this.translateSet = true;
        } else if ("y".equals(name)) {
            this.y = DOMParserHelper.parseDouble(this, value, name);
            this.translateSet = true;
        } else if ("rotation".equals(name)) {
            this.rotation = DOMParserHelper.parseDouble(this, value, name);
            this.rotationSet = true;
        } else if ("scaleX".equals(name)) {
            this.scaleX = DOMParserHelper.parseDouble(this, value, name);
            this.scaleSet = true;
        } else if ("scaleY".equals(name)) {
            this.scaleY = DOMParserHelper.parseDouble(this, value, name);
            this.scaleSet = true;
        } else if ("spreadMethod".equals(name)) {
            this.spreadMethod = DOMParserHelper.parseSpreadMethod(this, value, name, this.spreadMethod);
        } else if ("interpolationMethod".equals(name)) {
            this.interpolationMethod = DOMParserHelper.parseInterpolationMethod(this, value, name, this.interpolationMethod);
        } else if ("focalPointRatio".equals(name)) {
            this.focalPointRatio = DOMParserHelper.parseDouble(this, value, name, -1.0, 1.0, this.focalPointRatio);
        } else {
            super.setAttribute(name, value);
        }
    }
}

