/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DayTimeIntervalType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.NullType;
import org.apache.flink.table.types.logical.RawType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.UnresolvedUserDefinedType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.YearMonthIntervalType;
import org.apache.flink.table.types.logical.ZonedTimestampType;
import org.apache.flink.table.utils.TypeStringUtils;

@PublicEvolving
public final class LogicalTypeParser {
    private static final char CHAR_BEGIN_SUBTYPE = '<';
    private static final char CHAR_END_SUBTYPE = '>';
    private static final char CHAR_BEGIN_PARAMETER = '(';
    private static final char CHAR_END_PARAMETER = ')';
    private static final char CHAR_LIST_SEPARATOR = ',';
    private static final char CHAR_STRING = '\'';
    private static final char CHAR_IDENTIFIER = '`';
    private static final char CHAR_DOT = '.';
    private static final Set<String> KEYWORDS = Stream.of(Keyword.values()).map(k -> k.toString().toUpperCase()).collect(Collectors.toSet());

    public static LogicalType parse(String typeString, ClassLoader classLoader) {
        List<Token> tokens = LogicalTypeParser.tokenize(typeString);
        TokenParser converter = new TokenParser(typeString, tokens, classLoader);
        return converter.parseTokens();
    }

    @Deprecated
    public static LogicalType parse(String typeString) {
        return LogicalTypeParser.parse(typeString, Thread.currentThread().getContextClassLoader());
    }

    private static boolean isDelimiter(char character) {
        return Character.isWhitespace(character) || character == '<' || character == '>' || character == '(' || character == ')' || character == ',' || character == '.';
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static List<Token> tokenize(String chars) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        StringBuilder builder = new StringBuilder();
        block10: for (int cursor = 0; cursor < chars.length(); ++cursor) {
            char curChar = chars.charAt(cursor);
            switch (curChar) {
                case '<': {
                    tokens.add(new Token(TokenType.BEGIN_SUBTYPE, cursor, Character.toString('<')));
                    continue block10;
                }
                case '>': {
                    tokens.add(new Token(TokenType.END_SUBTYPE, cursor, Character.toString('>')));
                    continue block10;
                }
                case '(': {
                    tokens.add(new Token(TokenType.BEGIN_PARAMETER, cursor, Character.toString('(')));
                    continue block10;
                }
                case ')': {
                    tokens.add(new Token(TokenType.END_PARAMETER, cursor, Character.toString(')')));
                    continue block10;
                }
                case ',': {
                    tokens.add(new Token(TokenType.LIST_SEPARATOR, cursor, Character.toString(',')));
                    continue block10;
                }
                case '.': {
                    tokens.add(new Token(TokenType.IDENTIFIER_SEPARATOR, cursor, Character.toString('.')));
                    continue block10;
                }
                case '\'': {
                    builder.setLength(0);
                    cursor = LogicalTypeParser.consumeEscaped(builder, chars, cursor, '\'');
                    tokens.add(new Token(TokenType.LITERAL_STRING, cursor, builder.toString()));
                    continue block10;
                }
                case '`': {
                    builder.setLength(0);
                    cursor = LogicalTypeParser.consumeEscaped(builder, chars, cursor, '`');
                    tokens.add(new Token(TokenType.IDENTIFIER, cursor, builder.toString()));
                    continue block10;
                }
                default: {
                    if (Character.isWhitespace(curChar)) continue block10;
                    if (LogicalTypeParser.isDigit(curChar)) {
                        builder.setLength(0);
                        cursor = LogicalTypeParser.consumeInt(builder, chars, cursor);
                        tokens.add(new Token(TokenType.LITERAL_INT, cursor, builder.toString()));
                        continue block10;
                    }
                    builder.setLength(0);
                    cursor = LogicalTypeParser.consumeIdentifier(builder, chars, cursor);
                    String token = builder.toString();
                    String normalizedToken = token.toUpperCase();
                    if (KEYWORDS.contains(normalizedToken)) {
                        tokens.add(new Token(TokenType.KEYWORD, cursor, normalizedToken));
                        continue block10;
                    }
                    tokens.add(new Token(TokenType.IDENTIFIER, cursor, token));
                }
            }
        }
        return tokens;
    }

    private static int consumeEscaped(StringBuilder builder, String chars, int cursor, char delimiter) {
        ++cursor;
        while (chars.length() > cursor) {
            char curChar = chars.charAt(cursor);
            if (curChar == delimiter && cursor + 1 < chars.length() && chars.charAt(cursor + 1) == delimiter) {
                ++cursor;
                builder.append(curChar);
            } else {
                if (curChar == delimiter) break;
                builder.append(curChar);
            }
            ++cursor;
        }
        return cursor;
    }

    private static int consumeInt(StringBuilder builder, String chars, int cursor) {
        while (chars.length() > cursor && LogicalTypeParser.isDigit(chars.charAt(cursor))) {
            builder.append(chars.charAt(cursor));
            ++cursor;
        }
        return cursor - 1;
    }

    private static int consumeIdentifier(StringBuilder builder, String chars, int cursor) {
        while (cursor < chars.length() && !LogicalTypeParser.isDelimiter(chars.charAt(cursor))) {
            builder.append(chars.charAt(cursor));
            ++cursor;
        }
        return cursor - 1;
    }

    private static class TokenParser {
        private final String inputString;
        private final List<Token> tokens;
        private final ClassLoader classLoader;
        private int lastValidToken;
        private int currentToken;

        public TokenParser(String inputString, List<Token> tokens, ClassLoader classLoader) {
            this.inputString = inputString;
            this.tokens = tokens;
            this.classLoader = classLoader;
            this.lastValidToken = -1;
            this.currentToken = -1;
        }

        private LogicalType parseTokens() {
            LogicalType type = this.parseTypeWithNullability();
            if (this.hasRemainingTokens()) {
                this.nextToken();
                throw this.parsingError("Unexpected token: " + this.token().value);
            }
            return type;
        }

        private int lastCursor() {
            if (this.lastValidToken < 0) {
                return 0;
            }
            return this.tokens.get((int)this.lastValidToken).cursorPosition + 1;
        }

        private ValidationException parsingError(String cause, @Nullable Throwable t) {
            return new ValidationException(String.format("Could not parse type at position %d: %s\n Input type string: %s", this.lastCursor(), cause, this.inputString), t);
        }

        private ValidationException parsingError(String cause) {
            return this.parsingError(cause, null);
        }

        private boolean hasRemainingTokens() {
            return this.currentToken + 1 < this.tokens.size();
        }

        private Token token() {
            return this.tokens.get(this.currentToken);
        }

        private int tokenAsInt() {
            try {
                return Integer.parseInt(this.token().value);
            }
            catch (NumberFormatException e) {
                throw this.parsingError("Invalid integer value.", e);
            }
        }

        private Keyword tokenAsKeyword() {
            return Keyword.valueOf(this.token().value);
        }

        private String tokenAsString() {
            return this.token().value;
        }

        private void nextToken() {
            ++this.currentToken;
            if (this.currentToken >= this.tokens.size()) {
                throw this.parsingError("Unexpected end.");
            }
            this.lastValidToken = this.currentToken - 1;
        }

        private void nextToken(TokenType type) {
            this.nextToken();
            Token token = this.token();
            if (token.type != type) {
                throw this.parsingError("<" + type.name() + "> expected but was <" + (Object)((Object)token.type) + ">.");
            }
        }

        private void nextToken(Keyword keyword) {
            this.nextToken(TokenType.KEYWORD);
            Token token = this.token();
            if (!keyword.equals((Object)Keyword.valueOf(token.value))) {
                throw this.parsingError("Keyword '" + (Object)((Object)keyword) + "' expected but was '" + token.value + "'.");
            }
        }

        private boolean hasNextToken(TokenType ... types) {
            if (this.currentToken + types.length + 1 > this.tokens.size()) {
                return false;
            }
            for (int i = 0; i < types.length; ++i) {
                Token lookAhead = this.tokens.get(this.currentToken + i + 1);
                if (lookAhead.type == types[i]) continue;
                return false;
            }
            return true;
        }

        private boolean hasNextToken(Keyword ... keywords) {
            if (this.currentToken + keywords.length + 1 > this.tokens.size()) {
                return false;
            }
            for (int i = 0; i < keywords.length; ++i) {
                Token lookAhead = this.tokens.get(this.currentToken + i + 1);
                if (lookAhead.type == TokenType.KEYWORD && keywords[i] == Keyword.valueOf(lookAhead.value)) continue;
                return false;
            }
            return true;
        }

        private boolean parseNullability() {
            if (this.hasNextToken(Keyword.NOT, Keyword.NULL)) {
                this.nextToken(Keyword.NOT);
                this.nextToken(Keyword.NULL);
                return false;
            }
            if (this.hasNextToken(Keyword.NULL)) {
                this.nextToken(Keyword.NULL);
                return true;
            }
            return true;
        }

        private LogicalType parseTypeWithNullability() {
            LogicalType logicalType = this.hasNextToken(TokenType.IDENTIFIER) ? this.parseTypeByIdentifier().copy(this.parseNullability()) : this.parseTypeByKeyword().copy(this.parseNullability());
            if (this.hasNextToken(Keyword.ARRAY)) {
                this.nextToken(Keyword.ARRAY);
                return new ArrayType(logicalType).copy(this.parseNullability());
            }
            if (this.hasNextToken(Keyword.MULTISET)) {
                this.nextToken(Keyword.MULTISET);
                return new MultisetType(logicalType).copy(this.parseNullability());
            }
            return logicalType;
        }

        private LogicalType parseTypeByKeyword() {
            this.nextToken(TokenType.KEYWORD);
            switch (this.tokenAsKeyword()) {
                case CHAR: {
                    return this.parseCharType();
                }
                case VARCHAR: {
                    return this.parseVarCharType();
                }
                case STRING: {
                    return VarCharType.STRING_TYPE;
                }
                case BOOLEAN: {
                    return new BooleanType();
                }
                case BINARY: {
                    return this.parseBinaryType();
                }
                case VARBINARY: {
                    return this.parseVarBinaryType();
                }
                case BYTES: {
                    return new VarBinaryType(Integer.MAX_VALUE);
                }
                case DECIMAL: 
                case NUMERIC: 
                case DEC: {
                    return this.parseDecimalType();
                }
                case TINYINT: {
                    return new TinyIntType();
                }
                case SMALLINT: {
                    return new SmallIntType();
                }
                case INT: 
                case INTEGER: {
                    return new IntType();
                }
                case BIGINT: {
                    return new BigIntType();
                }
                case FLOAT: {
                    return new FloatType();
                }
                case DOUBLE: {
                    return this.parseDoubleType();
                }
                case DATE: {
                    return new DateType();
                }
                case TIME: {
                    return this.parseTimeType();
                }
                case TIMESTAMP: {
                    return this.parseTimestampType();
                }
                case TIMESTAMP_LTZ: {
                    return this.parseTimestampLtzType();
                }
                case INTERVAL: {
                    return this.parseIntervalType();
                }
                case ARRAY: {
                    return this.parseArrayType();
                }
                case MULTISET: {
                    return this.parseMultisetType();
                }
                case MAP: {
                    return this.parseMapType();
                }
                case ROW: {
                    return this.parseRowType();
                }
                case NULL: {
                    return new NullType();
                }
                case RAW: {
                    return this.parseRawType();
                }
                case LEGACY: {
                    return this.parseLegacyType();
                }
            }
            throw this.parsingError("Unsupported type: " + this.token().value);
        }

        private LogicalType parseTypeByIdentifier() {
            this.nextToken(TokenType.IDENTIFIER);
            ArrayList<String> parts = new ArrayList<String>();
            parts.add(this.tokenAsString());
            if (this.hasNextToken(TokenType.IDENTIFIER_SEPARATOR)) {
                this.nextToken(TokenType.IDENTIFIER_SEPARATOR);
                this.nextToken(TokenType.IDENTIFIER);
                parts.add(this.tokenAsString());
            }
            if (this.hasNextToken(TokenType.IDENTIFIER_SEPARATOR)) {
                this.nextToken(TokenType.IDENTIFIER_SEPARATOR);
                this.nextToken(TokenType.IDENTIFIER);
                parts.add(this.tokenAsString());
            }
            String[] identifierParts = (String[])Stream.of(this.lastPart(parts, 2), this.lastPart(parts, 1), this.lastPart(parts, 0)).filter(Objects::nonNull).toArray(String[]::new);
            return new UnresolvedUserDefinedType(UnresolvedIdentifier.of(identifierParts));
        }

        @Nullable
        private String lastPart(List<String> parts, int inversePos) {
            int pos = parts.size() - inversePos - 1;
            if (pos < 0) {
                return null;
            }
            return parts.get(pos);
        }

        private int parseStringType() {
            if (this.hasNextToken(TokenType.BEGIN_PARAMETER)) {
                this.nextToken(TokenType.BEGIN_PARAMETER);
                this.nextToken(TokenType.LITERAL_INT);
                int length = this.tokenAsInt();
                this.nextToken(TokenType.END_PARAMETER);
                return length;
            }
            return -1;
        }

        private LogicalType parseCharType() {
            int length = this.parseStringType();
            if (length < 0) {
                return new CharType();
            }
            return new CharType(length);
        }

        private LogicalType parseVarCharType() {
            int length = this.parseStringType();
            if (length < 0) {
                return new VarCharType();
            }
            return new VarCharType(length);
        }

        private LogicalType parseBinaryType() {
            int length = this.parseStringType();
            if (length < 0) {
                return new BinaryType();
            }
            return new BinaryType(length);
        }

        private LogicalType parseVarBinaryType() {
            int length = this.parseStringType();
            if (length < 0) {
                return new VarBinaryType();
            }
            return new VarBinaryType(length);
        }

        private LogicalType parseDecimalType() {
            int precision = 10;
            int scale = 0;
            if (this.hasNextToken(TokenType.BEGIN_PARAMETER)) {
                this.nextToken(TokenType.BEGIN_PARAMETER);
                this.nextToken(TokenType.LITERAL_INT);
                precision = this.tokenAsInt();
                if (this.hasNextToken(TokenType.LIST_SEPARATOR)) {
                    this.nextToken(TokenType.LIST_SEPARATOR);
                    this.nextToken(TokenType.LITERAL_INT);
                    scale = this.tokenAsInt();
                }
                this.nextToken(TokenType.END_PARAMETER);
            }
            return new DecimalType(precision, scale);
        }

        private LogicalType parseDoubleType() {
            if (this.hasNextToken(Keyword.PRECISION)) {
                this.nextToken(Keyword.PRECISION);
            }
            return new DoubleType();
        }

        private LogicalType parseTimeType() {
            int precision = this.parseOptionalPrecision(0);
            if (this.hasNextToken(Keyword.WITHOUT)) {
                this.nextToken(Keyword.WITHOUT);
                this.nextToken(Keyword.TIME);
                this.nextToken(Keyword.ZONE);
            }
            return new TimeType(precision);
        }

        private LogicalType parseTimestampType() {
            int precision = this.parseOptionalPrecision(6);
            if (this.hasNextToken(Keyword.WITHOUT)) {
                this.nextToken(Keyword.WITHOUT);
                this.nextToken(Keyword.TIME);
                this.nextToken(Keyword.ZONE);
            } else if (this.hasNextToken(Keyword.WITH)) {
                this.nextToken(Keyword.WITH);
                if (this.hasNextToken(Keyword.LOCAL)) {
                    this.nextToken(Keyword.LOCAL);
                    this.nextToken(Keyword.TIME);
                    this.nextToken(Keyword.ZONE);
                    return new LocalZonedTimestampType(precision);
                }
                this.nextToken(Keyword.TIME);
                this.nextToken(Keyword.ZONE);
                return new ZonedTimestampType(precision);
            }
            return new TimestampType(precision);
        }

        private LogicalType parseTimestampLtzType() {
            int precision = this.parseOptionalPrecision(6);
            return new LocalZonedTimestampType(precision);
        }

        private LogicalType parseIntervalType() {
            this.nextToken(TokenType.KEYWORD);
            switch (this.tokenAsKeyword()) {
                case YEAR: 
                case MONTH: {
                    return this.parseYearMonthIntervalType();
                }
                case DAY: 
                case HOUR: 
                case MINUTE: 
                case SECOND: {
                    return this.parseDayTimeIntervalType();
                }
            }
            throw this.parsingError("Invalid interval resolution.");
        }

        private LogicalType parseYearMonthIntervalType() {
            int yearPrecision = 2;
            switch (this.tokenAsKeyword()) {
                case YEAR: {
                    yearPrecision = this.parseOptionalPrecision(yearPrecision);
                    if (this.hasNextToken(Keyword.TO)) {
                        this.nextToken(Keyword.TO);
                        this.nextToken(Keyword.MONTH);
                        return new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.YEAR_TO_MONTH, yearPrecision);
                    }
                    return new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.YEAR, yearPrecision);
                }
                case MONTH: {
                    return new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.MONTH, yearPrecision);
                }
            }
            throw this.parsingError("Invalid year-month interval resolution.");
        }

        private LogicalType parseDayTimeIntervalType() {
            int dayPrecision = 2;
            int fractionalPrecision = 6;
            switch (this.tokenAsKeyword()) {
                case DAY: {
                    dayPrecision = this.parseOptionalPrecision(dayPrecision);
                    if (this.hasNextToken(Keyword.TO)) {
                        this.nextToken(Keyword.TO);
                        this.nextToken(TokenType.KEYWORD);
                        switch (this.tokenAsKeyword()) {
                            case HOUR: {
                                return new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.DAY_TO_HOUR, dayPrecision, fractionalPrecision);
                            }
                            case MINUTE: {
                                return new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.DAY_TO_MINUTE, dayPrecision, fractionalPrecision);
                            }
                            case SECOND: {
                                fractionalPrecision = this.parseOptionalPrecision(fractionalPrecision);
                                return new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.DAY_TO_SECOND, dayPrecision, fractionalPrecision);
                            }
                        }
                        throw this.parsingError("Invalid day-time interval resolution.");
                    }
                    return new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.DAY, dayPrecision, fractionalPrecision);
                }
                case HOUR: {
                    if (this.hasNextToken(Keyword.TO)) {
                        this.nextToken(Keyword.TO);
                        this.nextToken(TokenType.KEYWORD);
                        switch (this.tokenAsKeyword()) {
                            case MINUTE: {
                                return new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.HOUR_TO_MINUTE, dayPrecision, fractionalPrecision);
                            }
                            case SECOND: {
                                fractionalPrecision = this.parseOptionalPrecision(fractionalPrecision);
                                return new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.HOUR_TO_SECOND, dayPrecision, fractionalPrecision);
                            }
                        }
                        throw this.parsingError("Invalid day-time interval resolution.");
                    }
                    return new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.HOUR, dayPrecision, fractionalPrecision);
                }
                case MINUTE: {
                    if (this.hasNextToken(Keyword.TO)) {
                        this.nextToken(Keyword.TO);
                        this.nextToken(Keyword.SECOND);
                        fractionalPrecision = this.parseOptionalPrecision(fractionalPrecision);
                        return new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.MINUTE_TO_SECOND, dayPrecision, fractionalPrecision);
                    }
                    return new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.MINUTE, dayPrecision, fractionalPrecision);
                }
                case SECOND: {
                    fractionalPrecision = this.parseOptionalPrecision(fractionalPrecision);
                    return new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.SECOND, dayPrecision, fractionalPrecision);
                }
            }
            throw this.parsingError("Invalid day-time interval resolution.");
        }

        private int parseOptionalPrecision(int defaultPrecision) {
            int precision = defaultPrecision;
            if (this.hasNextToken(TokenType.BEGIN_PARAMETER)) {
                this.nextToken(TokenType.BEGIN_PARAMETER);
                this.nextToken(TokenType.LITERAL_INT);
                precision = this.tokenAsInt();
                this.nextToken(TokenType.END_PARAMETER);
            }
            return precision;
        }

        private LogicalType parseArrayType() {
            this.nextToken(TokenType.BEGIN_SUBTYPE);
            LogicalType elementType = this.parseTypeWithNullability();
            this.nextToken(TokenType.END_SUBTYPE);
            return new ArrayType(elementType);
        }

        private LogicalType parseMultisetType() {
            this.nextToken(TokenType.BEGIN_SUBTYPE);
            LogicalType elementType = this.parseTypeWithNullability();
            this.nextToken(TokenType.END_SUBTYPE);
            return new MultisetType(elementType);
        }

        private LogicalType parseMapType() {
            this.nextToken(TokenType.BEGIN_SUBTYPE);
            LogicalType keyType = this.parseTypeWithNullability();
            this.nextToken(TokenType.LIST_SEPARATOR);
            LogicalType valueType = this.parseTypeWithNullability();
            this.nextToken(TokenType.END_SUBTYPE);
            return new MapType(keyType, valueType);
        }

        private LogicalType parseRowType() {
            List<RowType.RowField> fields;
            if (this.hasNextToken(TokenType.BEGIN_PARAMETER)) {
                this.nextToken(TokenType.BEGIN_PARAMETER);
                fields = this.parseRowFields(TokenType.END_PARAMETER);
                this.nextToken(TokenType.END_PARAMETER);
            } else {
                this.nextToken(TokenType.BEGIN_SUBTYPE);
                fields = this.parseRowFields(TokenType.END_SUBTYPE);
                this.nextToken(TokenType.END_SUBTYPE);
            }
            return new RowType(fields);
        }

        private List<RowType.RowField> parseRowFields(TokenType endToken) {
            ArrayList<RowType.RowField> fields = new ArrayList<RowType.RowField>();
            boolean isFirst = true;
            while (!this.hasNextToken(endToken)) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    this.nextToken(TokenType.LIST_SEPARATOR);
                }
                this.nextToken(TokenType.IDENTIFIER);
                String name = this.tokenAsString();
                LogicalType type = this.parseTypeWithNullability();
                if (this.hasNextToken(TokenType.LITERAL_STRING)) {
                    this.nextToken(TokenType.LITERAL_STRING);
                    String description = this.tokenAsString();
                    fields.add(new RowType.RowField(name, type, description));
                    continue;
                }
                fields.add(new RowType.RowField(name, type));
            }
            return fields;
        }

        private LogicalType parseRawType() {
            this.nextToken(TokenType.BEGIN_PARAMETER);
            this.nextToken(TokenType.LITERAL_STRING);
            String className = this.tokenAsString();
            this.nextToken(TokenType.LIST_SEPARATOR);
            this.nextToken(TokenType.LITERAL_STRING);
            String serializerString = this.tokenAsString();
            this.nextToken(TokenType.END_PARAMETER);
            return RawType.restore(this.classLoader, className, serializerString);
        }

        private LogicalType parseLegacyType() {
            this.nextToken(TokenType.BEGIN_PARAMETER);
            this.nextToken(TokenType.LITERAL_STRING);
            String rootString = this.tokenAsString();
            this.nextToken(TokenType.LIST_SEPARATOR);
            this.nextToken(TokenType.LITERAL_STRING);
            String typeInfoString = this.tokenAsString();
            this.nextToken(TokenType.END_PARAMETER);
            try {
                LogicalTypeRoot root = LogicalTypeRoot.valueOf(rootString);
                TypeInformation<?> typeInfo = TypeStringUtils.readTypeInfo(typeInfoString);
                return new LegacyTypeInformationType(root, typeInfo);
            }
            catch (Throwable t) {
                throw this.parsingError("Unable to restore the Legacy type of '" + typeInfoString + "' with type root '" + rootString + "'.", t);
            }
        }
    }

    private static class Token {
        public final TokenType type;
        public final int cursorPosition;
        public final String value;

        public Token(TokenType type, int cursorPosition, String value) {
            this.type = type;
            this.cursorPosition = cursorPosition;
            this.value = value;
        }
    }

    private static enum Keyword {
        CHAR,
        VARCHAR,
        STRING,
        BOOLEAN,
        BINARY,
        VARBINARY,
        BYTES,
        DECIMAL,
        NUMERIC,
        DEC,
        TINYINT,
        SMALLINT,
        INT,
        INTEGER,
        BIGINT,
        FLOAT,
        DOUBLE,
        PRECISION,
        DATE,
        TIME,
        WITH,
        WITHOUT,
        LOCAL,
        ZONE,
        TIMESTAMP,
        TIMESTAMP_LTZ,
        INTERVAL,
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MINUTE,
        SECOND,
        TO,
        ARRAY,
        MULTISET,
        MAP,
        ROW,
        NULL,
        RAW,
        LEGACY,
        NOT;

    }

    private static enum TokenType {
        BEGIN_SUBTYPE,
        END_SUBTYPE,
        BEGIN_PARAMETER,
        END_PARAMETER,
        LIST_SEPARATOR,
        LITERAL_STRING,
        LITERAL_INT,
        KEYWORD,
        IDENTIFIER,
        IDENTIFIER_SEPARATOR;

    }
}

