/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.influxdb;

import java.time.Instant;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.OkHttpClient;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.influxdb.AbstractReporter;
import org.apache.flink.metrics.influxdb.InfluxdbReporterOptions;
import org.apache.flink.metrics.influxdb.MeasurementInfo;
import org.apache.flink.metrics.influxdb.MeasurementInfoProvider;
import org.apache.flink.metrics.influxdb.MetricMapper;
import org.apache.flink.metrics.reporter.Scheduled;
import org.apache.flink.util.NetUtils;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.BatchPoints;

public class InfluxdbReporter
extends AbstractReporter<MeasurementInfo>
implements Scheduled {
    private String database;
    private String retentionPolicy;
    private InfluxDB.ConsistencyLevel consistency;
    private InfluxDB influxDB;

    public InfluxdbReporter() {
        super(new MeasurementInfoProvider());
    }

    public void open(MetricConfig config) {
        String host = InfluxdbReporterOptions.getString(config, InfluxdbReporterOptions.HOST);
        InfluxdbReporterOptions.Scheme scheme = InfluxdbReporterOptions.getScheme(config);
        int port = InfluxdbReporterOptions.getInteger(config, InfluxdbReporterOptions.PORT);
        if (!InfluxdbReporter.isValidHost(host) || !NetUtils.isValidClientPort((int)port)) {
            throw new IllegalArgumentException("Invalid host/port configuration. Host: " + host + " Port: " + port);
        }
        String database = InfluxdbReporterOptions.getString(config, InfluxdbReporterOptions.DB);
        if (database == null) {
            throw new IllegalArgumentException("'" + InfluxdbReporterOptions.DB.key() + "' configuration option is not set");
        }
        String url = String.format("%s://%s:%d", new Object[]{scheme, host, port});
        String username = InfluxdbReporterOptions.getString(config, InfluxdbReporterOptions.USERNAME);
        String password = InfluxdbReporterOptions.getString(config, InfluxdbReporterOptions.PASSWORD);
        this.database = database;
        this.retentionPolicy = InfluxdbReporterOptions.getString(config, InfluxdbReporterOptions.RETENTION_POLICY);
        this.consistency = InfluxdbReporterOptions.getConsistencyLevel(config, InfluxdbReporterOptions.CONSISTENCY);
        int connectTimeout = InfluxdbReporterOptions.getInteger(config, InfluxdbReporterOptions.CONNECT_TIMEOUT);
        int writeTimeout = InfluxdbReporterOptions.getInteger(config, InfluxdbReporterOptions.WRITE_TIMEOUT);
        OkHttpClient.Builder client = new OkHttpClient.Builder().connectTimeout(connectTimeout, TimeUnit.MILLISECONDS).writeTimeout(writeTimeout, TimeUnit.MILLISECONDS);
        this.influxDB = username != null && password != null ? InfluxDBFactory.connect(url, username, password, client) : InfluxDBFactory.connect(url, client);
        this.log.info("Configured InfluxDBReporter with {host:{}, port:{}, db:{}, retentionPolicy:{} and consistency:{}}", new Object[]{host, port, database, this.retentionPolicy, this.consistency.name()});
    }

    public void close() {
        if (this.influxDB != null) {
            this.influxDB.close();
            this.influxDB = null;
        }
    }

    public void report() {
        BatchPoints report = this.buildReport();
        if (report != null) {
            this.influxDB.write(report);
        }
    }

    @Nullable
    private BatchPoints buildReport() {
        Instant timestamp = Instant.now();
        BatchPoints.Builder report = BatchPoints.database(this.database);
        report.retentionPolicy(this.retentionPolicy);
        report.consistency(this.consistency);
        try {
            for (Map.Entry entry : this.gauges.entrySet()) {
                report.point(MetricMapper.map((MeasurementInfo)entry.getValue(), timestamp, (Gauge)entry.getKey()));
            }
            for (Map.Entry entry : this.counters.entrySet()) {
                report.point(MetricMapper.map((MeasurementInfo)entry.getValue(), timestamp, (Counter)entry.getKey()));
            }
            for (Map.Entry entry : this.histograms.entrySet()) {
                report.point(MetricMapper.map((MeasurementInfo)entry.getValue(), timestamp, (Histogram)entry.getKey()));
            }
            for (Map.Entry entry : this.meters.entrySet()) {
                report.point(MetricMapper.map((MeasurementInfo)entry.getValue(), timestamp, (Meter)entry.getKey()));
            }
        }
        catch (ConcurrentModificationException | NoSuchElementException e) {
            return null;
        }
        return report.build();
    }

    private static boolean isValidHost(String host) {
        return host != null && !host.isEmpty();
    }
}

