/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.multipleinput;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorV2;
import org.apache.flink.streaming.api.operators.Input;
import org.apache.flink.streaming.api.operators.MultipleInputStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.multipleinput.TableOperatorWrapper;
import org.apache.flink.table.runtime.operators.multipleinput.input.FirstInputOfTwoInput;
import org.apache.flink.table.runtime.operators.multipleinput.input.InputSpec;
import org.apache.flink.table.runtime.operators.multipleinput.input.OneInput;
import org.apache.flink.table.runtime.operators.multipleinput.input.SecondInputOfTwoInput;
import org.apache.flink.table.runtime.operators.multipleinput.output.BroadcastingOutput;
import org.apache.flink.table.runtime.operators.multipleinput.output.CopyingBroadcastingOutput;
import org.apache.flink.table.runtime.operators.multipleinput.output.CopyingFirstInputOfTwoInputStreamOperatorOutput;
import org.apache.flink.table.runtime.operators.multipleinput.output.CopyingOneInputStreamOperatorOutput;
import org.apache.flink.table.runtime.operators.multipleinput.output.CopyingSecondInputOfTwoInputStreamOperatorOutput;
import org.apache.flink.table.runtime.operators.multipleinput.output.FirstInputOfTwoInputStreamOperatorOutput;
import org.apache.flink.table.runtime.operators.multipleinput.output.OneInputStreamOperatorOutput;
import org.apache.flink.table.runtime.operators.multipleinput.output.SecondInputOfTwoInputStreamOperatorOutput;
import org.apache.flink.util.Preconditions;

public abstract class MultipleInputStreamOperatorBase
extends AbstractStreamOperatorV2<RowData>
implements MultipleInputStreamOperator<RowData> {
    private final List<InputSpec> inputSpecs;
    protected final Map<Integer, InputSpec> inputSpecMap;
    private final List<TableOperatorWrapper<?>> headWrappers;
    private final TableOperatorWrapper<?> tailWrapper;
    protected final Deque<TableOperatorWrapper<?>> topologicalOrderingOperators;

    public MultipleInputStreamOperatorBase(StreamOperatorParameters<RowData> parameters, List<InputSpec> inputSpecs, List<TableOperatorWrapper<?>> headWrappers, TableOperatorWrapper<?> tailWrapper) {
        super(parameters, inputSpecs.size());
        this.inputSpecs = inputSpecs;
        this.headWrappers = headWrappers;
        this.tailWrapper = tailWrapper;
        this.topologicalOrderingOperators = this.getAllOperatorsAsTopologicalOrdering();
        this.createAllOperators(parameters);
        this.inputSpecMap = inputSpecs.stream().collect(Collectors.toMap(InputSpec::getMultipleInputId, s -> s));
        Preconditions.checkArgument((this.inputSpecMap.size() == inputSpecs.size() ? 1 : 0) != 0);
    }

    public List<Input> getInputs() {
        return this.inputSpecs.stream().map(this::createInput).collect(Collectors.toList());
    }

    private Input createInput(InputSpec inputSpec) {
        Object operator = inputSpec.getOutput().getStreamOperator();
        if (operator instanceof OneInputStreamOperator) {
            return new OneInput((OneInputStreamOperator<RowData, RowData>)((OneInputStreamOperator)operator));
        }
        if (operator instanceof TwoInputStreamOperator) {
            TwoInputStreamOperator twoInputOp = (TwoInputStreamOperator)operator;
            if (inputSpec.getOutputOpInputId() == 1) {
                return new FirstInputOfTwoInput((TwoInputStreamOperator<RowData, RowData, RowData>)twoInputOp);
            }
            return new SecondInputOfTwoInput((TwoInputStreamOperator<RowData, RowData, RowData>)twoInputOp);
        }
        throw new RuntimeException("Unsupported StreamOperator: " + operator);
    }

    public void open() throws Exception {
        super.open();
        Iterator<TableOperatorWrapper<?>> it = this.topologicalOrderingOperators.descendingIterator();
        while (it.hasNext()) {
            Object operator = it.next().getStreamOperator();
            operator.open();
        }
    }

    public void finish() throws Exception {
        super.finish();
        for (TableOperatorWrapper<?> wrapper : this.topologicalOrderingOperators) {
            Object operator = wrapper.getStreamOperator();
            operator.finish();
        }
    }

    public void close() throws Exception {
        super.close();
        for (TableOperatorWrapper<?> wrapper : this.topologicalOrderingOperators) {
            wrapper.close();
        }
    }

    private Deque<TableOperatorWrapper<?>> getAllOperatorsAsTopologicalOrdering() {
        ArrayDeque allOperators = new ArrayDeque();
        LinkedList toVisitOperators = new LinkedList();
        Map<TableOperatorWrapper<?>, Integer> operatorToInputCount = this.buildOperatorToInputCountMap();
        for (TableOperatorWrapper<?> wrapper : this.headWrappers) {
            if (operatorToInputCount.get(wrapper) != 0) continue;
            toVisitOperators.add(wrapper);
        }
        Preconditions.checkArgument((!toVisitOperators.isEmpty() ? 1 : 0) != 0, (Object)"This should not happen.");
        while (!toVisitOperators.isEmpty()) {
            TableOperatorWrapper wrapper = (TableOperatorWrapper)toVisitOperators.poll();
            allOperators.add(wrapper);
            for (TableOperatorWrapper<?> output : wrapper.getOutputWrappers()) {
                int inputCountRemaining = operatorToInputCount.get(output) - 1;
                operatorToInputCount.put(output, inputCountRemaining);
                if (inputCountRemaining != 0) continue;
                toVisitOperators.add(output);
            }
        }
        return allOperators;
    }

    private Map<TableOperatorWrapper<?>, Integer> buildOperatorToInputCountMap() {
        IdentityHashMap operatorToInputCount = new IdentityHashMap();
        LinkedList toVisitOperators = new LinkedList();
        toVisitOperators.add(this.tailWrapper);
        while (!toVisitOperators.isEmpty()) {
            TableOperatorWrapper wrapper = (TableOperatorWrapper)toVisitOperators.poll();
            List<TableOperatorWrapper<?>> inputs = wrapper.getInputWrappers();
            operatorToInputCount.put(wrapper, inputs.size());
            toVisitOperators.addAll(inputs);
        }
        return operatorToInputCount;
    }

    private void createAllOperators(StreamOperatorParameters<RowData> parameters) {
        boolean isObjectReuseEnabled = parameters.getContainingTask().getExecutionConfig().isObjectReuseEnabled();
        ExecutionConfig executionConfig = parameters.getContainingTask().getExecutionConfig();
        Iterator<TableOperatorWrapper<?>> it = this.topologicalOrderingOperators.descendingIterator();
        while (it.hasNext()) {
            Object output;
            TableOperatorWrapper<?> wrapper = it.next();
            if (wrapper == this.tailWrapper) {
                output = this.output;
            } else {
                int numberOfOutputs = wrapper.getOutputEdges().size();
                Output[] outputs = new Output[numberOfOutputs];
                for (int i = 0; i < numberOfOutputs; ++i) {
                    TableOperatorWrapper.Edge edge = wrapper.getOutputEdges().get(i);
                    int inputId = edge.getInputId();
                    Object outputOperator = edge.getTarget().getStreamOperator();
                    if (isObjectReuseEnabled) {
                        outputs[i] = this.createOutput((StreamOperator<RowData>)outputOperator, inputId);
                        continue;
                    }
                    TypeSerializer serializer = edge.getSource().getOutputType().createSerializer(executionConfig);
                    outputs[i] = this.createCopyingOutput((TypeSerializer<RowData>)serializer, (StreamOperator<RowData>)outputOperator, inputId);
                }
                output = outputs.length == 1 ? outputs[0] : (isObjectReuseEnabled ? new CopyingBroadcastingOutput(outputs) : new BroadcastingOutput(outputs));
            }
            StreamOperatorParameters<RowData> newParameters = this.createSubOperatorParameters(parameters, (Output<StreamRecord<RowData>>)output, wrapper);
            wrapper.createOperator(newParameters);
        }
    }

    private StreamOperatorParameters<RowData> createSubOperatorParameters(StreamOperatorParameters<RowData> multipleInputOperatorParameters, Output<StreamRecord<RowData>> output, TableOperatorWrapper<?> wrapper) {
        StreamConfig streamConfig = this.createStreamConfig(multipleInputOperatorParameters, wrapper);
        return new StreamOperatorParameters(multipleInputOperatorParameters.getContainingTask(), streamConfig, output, () -> multipleInputOperatorParameters.getProcessingTimeService(), multipleInputOperatorParameters.getOperatorEventDispatcher());
    }

    protected StreamConfig createStreamConfig(StreamOperatorParameters<RowData> multipleInputOperatorParameters, TableOperatorWrapper<?> wrapper) {
        ExecutionConfig executionConfig = this.getExecutionConfig();
        StreamConfig streamConfig = new StreamConfig(multipleInputOperatorParameters.getStreamConfig().getConfiguration().clone());
        streamConfig.setOperatorName(wrapper.getOperatorName());
        streamConfig.setNumberOfNetworkInputs(wrapper.getAllInputTypes().size());
        streamConfig.setNumberOfOutputs(wrapper.getOutputEdges().size());
        streamConfig.setupNetworkInputs((TypeSerializer[])wrapper.getAllInputTypes().stream().map(t -> t.createSerializer(executionConfig)).toArray(TypeSerializer[]::new));
        streamConfig.setTypeSerializerOut(wrapper.getOutputType().createSerializer(executionConfig));
        streamConfig.serializeAllConfigs();
        return streamConfig;
    }

    private Output<StreamRecord<RowData>> createOutput(StreamOperator<RowData> outputOperator, int inputId) {
        if (outputOperator instanceof OneInputStreamOperator) {
            OneInputStreamOperator oneInputOp = (OneInputStreamOperator)outputOperator;
            return new OneInputStreamOperatorOutput((OneInputStreamOperator<RowData, RowData>)oneInputOp);
        }
        if (outputOperator instanceof TwoInputStreamOperator) {
            TwoInputStreamOperator twoInputOp = (TwoInputStreamOperator)outputOperator;
            if (inputId == 1) {
                return new FirstInputOfTwoInputStreamOperatorOutput((TwoInputStreamOperator<RowData, RowData, RowData>)twoInputOp);
            }
            return new SecondInputOfTwoInputStreamOperatorOutput((TwoInputStreamOperator<RowData, RowData, RowData>)twoInputOp);
        }
        throw new RuntimeException("Unsupported StreamOperator: " + outputOperator);
    }

    private Output<StreamRecord<RowData>> createCopyingOutput(TypeSerializer<RowData> serializer, StreamOperator<RowData> outputOperator, int inputId) {
        if (outputOperator instanceof OneInputStreamOperator) {
            OneInputStreamOperator oneInputOp = (OneInputStreamOperator)outputOperator;
            return new CopyingOneInputStreamOperatorOutput((OneInputStreamOperator<RowData, RowData>)oneInputOp, serializer);
        }
        if (outputOperator instanceof TwoInputStreamOperator) {
            TwoInputStreamOperator twoInputOp = (TwoInputStreamOperator)outputOperator;
            if (inputId == 1) {
                return new CopyingFirstInputOfTwoInputStreamOperatorOutput((TwoInputStreamOperator<RowData, RowData, RowData>)twoInputOp, serializer);
            }
            return new CopyingSecondInputOfTwoInputStreamOperatorOutput((TwoInputStreamOperator<RowData, RowData, RowData>)twoInputOp, serializer);
        }
        throw new RuntimeException("Unsupported StreamOperator: " + outputOperator);
    }
}

