/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.shaded.com.jayway.jsonpath.spi.mapper;

import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JavaType;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.table.shaded.com.jayway.jsonpath.Configuration;
import org.apache.flink.table.shaded.com.jayway.jsonpath.TypeRef;
import org.apache.flink.table.shaded.com.jayway.jsonpath.spi.mapper.MappingException;
import org.apache.flink.table.shaded.com.jayway.jsonpath.spi.mapper.MappingProvider;

public class JacksonMappingProvider
implements MappingProvider {
    private final ObjectMapper objectMapper;

    public JacksonMappingProvider() {
        this(new ObjectMapper());
    }

    public JacksonMappingProvider(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public <T> T map(Object source, Class<T> targetType, Configuration configuration) {
        if (source == null) {
            return null;
        }
        try {
            return (T)this.objectMapper.convertValue(source, targetType);
        }
        catch (Exception e) {
            throw new MappingException(e);
        }
    }

    @Override
    public <T> T map(Object source, TypeRef<T> targetType, Configuration configuration) {
        if (source == null) {
            return null;
        }
        JavaType type = this.objectMapper.getTypeFactory().constructType(targetType.getType());
        try {
            return (T)this.objectMapper.convertValue(source, type);
        }
        catch (Exception e) {
            throw new MappingException(e);
        }
    }
}

