/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.util;

import java.text.ParseException;
import org.apache.hc.core5.util.Deadline;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestDeadline {
    TestDeadline() {
    }

    @Test
    void testFormat() throws ParseException {
        Deadline deadline = Deadline.fromUnixMilliseconds((long)1000L);
        Deadline deadline2 = Deadline.parse((String)deadline.toString());
        Assertions.assertEquals((long)1000L, (long)deadline2.getValue());
    }

    @Test
    void testIsBefore() {
        long nowPlusOneMin = System.currentTimeMillis() + 60000L;
        Deadline deadline = Deadline.fromUnixMilliseconds((long)nowPlusOneMin);
        Assertions.assertTrue((boolean)deadline.isBefore(nowPlusOneMin + 1L));
    }

    @Test
    void testIsExpired() {
        Assertions.assertTrue((boolean)Deadline.fromUnixMilliseconds((long)0L).isExpired());
        Assertions.assertTrue((boolean)Deadline.fromUnixMilliseconds((long)1L).isExpired());
        Assertions.assertFalse((boolean)Deadline.MAX_VALUE.isExpired());
        Assertions.assertTrue((boolean)Deadline.MIN_VALUE.isExpired());
    }

    @Test
    void testIsMax() {
        Assertions.assertFalse((boolean)Deadline.fromUnixMilliseconds((long)0L).isMax());
        Assertions.assertFalse((boolean)Deadline.fromUnixMilliseconds((long)1000L).isMax());
        Assertions.assertFalse((boolean)Deadline.MIN_VALUE.isMax());
        Assertions.assertTrue((boolean)Deadline.MAX_VALUE.isMax());
    }

    @Test
    void testIsMin() {
        Assertions.assertTrue((boolean)Deadline.fromUnixMilliseconds((long)0L).isMin());
        Assertions.assertFalse((boolean)Deadline.fromUnixMilliseconds((long)1000L).isMin());
        Assertions.assertFalse((boolean)Deadline.MAX_VALUE.isMin());
        Assertions.assertTrue((boolean)Deadline.MIN_VALUE.isMin());
    }

    @Test
    void testIsNotExpired() {
        Assertions.assertFalse((boolean)Deadline.fromUnixMilliseconds((long)0L).isNotExpired());
        Assertions.assertFalse((boolean)Deadline.fromUnixMilliseconds((long)1L).isNotExpired());
        Assertions.assertTrue((boolean)Deadline.MAX_VALUE.isNotExpired());
        Assertions.assertFalse((boolean)Deadline.MIN_VALUE.isNotExpired());
    }

    @Test
    void testMin() {
        Assertions.assertEquals((Object)Deadline.MIN_VALUE, (Object)Deadline.MIN_VALUE.min(Deadline.MAX_VALUE));
        Assertions.assertEquals((Object)Deadline.MIN_VALUE, (Object)Deadline.MAX_VALUE.min(Deadline.MIN_VALUE));
        Deadline deadline0 = Deadline.fromUnixMilliseconds((long)0L);
        Assertions.assertEquals((Object)Deadline.MIN_VALUE, (Object)deadline0.min(Deadline.MIN_VALUE));
        Assertions.assertEquals((Object)deadline0, (Object)deadline0.min(Deadline.MAX_VALUE));
        Deadline deadline1 = Deadline.fromUnixMilliseconds((long)0L);
        Assertions.assertEquals((Object)Deadline.MIN_VALUE, (Object)deadline1.min(Deadline.MIN_VALUE));
        Assertions.assertEquals((Object)deadline0, (Object)deadline1.min(Deadline.MAX_VALUE));
    }

    @Test
    void testParse() throws ParseException {
        Deadline deadline = Deadline.parse((String)"1969-12-31T17:00:01.000-0700");
        Assertions.assertEquals((long)1000L, (long)deadline.getValue());
    }

    @Test
    void testRemaining() {
        int oneHourInMillis = 3600000;
        long nowPlusOneHour = System.currentTimeMillis() + 3600000L;
        Deadline deadline = Deadline.fromUnixMilliseconds((long)nowPlusOneHour);
        Assertions.assertEquals((long)nowPlusOneHour, (long)deadline.getValue());
        Assertions.assertTrue((deadline.remaining() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((deadline.remaining() <= 3600000L ? 1 : 0) != 0);
    }

    @Test
    void testRemainingTimeValue() {
        int oneHourInMillis = 3600000;
        long nowPlusOneHour = System.currentTimeMillis() + 3600000L;
        Deadline deadline = Deadline.fromUnixMilliseconds((long)nowPlusOneHour);
        Assertions.assertEquals((long)nowPlusOneHour, (long)deadline.getValue());
        Assertions.assertTrue((deadline.remainingTimeValue().toNanoseconds() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((deadline.remainingTimeValue().toMicroseconds() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((deadline.remainingTimeValue().toMilliseconds() > 0L ? 1 : 0) != 0);
    }

    @Test
    void testValue() {
        long nowPlusOneMin = System.currentTimeMillis() + 60000L;
        Deadline deadline = Deadline.fromUnixMilliseconds((long)nowPlusOneMin);
        Assertions.assertEquals((long)nowPlusOneMin, (long)deadline.getValue());
    }
}

