/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.examples;

import java.net.InetAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.Message;
import org.apache.hc.core5.http.impl.Http1StreamListener;
import org.apache.hc.core5.http.impl.bootstrap.AsyncRequesterBootstrap;
import org.apache.hc.core5.http.impl.bootstrap.HttpAsyncRequester;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.message.RequestLine;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.nio.AsyncEntityConsumer;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.entity.StringAsyncEntityConsumer;
import org.apache.hc.core5.http.nio.support.BasicRequestProducer;
import org.apache.hc.core5.http.nio.support.BasicResponseConsumer;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.support.BasicRequestBuilder;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.util.Timeout;

public class AsyncClientSNIExample {
    public static void main(String[] args) throws Exception {
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setSoTimeout(5, TimeUnit.SECONDS).build();
        HttpAsyncRequester requester = AsyncRequesterBootstrap.bootstrap().setIOReactorConfig(ioReactorConfig).setStreamListener(new Http1StreamListener(){

            public void onRequestHead(HttpConnection connection, HttpRequest request) {
                System.out.println(connection.getRemoteAddress() + " " + new RequestLine(request));
            }

            public void onResponseHead(HttpConnection connection, HttpResponse response) {
                System.out.println(connection.getRemoteAddress() + " " + new StatusLine(response));
            }

            public void onExchangeComplete(HttpConnection connection, boolean keepAlive) {
                if (keepAlive) {
                    System.out.println(connection.getRemoteAddress() + " exchange completed (connection kept alive)");
                } else {
                    System.out.println(connection.getRemoteAddress() + " exchange completed (connection closed)");
                }
            }
        }).create();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            System.out.println("HTTP requester shutting down");
            requester.close(CloseMode.GRACEFUL);
        }));
        requester.start();
        InetAddress targetAddress = InetAddress.getByName("www.google.com");
        HttpHost target = new HttpHost("https", targetAddress, "www.google.ch", 443);
        HttpCoreContext context = HttpCoreContext.create();
        CountDownLatch latch = new CountDownLatch(1);
        BasicHttpRequest request = BasicRequestBuilder.get().setPath("/").build();
        requester.execute(target, (AsyncRequestProducer)new BasicRequestProducer((HttpRequest)request, null), (AsyncResponseConsumer)new BasicResponseConsumer((AsyncEntityConsumer)new StringAsyncEntityConsumer()), null, Timeout.ofSeconds((long)5L), (HttpContext)context, (FutureCallback)new FutureCallback<Message<HttpResponse, String>>((HttpRequest)request, context, latch){
            final /* synthetic */ HttpRequest val$request;
            final /* synthetic */ HttpCoreContext val$context;
            final /* synthetic */ CountDownLatch val$latch;
            {
                this.val$request = httpRequest;
                this.val$context = httpCoreContext;
                this.val$latch = countDownLatch;
            }

            public void completed(Message<HttpResponse, String> message) {
                HttpResponse response = (HttpResponse)message.getHead();
                System.out.println(this.val$request.getRequestUri() + "->" + response.getCode());
                SSLSession sslSession = this.val$context.getSSLSession();
                if (sslSession != null) {
                    try {
                        System.out.println("Peer: " + sslSession.getPeerPrincipal());
                        System.out.println("TLS protocol: " + sslSession.getProtocol());
                        System.out.println("TLS cipher suite: " + sslSession.getCipherSuite());
                    }
                    catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                        // empty catch block
                    }
                }
                this.val$latch.countDown();
            }

            public void failed(Exception ex) {
                System.out.println(this.val$request.getRequestUri() + "->" + ex);
                this.val$latch.countDown();
            }

            public void cancelled() {
                System.out.println(this.val$request.getRequestUri() + " cancelled");
                this.val$latch.countDown();
            }
        });
        latch.await();
        System.out.println("Shutting down I/O reactor");
        requester.initiateShutdown();
    }
}

