/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.internal.partitiondistribution;

import static org.apache.ignite.internal.partitiondistribution.PartitionDistributionUtils.calculateAssignments;
import static org.junit.jupiter.api.Assertions.assertEquals;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.junit.jupiter.api.Test;

/**
 * Tests scenarios for the distribution service. Please pay attention that given test doesn't check Rendezvous or any other
 * distribution function it just checks {@link PartitionDistributionUtils} logic.
 */
public class PartitionDistributionServiceTest {
    @Test
    public void testCalculatedAssignmentHappyPath() {
        List<Set<Assignment>> assignments = calculateAssignments(
                Arrays.asList("node0", "node1"),
                10,
                3
        );

        assertEquals(10, assignments.size());

        for (Set<Assignment> partitionAssignment : assignments) {
            assertEquals(2, partitionAssignment.size());
        }
    }

    @Test
    public void testEmptyBaselineAssignmentsCalculation() {
        List<Set<Assignment>> assignments = calculateAssignments(
                Collections.emptyList(),
                10,
                3
        );

        assertEquals(10, assignments.size());

        for (Set<Assignment> partitionAssignment : assignments) {
            assertEquals(0, partitionAssignment.size());
        }
    }
}
