/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.lang;

import java.util.function.Function;
import org.apache.ignite3.lang.IgniteCheckedException;
import org.apache.ignite3.lang.IgniteException;

public class IgniteExceptionMapper<T extends Exception, R extends Exception> {
    private final Class<T> from;
    private final Function<T, R> mapper;

    private IgniteExceptionMapper(Class<T> from, Function<T, R> mapper) {
        this.from = from;
        this.mapper = mapper;
    }

    public Class<T> mappingFrom() {
        return this.from;
    }

    public R map(T exception) {
        return (R)((Exception)this.mapper.apply(exception));
    }

    public static <T extends Exception, R extends IgniteException> IgniteExceptionMapper<T, R> unchecked(Class<T> from, Function<T, R> mapper) {
        return new IgniteExceptionMapper<T, R>(from, mapper);
    }

    public static <T extends Exception, R extends IgniteCheckedException> IgniteExceptionMapper<T, R> checked(Class<T> from, Function<T, R> mapper) {
        return new IgniteExceptionMapper<T, R>(from, mapper);
    }
}

