/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.persistence.utils.pubsub;

import java.util.concurrent.TimeUnit;
import org.apache.ignite.migrationtools.persistence.utils.pubsub.BasicProcessor;

public class RateLimiterProcessor<S>
extends BasicProcessor<S, S> {
    private final int limit;
    private long currentWindow;
    private int currentCounter;

    public RateLimiterProcessor(long timePeriod, TimeUnit timeUnit, int limit) {
        this.limit = (int)((long)limit * timeUnit.toSeconds(timePeriod) * 1024L / 1000L);
        this.currentWindow = 0L;
        this.currentCounter = 0;
    }

    @Override
    public void onNext(S item) {
        long window = System.currentTimeMillis() >> 10;
        if (window > this.currentWindow) {
            this.resetWindow(window);
        } else if (this.currentCounter >= this.limit) {
            long nextWindow = window + 1L;
            long delay = (nextWindow << 10) - System.currentTimeMillis();
            if (delay > 0L) {
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.onError(e);
                }
            }
            this.resetWindow(nextWindow);
        }
        ++this.currentCounter;
        this.subscriber.onNext(item);
    }

    private void resetWindow(long window) {
        this.currentWindow = window;
        this.currentCounter = 0;
    }
}

