/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.log;

import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Objects;

public abstract class Log
implements Comparable<Log> {
    private static final Comparator<Log> COMPARATOR = Comparator.comparingLong(Log::getCurrLogIndex).thenComparing(Log::getCurrLogTerm);
    protected static final int DEFAULT_BUFFER_SIZE = 4096;
    private long currLogIndex;
    private long currLogTerm;
    private volatile boolean applied;
    private volatile Exception exception;
    private long createTime;
    private long enqueueTime;
    private int byteSize = 0;

    public abstract ByteBuffer serialize();

    public abstract void deserialize(ByteBuffer var1);

    public long getCurrLogIndex() {
        return this.currLogIndex;
    }

    public void setCurrLogIndex(long currLogIndex) {
        this.currLogIndex = currLogIndex;
    }

    public long getCurrLogTerm() {
        return this.currLogTerm;
    }

    public void setCurrLogTerm(long currLogTerm) {
        this.currLogTerm = currLogTerm;
    }

    public boolean isApplied() {
        return this.applied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setApplied(boolean applied) {
        Log log = this;
        synchronized (log) {
            this.applied = applied;
            this.notifyAll();
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Log log = (Log)o;
        return this.currLogIndex == log.currLogIndex && this.currLogTerm == log.currLogTerm;
    }

    public int hashCode() {
        return Objects.hash(this.currLogIndex, this.currLogTerm);
    }

    @Override
    public int compareTo(Log o) {
        return COMPARATOR.compare(this, o);
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public long getEnqueueTime() {
        return this.enqueueTime;
    }

    public void setEnqueueTime(long enqueueTime) {
        this.enqueueTime = enqueueTime;
    }

    public long getByteSize() {
        return this.byteSize;
    }

    public void setByteSize(int byteSize) {
        this.byteSize = byteSize;
    }

    public static enum Types {
        ADD_NODE,
        PHYSICAL_PLAN,
        CLOSE_FILE,
        REMOVE_NODE,
        EMPTY_CONTENT,
        TEST_LARGE_CONTENT;

    }
}

