/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.federation.policy.operations;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.util.JSONUtils;
import com.nimbusds.openid.connect.sdk.federation.policy.language.BooleanConfiguration;
import com.nimbusds.openid.connect.sdk.federation.policy.language.OperationName;
import com.nimbusds.openid.connect.sdk.federation.policy.language.PolicyOperation;
import com.nimbusds.openid.connect.sdk.federation.policy.language.PolicyViolationException;
import com.nimbusds.openid.connect.sdk.federation.policy.language.StringConfiguration;
import com.nimbusds.openid.connect.sdk.federation.policy.language.StringListConfiguration;
import com.nimbusds.openid.connect.sdk.federation.policy.language.UntypedOperation;
import com.nimbusds.openid.connect.sdk.federation.policy.operations.Utils;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class ValueOperation
implements PolicyOperation,
BooleanConfiguration,
StringConfiguration,
StringListConfiguration,
UntypedOperation {
    public static final OperationName NAME = new OperationName("value");
    private AtomicBoolean isInit = new AtomicBoolean(false);
    private boolean booleanValue;
    private String stringValue;
    private List<String> stringListValue;

    @Override
    public OperationName getOperationName() {
        return NAME;
    }

    @Override
    public void configure(boolean parameter) {
        this.isInit.set(true);
        this.booleanValue = parameter;
    }

    @Override
    public void configure(String parameter) {
        this.isInit.set(true);
        this.stringValue = parameter;
    }

    @Override
    public void configure(List<String> parameter) {
        this.isInit.set(true);
        this.stringListValue = parameter;
    }

    @Override
    public void parseConfiguration(Object jsonEntity) throws ParseException {
        if (jsonEntity instanceof Boolean) {
            this.configure(JSONUtils.toBoolean(jsonEntity));
        } else if (jsonEntity instanceof String) {
            this.configure(JSONUtils.toString(jsonEntity));
        } else {
            this.configure(JSONUtils.toStringList(jsonEntity));
        }
    }

    @Override
    public boolean getBooleanConfiguration() {
        return this.booleanValue;
    }

    @Override
    public String getStringConfiguration() {
        return this.stringValue;
    }

    @Override
    public List<String> getStringListConfiguration() {
        return this.stringListValue;
    }

    @Override
    public PolicyOperation merge(PolicyOperation other) throws PolicyViolationException {
        ValueOperation otherTyped = Utils.castForMerge(other, ValueOperation.class);
        if (!this.isInit.get() || !otherTyped.isInit.get()) {
            throw new PolicyViolationException("The value operation is not initialized");
        }
        if (this.getStringListConfiguration() != null) {
            if (this.getStringListConfiguration().equals(otherTyped.getStringListConfiguration())) {
                ValueOperation copy = new ValueOperation();
                copy.configure(this.getStringListConfiguration());
                return copy;
            }
            throw new PolicyViolationException("Value mismatch");
        }
        if (this.getStringConfiguration() != null) {
            if (this.getStringConfiguration().equals(otherTyped.getStringConfiguration())) {
                ValueOperation copy = new ValueOperation();
                copy.configure(this.getStringConfiguration());
                return copy;
            }
            throw new PolicyViolationException("Value mismatch");
        }
        if (this.getBooleanConfiguration() == otherTyped.getBooleanConfiguration()) {
            ValueOperation copy = new ValueOperation();
            copy.configure(this.getBooleanConfiguration());
            return copy;
        }
        throw new PolicyViolationException("Value mismatch");
    }

    @Override
    public Object apply(Object value) {
        if (!this.isInit.get()) {
            throw new IllegalStateException("The policy is not initialized");
        }
        if (this.stringListValue != null) {
            return this.stringListValue;
        }
        if (this.stringValue != null) {
            return this.stringValue;
        }
        return this.booleanValue;
    }
}

