/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.mqtt;

import io.moquette.broker.security.IAuthenticator;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.db.auth.AuthException;
import org.apache.iotdb.db.auth.authorizer.BasicAuthorizer;
import org.apache.iotdb.db.auth.authorizer.IAuthorizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerAuthenticator
implements IAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(BrokerAuthenticator.class);

    public boolean checkValid(String clientId, String username, byte[] password) {
        if (StringUtils.isBlank((CharSequence)username) || password == null) {
            return false;
        }
        try {
            IAuthorizer authorizer = BasicAuthorizer.getInstance();
            return authorizer.login(username, new String(password));
        }
        catch (AuthException e) {
            LOG.info("meet error while logging in.", (Throwable)e);
            return false;
        }
    }
}

